/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.ant;

import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.resources.FileResource;

public class Merge
extends Task {
    private LinkedList<FileSet> sources;
    private LinkedList<JCovFile> results;
    private PatternSet filter;
    private File output;
    private File testList;
    private int looseLevel;
    private boolean compressScales;
    private String breakOnError;
    private File template;
    private File skippedList;
    private File fileList;
    private boolean generateScales;
    public File fmlist;
    public LinkedList<FM> fm = new LinkedList();

    public Merge() {
        this.results = new LinkedList();
        this.sources = new LinkedList();
    }

    public void execute() throws BuildException {
        Merger.BreakOnError boe;
        int fmsize;
        Merger merger = new Merger();
        merger.resetDefaults();
        String[] fms = merger.getFm();
        if (this.fmlist != null) {
            try {
                String[] readLines;
                for (String s : readLines = Utils.readLines(this.fmlist.getPath())) {
                    this.fm.add(new FM(s));
                }
            }
            catch (IOException ex) {
                throw new BuildException("Unable to read fmlist", (Throwable)ex);
            }
        }
        if ((fmsize = this.fm.size()) > 0) {
            fms = new String[fmsize];
            int i = 0;
            for (FM f : this.fm) {
                fms[i++] = f.value;
            }
            merger.setClassModifiers(fms);
        }
        if (this.filter != null) {
            String[] incl = merger.getInclude();
            String[] excl = merger.getExclude();
            if (this.filter.getExcludePatterns(this.getProject()) != null) {
                excl = this.filter.getExcludePatterns(this.getProject());
            }
            if (this.filter.getIncludePatterns(this.getProject()) != null) {
                incl = this.filter.getIncludePatterns(this.getProject());
            }
            merger.setFilters(incl, excl, fms);
        }
        if ((boe = Merger.BreakOnError.fromString(this.breakOnError)) == null) {
            boe = Merger.BreakOnError.getDefault();
        }
        merger.setBreakOnError(boe);
        merger.setLoose_lvl(this.looseLevel);
        merger.setRead_scales(this.testList != null || this.generateScales);
        merger.setCompress(this.compressScales);
        Result[] files = null;
        LinkedList<Result> paths = new LinkedList<Result>();
        for (JCovFile file : this.results) {
            paths.add(file.getResult());
        }
        for (FileSet fs : this.sources) {
            for (Object next : fs) {
                if (!(next instanceof FileResource)) continue;
                FileResource file = (FileResource)next;
                paths.add(new Result(file.getFile().getAbsolutePath()));
            }
        }
        if (this.fileList != null) {
            if (!this.fileList.exists() || !this.fileList.isFile()) {
                this.log("WARNING: filelist " + this.fileList + " doesn't exist");
            } else {
                try {
                    String[] filesInList;
                    for (String f : filesInList = Utils.readLines(this.fileList.getPath())) {
                        paths.add(Merger.parseResultFromString(f));
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Error while parsing filelist", (Throwable)ex);
                }
            }
        }
        if (paths.size() < 2) {
            if (paths.size() == 0) {
                throw new BuildException("No jcov files found to merge - need at least 2 jcov files.");
            }
            if (paths.size() == 1) {
                throw new BuildException("Need at least 2 jcov files to merge. Found 1: " + ((Result)paths.getFirst()).getResultPath());
            }
        }
        files = paths.toArray(new Result[paths.size()]);
        paths = null;
        Merger.Merge merge = this.template != null ? new Merger.Merge(files, this.template.getPath()) : new Merger.Merge(files, null);
        try {
            merger.mergeAndWrite(merge, this.testList == null ? null : this.testList.getPath(), this.output == null ? null : this.output.getPath(), this.skippedList == null ? null : this.skippedList.getPath());
        }
        catch (IOException ex) {
            Logger.getLogger(Merge.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (merge.getErrors() > 0) {
            this.log("Merger produced " + merge.getErrors() + " errors while working", 2);
        }
        if (merge.getSkippedCount() > 0) {
            List<String> skippedFiles = merge.getSkippedFiles();
            this.log(skippedFiles.size() + (skippedFiles.size() > 1 ? " file was skipped due to errors" : " files were skipped due to errors"), 2);
            this.log("Skipped file" + (skippedFiles.size() > 1 ? "s: " + Arrays.toString(skippedFiles.toArray(new String[skippedFiles.size()])) : ": " + skippedFiles.get(0)), 3);
            if (this.skippedList != null) {
                this.log("Skipped files list was written to " + this.skippedList, 3);
            }
        }
        if (merge.getResult() == null && boe != Merger.BreakOnError.TEST) {
            throw new BuildException("Merging failed");
        }
    }

    public void setBreakOnError(String breakOnError) {
        this.breakOnError = breakOnError;
    }

    public void setCompressScales(boolean compressScales) {
        this.compressScales = compressScales;
    }

    public void setOutput(File destdir) {
        this.output = destdir;
    }

    public void setLooseLevel(int looseLevel) {
        this.looseLevel = looseLevel;
    }

    public void setSkippedList(File skippedList) {
        this.skippedList = skippedList;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public void setTestList(File testList) {
        this.testList = testList;
    }

    public void setFileList(File fileList) {
        this.fileList = fileList;
    }

    public FileSet createFiles() {
        FileSet fs = new FileSet();
        this.sources.add(fs);
        return fs;
    }

    public PatternSet createFilter() throws Exception {
        if (this.filter != null) {
            throw new BuildException("Filter should be only one");
        }
        this.filter = new PatternSet();
        return this.filter;
    }

    public JCovFile createJcovFile() {
        JCovFile res = new JCovFile();
        this.results.add(res);
        return res;
    }

    public void setGenerateScales(boolean generateScales) {
        this.generateScales = generateScales;
    }

    public void setFmlist(File fmlist) throws IOException {
        String[] lines;
        for (String s : lines = Utils.readLines(fmlist.getPath())) {
            this.fm.add(new FM(s));
        }
        this.fmlist = fmlist;
    }

    public FM createFM() {
        FM f = new FM();
        this.fm.add(f);
        return f;
    }

    public static class FM {
        private String value;

        public FM() {
        }

        public FM(String value) {
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class JCovFile {
        private String respath;
        private String[] testList;
        private int first = -1;
        private int last = -1;

        public void setPath(String path) {
            this.respath = path;
        }

        public void setTestListPath(String path) throws IOException {
            if (this.testList != null) {
                throw new BuildException("Test list is already set by testName attribute");
            }
            this.testList = this.first >= 0 || this.last >= 0 ? Merger.initTestList(path, this.first, this.last) : Merger.initTestList(path);
        }

        public String[] getTestList() {
            if (this.testList == null) {
                String res = new File(this.respath).getName();
                this.testList = new String[]{res};
            }
            return this.testList;
        }

        public void setTestName(String name) {
            if (this.testList != null) {
                throw new BuildException("Test list is already set by testListPath attribute");
            }
            this.testList = new String[]{name};
        }

        private Result getResult() {
            return new Result(this.respath, this.testList);
        }

        public void setFirst(int first) {
            this.first = first;
        }

        public void setLast(int last) {
            this.last = last;
        }
    }
}

