/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.insert.AbstractUniversalInstrumenter;
import com.sun.tdk.jcov.instrument.ClassMorph;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class TmplGen
extends JCovCMDTool {
    private String[] files;
    private AbstractUniversalInstrumenter instrumenter;
    private String flushPath;
    private String template;
    private String[] include;
    private String[] exclude;
    private boolean instrumentAbstract = false;
    private boolean instrumentNative = true;
    private boolean instrumentField = false;
    private boolean instrumentAnonymous = true;
    private boolean instrumentSynthetic = true;
    private InstrumentationOptions.InstrumentationMode mode;
    static final OptionDescr DSC_VERBOSE = new OptionDescr("verbose", "Verbosity", "Enables verbose mode.");

    public static void main(String[] args) {
        TmplGen tool = new TmplGen();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    protected String usageString() {
        return "java com.sun.tdk.jcov.TmplGen [options] filename";
    }

    protected String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.TmplGen -include java.lang.* -type method -template template.xml classes";
    }

    protected String getDescr() {
        return "generates the jcov template.xml";
    }

    protected int run() throws Exception {
        try {
            this.generateAndSave(this.files);
        }
        catch (IOException ioe) {
            throw new Exception("Unexpected error during instrumentation", ioe);
        }
        return 0;
    }

    public void generateAndSave(String[] files) throws IOException {
        this.setDefaultInstrumenter();
        for (String root : files) {
            this.instrumenter.instrument(new File(root), null);
        }
        this.instrumenter.finishWork();
        this.instrumenter = null;
    }

    public void generateTemplate(String[] files) throws IOException {
        if (this.instrumenter == null) {
            this.setDefaultInstrumenter();
        }
        for (String root : files) {
            this.instrumenter.instrument(new File(root), null);
        }
    }

    public void finishWork() {
        if (this.instrumenter == null) {
            throw new IllegalStateException("Instrumenter is not ready");
        }
        this.instrumenter.finishWork();
        this.instrumenter = null;
    }

    public void setDefaultInstrumenter() {
        if (this.instrumenter == null) {
            this.instrumenter = new AbstractUniversalInstrumenter(true, true){
                ClassMorph morph;
                {
                    this.morph = new ClassMorph(new InstrumentationParams(TmplGen.this.instrumentNative, TmplGen.this.instrumentField, TmplGen.this.instrumentAbstract, TmplGen.this.include, TmplGen.this.exclude, TmplGen.this.mode).setInstrumentAnonymous(TmplGen.this.instrumentAnonymous).setInstrumentSynthetic(TmplGen.this.instrumentSynthetic), TmplGen.this.template);
                }

                protected byte[] instrument(byte[] classData, int classLen) throws IOException {
                    byte[] res = new byte[classLen];
                    System.arraycopy(classData, 0, res, 0, classLen);
                    this.morph.morph(res, null, TmplGen.this.flushPath);
                    return res;
                }

                public void finishWork() {
                    this.morph.saveData(TmplGen.this.template, InstrumentationOptions.MERGE.MERGE);
                }
            };
        }
    }

    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_VERBOSE, InstrumentationOptions.DSC_TEMPLATE, InstrumentationOptions.DSC_TYPE, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_ABSTRACT, InstrumentationOptions.DSC_NATIVE, InstrumentationOptions.DSC_FIELD, InstrumentationOptions.DSC_SYNTHETIC, InstrumentationOptions.DSC_ANONYM, ClassMorph.DSC_FLUSH_CLASSES}, (JCovTool)this);
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String abstractValue;
        this.files = opts.getTail();
        if (this.files == null) {
            throw new JCovTool.EnvHandlingException("No input files specified");
        }
        if (opts.isSet(DSC_VERBOSE)) {
            Utils.setLoggingLevel(Level.INFO);
        }
        Utils.addToClasspath(this.files);
        this.flushPath = opts.getValue(ClassMorph.DSC_FLUSH_CLASSES);
        if ("none".equals(this.flushPath)) {
            this.flushPath = null;
        }
        if ((abstractValue = opts.getValue(InstrumentationOptions.DSC_ABSTRACT)).equals("off")) {
            this.instrumentAbstract = false;
        } else if (abstractValue.equals("on")) {
            this.instrumentAbstract = true;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_ABSTRACT.name + "' parameter value error: expected 'on' or 'off'; found: '" + abstractValue + "'");
        }
        String nativeValue = opts.getValue(InstrumentationOptions.DSC_NATIVE);
        if (nativeValue.equals("on")) {
            this.instrumentNative = true;
        } else if (nativeValue.equals("off")) {
            this.instrumentNative = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_NATIVE.name + "' parameter value error: expected 'on' or 'off'; found: '" + nativeValue + "'");
        }
        String fieldValue = opts.getValue(InstrumentationOptions.DSC_FIELD);
        if (fieldValue.equals("on")) {
            this.instrumentField = true;
        } else if (fieldValue.equals("off")) {
            this.instrumentField = false;
        } else {
            throw new JCovTool.EnvHandlingException("'" + InstrumentationOptions.DSC_FIELD.name + "' parameter value error: expected 'on' or 'off'; found: '" + fieldValue + "'");
        }
        String anonym = opts.getValue(InstrumentationOptions.DSC_ANONYM);
        this.instrumentAnonymous = anonym.equals("on");
        String synth = opts.getValue(InstrumentationOptions.DSC_SYNTHETIC);
        this.instrumentSynthetic = synth.equals("on");
        this.mode = InstrumentationOptions.InstrumentationMode.fromString(opts.getValue(InstrumentationOptions.DSC_TYPE));
        this.template = opts.getValue(InstrumentationOptions.DSC_TEMPLATE);
        File tmpl = new File(this.template);
        if (tmpl.isDirectory()) {
            throw new JCovTool.EnvHandlingException("'" + this.template + "' is a directory while expected template filename");
        }
        if (tmpl.getParentFile() != null && !tmpl.getParentFile().exists()) {
            throw new JCovTool.EnvHandlingException("Template parent directory '" + tmpl.getParentFile() + "' doesn't exits");
        }
        this.include = InstrumentationOptions.handleInclude(opts);
        this.exclude = InstrumentationOptions.handleExclude(opts);
        CollectDetect.enableInvokeCounts();
        return 0;
    }

    public String[] getExclude() {
        return this.exclude;
    }

    public void setExclude(String[] exclude) {
        this.exclude = exclude;
    }

    public String getFlushPath() {
        return this.flushPath;
    }

    public void setFlushPath(String flushPath) {
        this.flushPath = flushPath;
    }

    public String[] getInclude() {
        return this.include;
    }

    public void setInclude(String[] include) {
        this.include = include;
    }

    public boolean isInstrumentAbstract() {
        return this.instrumentAbstract;
    }

    public void setInstrumentAbstract(boolean instrumentAbstract) {
        this.instrumentAbstract = instrumentAbstract;
    }

    public boolean isInstrumentField() {
        return this.instrumentField;
    }

    public void setInstrumentField(boolean instrumentField) {
        this.instrumentField = instrumentField;
    }

    public boolean isInstrumentNative() {
        return this.instrumentNative;
    }

    public void setInstrumentNative(boolean instrumentNative) {
        this.instrumentNative = instrumentNative;
    }

    public InstrumentationOptions.InstrumentationMode getMode() {
        return this.mode;
    }

    public void setMode(InstrumentationOptions.InstrumentationMode mode) {
        this.mode = mode;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

