/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Grabber;
import com.sun.tdk.jcov.GrabberManager;
import com.sun.tdk.jcov.ProductInstr;
import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCov
extends JCovCMDTool {
    private String userOutput;
    private String srcRootPath;
    private String command;
    private String template = "template.xml";
    private String result = "result.xml";
    private String reportDirName = "report";
    private int commandsPort = 3336;
    private int testsPort = 3334;
    private final String JCOV_NETWORK_JAR_NAME = "jcov_network_saver.jar";
    private static final Logger logger;
    private final Object lock = new Object();
    public static final OptionDescr DSC_PRODUCT;
    public static final OptionDescr DSC_RUN_COMMAND;
    public static final OptionDescr DSC_OUTPUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run() throws Exception {
        ProductInstr instr = new ProductInstr();
        File productDir = new File(this.srcRootPath);
        if (!productDir.exists()) {
            logger.log(Level.SEVERE, "No product to get coverage");
            return 1;
        }
        if (productDir.isFile()) {
            logger.log(Level.SEVERE, "Set product directory, not file");
            return 1;
        }
        File jcovJar = new File(JCov.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        File networkJar = new File(jcovJar.getParent() + File.separator + "jcov_network_saver.jar");
        if (!networkJar.exists()) {
            logger.log(Level.SEVERE, "Can not find jcov_network_saver.jar in the jcov.jar location");
            logger.log(Level.SEVERE, networkJar.getAbsolutePath());
            return 1;
        }
        File parentProductDir = productDir.getParentFile();
        try {
            Utils.zipFolder(productDir.getAbsolutePath(), parentProductDir.getAbsolutePath() + File.separator + productDir.getName() + ".zip");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Can not zip product", e);
            return 1;
        }
        Utils.addToClasspath(new String[]{this.srcRootPath});
        try {
            instr.run(new String[]{"-product", this.srcRootPath, "-productOutput", parentProductDir.getAbsolutePath() + File.separator + "instr", "-rt", networkJar.getAbsolutePath()});
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while instrument product", ex);
            return 1;
        }
        Utils.deleteDirectory(productDir);
        productDir = new File(productDir.getAbsolutePath());
        productDir.mkdir();
        File instrFiles = new File(parentProductDir.getAbsolutePath() + File.separator + "instr");
        for (File file : instrFiles.listFiles()) {
            if (file.isDirectory()) {
                Utils.copyDirectory(file, new File(productDir, file.getName()));
                continue;
            }
            Utils.copyFile(file, new File(productDir, file.getName()));
        }
        Utils.deleteDirectory(new File(parentProductDir.getAbsolutePath() + File.separator + "instr"));
        GrabberThread grabberThread = new GrabberThread();
        grabberThread.start();
        Object len$ = this.lock;
        synchronized (len$) {
            while (!grabberThread.isStarted()) {
                this.lock.wait();
            }
        }
        try {
            Process process = Runtime.getRuntime().exec(this.command);
            process.waitFor();
            if (process.exitValue() != 0) {
                logger.log(Level.SEVERE, "wrong command for running tests.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception in process", e);
        }
        GrabberManager grabberManager = new GrabberManager();
        grabberManager.setPort(this.commandsPort);
        grabberManager.sendKillCommand();
        RepGen rg = new RepGen();
        File outputFile = networkJar.getParentFile();
        if (this.userOutput != null && !this.userOutput.isEmpty() && !(outputFile = new File(this.userOutput)).exists()) {
            outputFile.mkdirs();
        }
        try {
            Result res = new Result(this.result);
            rg.generateReport(rg.getDefaultReportGenerator(), outputFile.getAbsolutePath() + File.separator + this.reportDirName, res, this.srcRootPath);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error in report generation", e);
        }
        System.out.println("coverage report for product: " + outputFile.getAbsolutePath() + File.separator + this.reportDirName);
        return 0;
    }

    public static void main(String[] args) {
        JCov tool = new JCov();
        try {
            int res = tool.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    protected EnvHandler defineHandler() {
        EnvHandler envHandler = new EnvHandler(new OptionDescr[]{DSC_PRODUCT, DSC_RUN_COMMAND, DSC_OUTPUT}, (JCovTool)this);
        return envHandler;
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        if (opts.isSet(DSC_PRODUCT)) {
            this.srcRootPath = opts.getValue(DSC_PRODUCT);
        }
        if (!opts.isSet(DSC_RUN_COMMAND)) {
            throw new JCovTool.EnvHandlingException("command to run tests is not specified");
        }
        this.command = opts.getValue(DSC_RUN_COMMAND);
        if (opts.isSet(DSC_OUTPUT)) {
            this.userOutput = opts.getValue(DSC_OUTPUT);
        }
        return 0;
    }

    protected String getDescr() {
        return "gets product coverage with one command";
    }

    protected String usageString() {
        return "java -jar jcov.jar JCov -pro productDirPath -command \"java -jar tests.jar\"";
    }

    protected String exampleString() {
        return "java -jar jcov.jar JCov -pro productDirPath -command \"java -jar tests.jar\"";
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(JCov.class.getName());
        DSC_PRODUCT = new OptionDescr("product", new String[]{"product", "pro"}, "Product files.", 1, "");
        DSC_RUN_COMMAND = new OptionDescr("command", new String[]{"command", "cmd"}, "Command to run on product and get coverage", 1, "");
        DSC_OUTPUT = new OptionDescr("output", new String[]{"output", "out", "o"}, "Output dir to create the result report directory", 1, "");
    }

    private class GrabberThread
    extends Thread {
        private boolean started = false;

        public boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Grabber grabber = new Grabber();
                grabber.setCommandPort(JCov.this.commandsPort);
                grabber.setPort(JCov.this.testsPort);
                grabber.setSaveOnReceive(false);
                grabber.setTemplate(JCov.this.template);
                grabber.setOutputFilename(JCov.this.result);
                grabber.start(true);
                Object object = JCov.this.lock;
                synchronized (object) {
                    this.started = true;
                    JCov.this.lock.notifyAll();
                }
                grabber.waitForStopping();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "grabber exception", e);
            }
        }
    }
}

