/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.agent.RStatus;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionHelper {
    protected static final String EXEC_ERROR_CLEANUP = "Error while cleaning up threads after test";
    protected static final String EXEC_PASS = "Execution successful";
    protected static final String UNEXPECT_SYS_EXIT = "Unexpected exit from test";
    protected static final String SAMEVM_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String SAMEVM_CANT_RESET_SECPROVS = "Cannot reset security providers";
    protected static final String SAMEVM_CANT_RESET_PROPS = "Cannot reset system properties";

    private static <T> boolean equal(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray2 == null) {
            return TArray == TArray2;
        }
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == TArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static Map<?, ?> copyProperties(Properties properties) {
        HashMap hashMap = new HashMap();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            hashMap.put(obj, properties.get(obj));
        }
        return hashMap;
    }

    private static Properties newProperties(Map<?, ?> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    protected static OutputHandler getOutputHandler(final TestResult.Section section) {
        return new OutputHandler(){

            public PrintWriter createOutput(OutputHandler.OutputKind outputKind) {
                if (outputKind == OutputHandler.OutputKind.LOG) {
                    return section.getMessageWriter();
                }
                return section.createOutput(outputKind.name);
            }

            public void createOutput(OutputHandler.OutputKind outputKind, String string) {
                PrintWriter printWriter = this.createOutput(outputKind);
                printWriter.write(string);
                printWriter.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Status redirectOutput(PrintStream printStream, PrintStream printStream2) {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager instanceof RegressionSecurityManager) {
                boolean bl = ((RegressionSecurityManager)securityManager).setAllowSetIO(true);
                System.setOut(printStream);
                System.setErr(printStream2);
                ((RegressionSecurityManager)securityManager).setAllowSetIO(bl);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return RStatus.passed("OK");
        }
    }

    public static boolean show(String string) {
        return Boolean.getBoolean("javatest.regtest." + string) || System.getenv("JTREG_" + string.toUpperCase()) != null;
    }

    public static class PrintStringWriter
    extends PrintWriter {
        private final StringWriter w;

        public PrintStringWriter() {
            super(new StringWriter());
            this.w = (StringWriter)this.out;
        }

        public String getOutput() {
            return this.w.toString();
        }
    }

    public static class PrintByteArrayOutputStream
    extends PrintStream {
        private final ByteArrayOutputStream s;

        public PrintByteArrayOutputStream() {
            super(new ByteArrayOutputStream());
            this.s = (ByteArrayOutputStream)this.out;
        }

        public String getOutput() {
            return this.s.toString();
        }
    }

    public static interface OutputHandler {
        public PrintWriter createOutput(OutputKind var1);

        public void createOutput(OutputKind var1, String var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum OutputKind {
            LOG(""),
            STDOUT("System.out"),
            STDERR("System.err"),
            DIRECT("direct"),
            DIRECT_LOG("direct.log");

            public final String name;

            private OutputKind(String string2) {
                this.name = string2;
            }
        }
    }

    static class SaveState {
        final SecurityManager secMgr;
        final PrintStream stdOut;
        final PrintStream stdErr;
        final Locale locale;
        final Provider[] securityProviders;
        static Map<?, ?> sysProps;

        SaveState() {
            if (sysProps == null) {
                sysProps = ActionHelper.copyProperties(System.getProperties());
            }
            this.stdOut = System.out;
            this.stdErr = System.err;
            this.locale = Locale.getDefault();
            this.secMgr = System.getSecurityManager();
            if (this.secMgr instanceof RegressionSecurityManager) {
                RegressionSecurityManager regressionSecurityManager = (RegressionSecurityManager)this.secMgr;
                regressionSecurityManager.setAllowPropertiesAccess(true);
                regressionSecurityManager.resetPropertiesModified();
            }
            this.securityProviders = Security.getProviders();
        }

        Status restore(String string, Status status) {
            Status status2;
            block12: {
                status2 = null;
                try {
                    if (System.getSecurityManager() != this.secMgr) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                System.setSecurityManager(SaveState.this.secMgr);
                                return null;
                            }
                        });
                    }
                }
                catch (SecurityException securityException) {
                    this.stdErr.println();
                    this.stdErr.println("***");
                    this.stdErr.println("*** " + string);
                    this.stdErr.println("*** Cannot reset security manager after test");
                    this.stdErr.println("*** " + securityException.getMessage());
                    this.stdErr.println("***");
                    this.stdErr.println();
                    status2 = RStatus.error("Cannot reset security manager: " + securityException);
                }
                try {
                    Object[] objectArray = Security.getProviders();
                    if (!ActionHelper.equal(this.securityProviders, objectArray)) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>((Provider[])objectArray){
                            final /* synthetic */ Provider[] val$sp;
                            {
                                this.val$sp = providerArray;
                            }

                            @Override
                            public Object run() {
                                for (Provider provider : this.val$sp) {
                                    Security.removeProvider(provider.getName());
                                }
                                for (Provider provider : SaveState.this.securityProviders) {
                                    Security.addProvider(provider);
                                }
                                return null;
                            }
                        });
                    }
                }
                catch (SecurityException securityException) {
                    status2 = RStatus.error("Cannot reset security providers: " + securityException);
                }
                SecurityManager securityManager = System.getSecurityManager();
                boolean bl = securityManager instanceof RegressionSecurityManager ? ((RegressionSecurityManager)securityManager).isPropertiesModified() : true;
                try {
                    if (bl) {
                        System.setProperties(ActionHelper.newProperties(SaveState.sysProps));
                    } else {
                        System.setProperty("java.class.path", (String)sysProps.get("java.class.path"));
                    }
                }
                catch (SecurityException securityException) {
                    if (status2 != null) break block12;
                    status2 = RStatus.error("Cannot reset system properties: " + securityException);
                }
            }
            Status status3 = ActionHelper.redirectOutput(this.stdOut, this.stdErr);
            if (status2 == null && !status3.isPassed()) {
                status2 = status3;
            }
            if (this.locale != Locale.getDefault()) {
                Locale.setDefault(this.locale);
            }
            return status2 != null ? status2 : status;
        }
    }
}

