/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XPrintStream {
    private final ByteArrayOutputStream bstream;
    private final PrintStream ps;
    private final PrintWriter out;
    private final PrintWriter err;
    private static final String INDENT = "    ";

    XPrintStream(PrintWriter printWriter, PrintWriter printWriter2, String string) throws UnsupportedEncodingException {
        this.out = printWriter;
        this.err = printWriter2;
        this.bstream = new ByteArrayOutputStream();
        this.ps = new PrintStream((OutputStream)this.bstream, false, string);
    }

    void indent() {
        this.ps.print(INDENT);
    }

    public void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.indent();
        }
    }

    public void println(String string) {
        this.ps.println(string);
    }

    public void print(String string) {
        this.ps.print(string);
    }

    public void print(double d) {
        this.ps.print(d);
    }

    public void sanitize(String string) {
        if (string == null) {
            return;
        }
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    this.ps.print("&amp;");
                    continue block9;
                }
                case '<': {
                    this.ps.print("&lt;");
                    continue block9;
                }
                case '>': {
                    this.ps.print("&gt;");
                    continue block9;
                }
                case '\"': {
                    this.ps.print("&quot;");
                    continue block9;
                }
                case '\'': {
                    this.ps.print("&apos;");
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.ps.print(c);
                    continue block9;
                }
                case '\\': {
                    if (i + 1 < string.length() && string.charAt(i + 1) == 'u') {
                        this.ps.print("\\uu");
                        ++i;
                        continue block9;
                    }
                    this.ps.print(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || !Character.isDefined(c)) {
                        this.ps.print(String.format("\\u%04x", c));
                        continue block9;
                    }
                    this.ps.print(c);
                }
            }
        }
    }

    public void close() {
        this.ps.close();
    }

    public String toString() {
        return this.bstream.toString();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.bstream.writeTo(outputStream);
    }

    public void verifyXML(File file) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.parse(new InputSource(new ByteArrayInputStream(this.bstream.toByteArray())));
        }
        catch (IOException iOException) {
            this.err.println("File: " + file + ":" + iOException);
            this.err.println(this.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.err.println("File: " + file + ":" + parserConfigurationException);
            this.err.println(this.toString());
        }
        catch (SAXException sAXException) {
            this.err.println("File: " + file + ":" + sAXException);
            this.err.println(this.toString());
        }
    }
}

