/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.agent.Alarm;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutHandler {
    protected final PrintWriter log;
    protected final File outputDir;
    protected final File testJdk;
    private static final long TIMEOUTHANDLER_TIMEOUT = TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS);

    public TimeoutHandler(PrintWriter printWriter, File file, File file2) {
        this.log = printWriter;
        this.outputDir = file;
        this.testJdk = file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTimeout(Process process) {
        this.log.println("Timeout information:");
        long l = 0L;
        try {
            l = TimeoutHandler.getProcessId(process);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.log);
        }
        if (l == 0L) {
            this.log.println("Could not find process id for the process that timed out.");
            this.log.println("Skipping timeout handling.");
            return;
        }
        Alarm alarm = Alarm.schedule(TIMEOUTHANDLER_TIMEOUT, TimeUnit.MILLISECONDS, this.log, Thread.currentThread());
        try {
            try {
                this.runActions(process, l);
            }
            catch (InterruptedException interruptedException) {
                alarm.cancel();
                this.log.println("Timeout handler interrupted: ");
                interruptedException.printStackTrace(this.log);
                Object var7_6 = null;
                alarm.cancel();
            }
            Object var7_5 = null;
            alarm.cancel();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            alarm.cancel();
            throw throwable;
        }
        this.log.println("--- Timeout information end.");
    }

    protected abstract void runActions(Process var1, long var2) throws InterruptedException;

    private static long getProcessId(Process process) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        try {
            Method method = Process.class.getMethod("getPid", new Class[0]);
            return (Long)method.invoke((Object)process, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return TimeoutHandler.getProcessIdPreJdk9(process);
        }
    }

    private static long getProcessIdPreJdk9(Process process) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            Field field = process.getClass().getDeclaredField("pid");
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            int n = field.getInt(process);
            field.setAccessible(bl);
            return n;
        }
        return 0L;
    }
}

