/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.regtest.Expr;
import com.sun.javatest.regtest.RegressionContext;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestProperties;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionTestFinder
extends TagTestFinder {
    Map<String, TestDescription> paths = new HashMap<String, TestDescription>();
    private static final Pattern bugIdPattern = Pattern.compile("(([A-Z]+-)?[0-9]{7})|(14[0-9]{6})");
    public static final String TEST = "test";
    public static final String AUTHOR = "author";
    public static final String BUG = "bug";
    public static final String BUILD = "build";
    public static final String CLEAN = "clean";
    public static final String COMPILE = "compile";
    public static final String ERROR = "error";
    public static final String IGNORE = "ignore";
    public static final String KEY = "key";
    public static final String LIBRARY = "library";
    public static final String MODULES = "modules";
    public static final String REQUIRES = "requires";
    public static final String RUN = "run";
    public static final String SUMMARY = "summary";
    private static final String LINESEP = System.getProperty("line.separator");
    static final String[] excludeNames = new String[]{"SCCS", "Codemgr_wsdata", ".hg", "RCS", ".svn", "DeletedFiles", "DELETED-FILES", "deleted_files", "TemporarilyRemoved"};
    protected static final String PARSE_TAG_BAD = "Invalid tag: ";
    protected static final String PARSE_BUG_EMPTY = "No value provided for `@bug'";
    protected static final String PARSE_BUG_INVALID = "Invalid or unrecognized bugid: ";
    protected static final String PARSE_KEY_EMPTY = "No value provided for `@key'";
    protected static final String PARSE_KEY_BAD = "Invalid key: ";
    protected static final String PARSE_LIB_EMPTY = "No value provided for `@library'";
    protected static final String PARSE_LIB_AFTER_RUN = "`@library' must appear before first `@run'";
    protected static final String PARSE_MODULES_EMPTY = "No values provided for @modules";
    protected static final String PARSE_BAD_MODULE = "Invalid module name in @modules: ";
    protected static final String PARSE_BAD_PACKAGE = "Invalid package name in @modules: ";
    protected static final String PARSE_BAD_RUN = "Explicit action tag not allowed";
    protected static final String PARSE_REQUIRES_EMPTY = "No expression for @requires";
    protected static final String PARSE_REQUIRES_SYNTAX = "Syntax error in @requires expression: ";
    protected static final String PARSE_RUN_ENDS_WITH_BUILD = "No action after @build";
    protected static final String PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED = "Multiple test descriptions not allowed";
    private static final Pattern BOOTCLASSPATH_OPTION = RegressionTestFinder.getOptionPattern("bootclasspath");
    private static final Pattern OTHERVM_OPTION = RegressionTestFinder.getOptionPattern("othervm");
    private static final Pattern MANUAL_OPTION = RegressionTestFinder.getOptionPattern("manual");
    private static final Pattern NATIVE_OPTION = RegressionTestFinder.getOptionPattern("native");
    private static final Pattern SHELL_ACTION = RegressionTestFinder.getActionPattern("shell");
    private static final Pattern JUNIT_ACTION = RegressionTestFinder.getActionPattern("junit");
    private static final Pattern DRIVER_ACTION = RegressionTestFinder.getActionPattern("driver");
    private static final Pattern IGNORE_ACTION = RegressionTestFinder.getActionPattern("ignore");
    private final Set<String> validTagNames;
    private final TestProperties properties;
    private final boolean checkBugID;
    private final RegressionContext baseContext;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestFinder.class);
    private static final boolean rejectTrailingBuild = !Boolean.getBoolean("javatest.regtest.allowTrailingBuild");

    public RegressionTestFinder(TestProperties testProperties) {
        this.properties = testProperties;
        this.checkBugID = testProperties.checkBugID;
        Set<String> set = testProperties.validKeys;
        this.validTagNames = this.getValidTagNames(set != null);
        this.exclude(excludeNames);
        this.addExtension(".sh", ShScriptCommentStream.class);
        this.addExtension(".html", HTMLCommentStream.class);
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
        this.baseContext = new RegressionContext();
    }

    Set<String> getAllowedExtensions() {
        return ((HashMap)this.getField("extensionTable")).keySet();
    }

    Set<String> getIgnoredDirectories() {
        return ((HashMap)this.getField("excludeList")).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object getField(String string) {
        try {
            Field field = TagTestFinder.class.getDeclaredField(string);
            try {
                field.setAccessible(true);
                Object object = field.get(this);
                Object var5_8 = null;
                field.setAccessible(false);
                return object;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                field.setAccessible(false);
                throw throwable;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace(System.err);
            return null;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(System.err);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    protected void setRoot(File file) throws TestFinder.Fault {
        super.setRoot(this.canon(file));
    }

    @Override
    protected void scanFile(File file) {
        if (file.getName().startsWith(",")) {
            return;
        }
        try {
            File file2 = this.properties.getTestNGRoot(file);
            if (file2 != null) {
                this.scanTestNGFile(file2, file);
            } else {
                super.scanFile(file);
            }
        }
        catch (TestSuite.Fault fault) {
            this.error(i18n, "finder.cant.read.test.properties", new Object[]{fault});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void scanTestNGFile(File file, File file2) throws TestSuite.Fault {
        block13: {
            if (this.isTestNGTest(file2)) {
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new FileReader(file2));
                Map<String, String> map = this.readTestNGComments(file2, bufferedReader);
                if (map == null) {
                    map = new HashMap<String, String>();
                }
                String string = file.toURI().relativize(file2.toURI()).getPath();
                String string2 = string.substring(0, string.length() - 5).replace("/", ".");
                map.put("packageRoot", this.getRootDir().toURI().relativize(file.toURI()).getPath());
                map.put("testngClass", string2);
                map.put(LIBRARY, StringUtils.join(this.properties.getLibDirs(file2), " "));
                this.foundTestDescription(map, file2, 0);
                Object var8_8 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block13;
                }
                catch (IOException iOException) {}
                break block13;
                {
                    catch (IOException iOException) {
                        this.error(i18n, "finder.ioError", file2);
                        Object var8_9 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block13;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private Map<String, String> readTestNGComments(File file, BufferedReader bufferedReader) throws IOException {
        String string;
        JavaCommentStream javaCommentStream = new JavaCommentStream();
        javaCommentStream.init(bufferedReader);
        javaCommentStream.setFastScan(true);
        Map map = null;
        int n = 1;
        while ((string = ((CommentStream)javaCommentStream).readComment()) != null) {
            Map map2 = this.parseComment(string, file);
            if (map2.isEmpty()) continue;
            if (map == null) {
                map = map2;
            } else {
                map2.put(ERROR, PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED);
                map2.put("id", String.valueOf(n++));
                this.foundTestDescription(map2, file, 0);
            }
            map.remove(TEST);
        }
        return map;
    }

    protected boolean isTestNGTest(File file) {
        return file.getName().endsWith(".java");
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(file.getAbsoluteFile().toURI().normalize());
        }
    }

    @Override
    protected Map<String, String> normalize(Map map) {
        return this.normalize0(map);
    }

    private Map<String, String> normalize0(Map<String, String> map) {
        int n;
        String pattern;
        String string;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = this.getCurrentFile().getName();
        String string4 = string3.substring(0, string3.lastIndexOf("."));
        boolean bl = map.containsKey("testngClass");
        hashMap.put("title", " ");
        hashMap.put("source", string3);
        if (bl) {
            if (map.get(RUN) != null) {
                map.put(ERROR, PARSE_BAD_RUN);
            }
            object2 = map.get("testngClass");
            hashMap.put(RUN, "ASSUMED_ACTION testng " + (String)object2 + LINESEP);
        } else if (string3.endsWith(".sh")) {
            hashMap.put(RUN, "ASSUMED_ACTION shell " + string3 + LINESEP);
        } else if (string3.endsWith(".java")) {
            hashMap.put(RUN, "ASSUMED_ACTION main " + string4 + LINESEP);
        } else {
            hashMap.put(RUN, "ASSUMED_ACTION applet " + string3 + LINESEP);
        }
        for (Map.Entry object3 : map.entrySet()) {
            String n2;
            block32: {
                string = (String)object3.getKey();
                n2 = (String)object3.getValue();
                if (string.equals(SUMMARY)) {
                    string = "title";
                    int string6 = 0;
                    while ((string6 = n2.indexOf(".", string6)) != -1 && string6 + 1 != n2.length()) {
                        switch (n2.charAt(string6 + 1)) {
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                n2 = n2.substring(0, string6 + 1);
                                break block32;
                            }
                            default: {
                                ++string6;
                                break;
                            }
                        }
                    }
                } else if (string.equals(BUG) || string.equals(KEY)) {
                    string = "keywords";
                    String string7 = (String)hashMap.get("keywords");
                    if (string7 != null) {
                        n2 = string7 + " " + n2;
                    }
                } else if (string.equals(TEST)) {
                    string = "keywords";
                    String string2 = (String)hashMap.get("keywords");
                    n2 = string2 != null ? string2 + " regtest" : "regtest";
                }
            }
            hashMap.put(string, n2);
        }
        object2 = (String)hashMap.get(RUN);
        String string5 = (String)hashMap.get("keywords");
        string = "";
        if (RegressionTestFinder.match((CharSequence)object2, OTHERVM_OPTION) || RegressionTestFinder.match((CharSequence)object2, BOOTCLASSPATH_OPTION)) {
            string = string + " othervm";
        }
        if (RegressionTestFinder.match((CharSequence)object2, MANUAL_OPTION)) {
            string = string + " manual";
        }
        if (RegressionTestFinder.match((CharSequence)object2, NATIVE_OPTION)) {
            string = string + " native";
        }
        if (RegressionTestFinder.match((CharSequence)object2, SHELL_ACTION)) {
            string = string + " shell";
        }
        if (RegressionTestFinder.match((CharSequence)object2, JUNIT_ACTION)) {
            string = string + " junit";
        }
        if (RegressionTestFinder.match((CharSequence)object2, DRIVER_ACTION)) {
            string = string + " driver";
        }
        if (RegressionTestFinder.match((CharSequence)object2, IGNORE_ACTION)) {
            string = string + " ignore";
        }
        if (bl) {
            string = string + " testng";
        }
        if (!string.equals("")) {
            if (string5 == null) {
                hashMap.put("keywords", string.trim());
            } else {
                hashMap.put("keywords", string5 + string);
            }
        }
        if (rejectTrailingBuild && (pattern = ((String)object2).substring((n = ((String)object2).lastIndexOf(LINESEP, ((String)object2).length() - 1 - LINESEP.length())) == -1 ? 0 : n + LINESEP.length())).startsWith("USER_SPECIFIED build")) {
            hashMap.put(ERROR, PARSE_RUN_ENDS_WITH_BUILD);
        }
        int n3 = -1;
        Pattern pattern2 = Pattern.compile("/timeout=([0-9]+)(?:/| )");
        Matcher matcher = pattern2.matcher((CharSequence)object2);
        while (matcher.find()) {
            int n4 = Integer.parseInt(matcher.group(1));
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (n3 > 0) {
            hashMap.put("maxTimeout", String.valueOf(n3));
        }
        return hashMap;
    }

    private static boolean match(CharSequence charSequence, Pattern pattern) {
        return pattern.matcher(charSequence).matches();
    }

    @Override
    protected void processEntry(Map map, String string, String string2) {
        Map map2 = map;
        if (string.startsWith("(#)")) {
            return;
        }
        if (string.startsWith(COMPILE) || string.startsWith(CLEAN) || string.startsWith(BUILD) || string.startsWith(IGNORE)) {
            string2 = string + " " + string2;
            string = RUN;
        }
        try {
            if (!this.validTagNames.contains(string)) {
                this.parseError(map2, PARSE_TAG_BAD + string);
            } else if (string.equals(RUN)) {
                this.processRun(map2, string2);
            } else if (string.equals(BUG)) {
                this.processBug(map2, string2);
            } else if (string.equals(REQUIRES)) {
                this.processRequires(map2, string2);
            } else if (string.equals(KEY)) {
                this.processKey(map2, string2);
            } else if (string.equals(MODULES)) {
                this.processModules(map2, string2);
            } else if (string.equals(LIBRARY)) {
                this.processLibrary(map2, string2);
            } else {
                map2.put(string, string2);
            }
        }
        catch (TestSuite.Fault fault) {
            this.reportError(map2, fault.getMessage());
        }
    }

    @Override
    protected void foundTestDescription(TestDescription testDescription) {
        String string = TestResult.getWorkRelativePath(testDescription);
        TestDescription testDescription2 = this.paths.get(string);
        if (testDescription2 != null && !testDescription.getRootRelativeURL().equals(testDescription2.getRootRelativeURL())) {
            this.error(i18n, "finder.jtrClash", new Object[]{testDescription.getFile(), testDescription2.getFile()});
            return;
        }
        super.foundTestDescription(testDescription);
        this.paths.put(string, testDescription);
    }

    private void parseError(Map<String, String> map, String string) {
        this.reportError(map, "Parse Exception: " + string);
    }

    private void reportError(Map<String, String> map, String string) {
        if (map.get(ERROR) == null) {
            map.put(ERROR, string);
        }
    }

    private void processRun(Map<String, String> map, String string) {
        String string2 = map.get(RUN);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("USER_SPECIFIED").append(" ").append(string).append(LINESEP);
        map.put(RUN, stringBuilder.toString());
    }

    private void processBug(Map<String, String> map, String string) {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_BUG_EMPTY);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map.get(BUG) != null) {
            stringBuilder.append(map.get(BUG));
        }
        for (String string2 : StringUtils.splitWS(string)) {
            if (this.checkBugID && !bugIdPattern.matcher(string2).matches()) {
                this.parseError(map, PARSE_BUG_INVALID + string2);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(BUG).append(string2);
        }
        if (stringBuilder.length() > 0) {
            map.put(BUG, stringBuilder.toString());
        }
    }

    private void processRequires(Map<String, String> map, String string) throws TestSuite.Fault {
        Object object;
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_REQUIRES_EMPTY);
            return;
        }
        try {
            object = this.properties.getValidRequiresProperties(this.getCurrentFile());
            RegressionContext regressionContext = new RegressionContext(this.baseContext, (Set<String>)object);
            Expr.parse(string, regressionContext);
        }
        catch (Expr.Fault fault) {
            this.parseError(map, PARSE_REQUIRES_SYNTAX + fault.getMessage());
            return;
        }
        object = map.get(REQUIRES);
        if (object == null) {
            map.put(REQUIRES, string);
        } else {
            map.put(REQUIRES, "(" + (String)object + ") & (" + string + ")");
        }
    }

    private void processKey(Map<String, String> map, String string) throws TestSuite.Fault {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_KEY_EMPTY);
            return;
        }
        Set<String> set = this.properties.getValidKeys(this.getCurrentFile());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : StringUtils.splitWS(string)) {
            if (!set.contains(string2)) {
                this.parseError(map, PARSE_KEY_BAD + string2);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() > 0) {
            map.put(KEY, stringBuilder.toString());
        }
    }

    private void processModules(Map<String, String> map, String string) throws TestSuite.Fault {
        if (string.trim().length() == 0) {
            this.parseError(map, PARSE_MODULES_EMPTY);
            return;
        }
        for (String string2 : string.trim().split("\\s+")) {
            String string3;
            String string4;
            int n = string2.indexOf("/");
            if (n == -1) {
                string4 = string2;
                string3 = null;
            } else {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            }
            if (!this.isDottedName(string4)) {
                this.parseError(map, PARSE_BAD_MODULE + string4);
                return;
            }
            if (string3 == null || this.isDottedName(string3)) continue;
            this.parseError(map, PARSE_BAD_PACKAGE + string3);
            return;
        }
        String string5 = map.get(MODULES);
        if (string5 == null) {
            map.put(MODULES, string);
        } else {
            map.put(MODULES, string5 + " " + string);
        }
    }

    private boolean isDottedName(String string) {
        for (String string2 : string.split("\\.")) {
            if (this.isValidIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void processLibrary(Map<String, String> map, String string) {
        if (map.get(RUN) == null) {
            if (string.trim().length() != 0) {
                String string2 = map.get(LIBRARY);
                String string3 = string2 != null ? string.trim() + " " + string2 : string.trim();
                map.put(LIBRARY, string3);
            } else {
                this.parseError(map, PARSE_LIB_EMPTY);
            }
        } else {
            this.parseError(map, PARSE_LIB_AFTER_RUN);
        }
    }

    private Set<String> getValidTagNames(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(TEST);
        hashSet.add(BUG);
        hashSet.add(SUMMARY);
        hashSet.add(AUTHOR);
        hashSet.add(LIBRARY);
        hashSet.add(MODULES);
        hashSet.add(CLEAN);
        hashSet.add(COMPILE);
        hashSet.add(IGNORE);
        hashSet.add(RUN);
        hashSet.add(BUILD);
        hashSet.add(REQUIRES);
        if (bl) {
            hashSet.add(KEY);
        }
        return hashSet;
    }

    private static Pattern getActionPattern(String string) {
        return Pattern.compile("(?s).*\\QUSER_SPECIFIED " + string + "\\E\\b.*");
    }

    private static Pattern getOptionPattern(String string) {
        return Pattern.compile("(?s).*/" + string + "[/= \t].*");
    }
}

