/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.regtest.ElapsedTimeHandler;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.TestManager;
import com.sun.javatest.regtest.TestNGReporter;
import com.sun.javatest.regtest.TestStats;
import com.sun.javatest.report.Report;
import com.sun.javatest.util.HTMLWriter;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionReporter {
    File workDirArg;
    File reportDirArg;
    PrintWriter out;
    DateFormat df = DateFormat.getDateTimeInstance();
    String backups = System.getProperty("javatest.report.backups");
    List<String> reportKinds = Arrays.asList(System.getProperty("javatest.report.kinds", "html text").split("[ ,]+"));

    RegressionReporter(File file, File file2, PrintWriter printWriter) {
        this.workDirArg = file;
        this.reportDirArg = file2;
        this.out = printWriter;
    }

    void report(RegressionParameters regressionParameters, ElapsedTimeHandler elapsedTimeHandler, TestStats testStats, boolean bl) {
        File file = regressionParameters.getReportDir();
        try {
            if (Thread.interrupted()) {
                this.out.println("WARNING: interrupt status cleared prior to writing report");
            }
            Report report = new Report();
            Report.Settings settings = new Report.Settings(regressionParameters);
            if (this.reportKinds.contains("html")) {
                settings.setEnableHtmlReport(true);
                settings.setHtmlMainReport(true, true);
            }
            if (this.reportKinds.contains("text")) {
                settings.setEnablePlainReport(true);
            }
            if (this.reportKinds.contains("xml")) {
                settings.setEnableXmlReport(true);
            }
            settings.setFilter(new CompositeFilter(regressionParameters.getFilters()));
            if (this.backups == null) {
                settings.setEnableBackups(false);
            } else {
                try {
                    settings.setBackupLevels(Integer.parseInt(this.backups));
                    settings.setEnableBackups(true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            file.mkdirs();
            report.writeReport(settings, file);
            if (settings.isPlainEnabled()) {
                TestNGReporter testNGReporter;
                if (elapsedTimeHandler != null) {
                    elapsedTimeHandler.report(report);
                }
                if (testStats != null) {
                    testStats.report(report);
                }
                if (!(testNGReporter = TestNGReporter.instance(regressionParameters.getWorkDirectory())).isEmpty()) {
                    testNGReporter.writeReport(this.reportDirArg);
                }
            }
            this.fixupReports(file, this.workDirArg, this.reportDirArg);
            if (!bl) {
                this.logReportWritten(file);
            }
        }
        catch (IOException iOException) {
            this.out.println("Error while writing report: " + iOException);
        }
        catch (SecurityException securityException) {
            this.out.println("Error while writing report: " + securityException);
        }
    }

    void report(TestManager testManager) throws Main.Fault {
        File file = RegressionReporter.getCommonParent(testManager.getTestSuites());
        if (file != null && file.getParentFile() == null) {
            file = null;
        }
        try {
            if (this.reportKinds.contains("html")) {
                this.writeHTMLReport(testManager, file);
            }
            if (this.reportKinds.contains("text")) {
                this.writeCombinedSummary(testManager);
            }
            this.writeIndex(file);
            this.logReportWritten(this.reportDirArg);
        }
        catch (IOException iOException) {
            this.out.println("Error while writing report: " + iOException);
        }
    }

    void logReportWritten(File file) {
        File file2 = new File(file, "report.html");
        if (!file2.exists()) {
            file2 = new File(new File(file, "html"), "report.html");
        }
        if (file2.exists()) {
            this.out.println("Report written to " + RegressionReporter.canon(file2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHTMLReport(TestManager testManager, File file) throws IOException, Main.Fault {
        String string = file == null ? "MultiRun Report" : "MultiRun Report: " + file;
        File file2 = new File(this.reportDirArg, "html");
        file2.mkdirs();
        File file3 = new File(file2, "report.html");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
        try {
            HTMLWriter hTMLWriter = new HTMLWriter(bufferedWriter);
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("head");
            hTMLWriter.startTag("title");
            hTMLWriter.write(string);
            hTMLWriter.endTag("title");
            hTMLWriter.endTag("head");
            hTMLWriter.startTag("body");
            hTMLWriter.startTag("h1");
            hTMLWriter.write(string);
            hTMLWriter.endTag("h1");
            hTMLWriter.startTag("p");
            hTMLWriter.write("Date of report: " + this.df.format(new Date()));
            hTMLWriter.endTag("p");
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "1");
            hTMLWriter.endTag("tr");
            for (String object : new String[]{"Test Suite", "Results", "Report"}) {
                hTMLWriter.startTag("th");
                hTMLWriter.write(object);
                hTMLWriter.endTag("th");
            }
            hTMLWriter.startTag("tr");
            for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                hTMLWriter.startTag("tr");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file4 = regressionTestSuite.getRootDir();
                hTMLWriter.writeAttr("href", file4.getAbsolutePath());
                hTMLWriter.write(RegressionReporter.relativize(file, file4).getPath());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file5 = testManager.getWorkDirectory(regressionTestSuite).getRoot();
                hTMLWriter.writeAttr("href", file5.getPath());
                hTMLWriter.write(file5.getName());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file6 = testManager.getReportDirectory(regressionTestSuite);
                File file7 = new File(file6, "index.html");
                hTMLWriter.writeAttr("href", file7.getAbsolutePath());
                hTMLWriter.write(file6.getName());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.endTag("tr");
            }
            hTMLWriter.endTag("table");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }

    private void fixupReports(File file, File file2, File file3) {
        file = this.getCanonicalFile(file);
        file2 = this.getCanonicalFile(file2);
        file3 = this.getCanonicalFile(file3);
        String string = this.getCanonicalURIPath(file2);
        File file4 = file2.getParentFile();
        File file5 = file3.getParentFile();
        File file6 = new File(file, "html");
        if (RegressionReporter.equal(file2, file3)) {
            this.fixupReportFiles(file, string, ".");
            this.fixupReportFiles(file6, string, "..");
        } else if (RegressionReporter.equal(file3, file4)) {
            this.fixupReportFiles(file, string, file2.getName());
            this.fixupReportFiles(file6, string, "../" + file2.getName());
        } else if (RegressionReporter.equal(file2, file5)) {
            this.fixupReportFiles(file, string, "..");
            this.fixupReportFiles(file6, string, "../..");
        } else if (RegressionReporter.equal(file4, file5)) {
            this.fixupReportFiles(file, string, "../" + file2.getName());
            this.fixupReportFiles(file6, string, "../../" + file2.getName());
        }
    }

    private void fixupReportFiles(File file, String string, String string2) {
        String string3 = this.getCanonicalURIPath(file);
        for (File file2 : file.listFiles()) {
            if (!file2.getName().endsWith(".html")) continue;
            try {
                this.write(file2, this.read(file2).replace("href=\"" + string + "/", "href=\"" + string2 + "/").replace("href=\"" + string + "\"", "href=\"" + string2 + "\"").replace("href=\"" + string3 + "\"", "href=\".\""));
            }
            catch (IOException iOException) {
                this.out.println("Error while updating report: " + iOException);
            }
        }
    }

    String getCanonicalURIPath(File file) {
        File file2 = this.getCanonicalFile(file);
        String string = file2.getPath().replace(File.separatorChar, '/');
        if (file2.isAbsolute() && !string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCombinedSummary(TestManager testManager) throws IOException, Main.Fault {
        File file = new File(this.reportDirArg, "text");
        file.mkdirs();
        File file2 = new File(file, "summary.txt");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        try {
            for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                File file3 = new File(new File(testManager.getReportDirectory(regressionTestSuite), "text"), "summary.txt");
                if (!file3.exists()) continue;
                String string = this.read(file3);
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                bufferedWriter.write(string);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(File file) throws IOException {
        String string = file == null ? "MultiRun Report" : "MultiRun Report: " + file;
        File file2 = new File(this.reportDirArg, "index.html");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        try {
            HTMLWriter hTMLWriter = new HTMLWriter(bufferedWriter);
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("head");
            hTMLWriter.startTag("title");
            hTMLWriter.write(string);
            hTMLWriter.endTag("title");
            hTMLWriter.endTag("head");
            hTMLWriter.startTag("body");
            hTMLWriter.startTag("h1");
            hTMLWriter.write(string);
            hTMLWriter.endTag("h1");
            hTMLWriter.startTag("p");
            hTMLWriter.write("Date of report: " + this.df.format(new Date()));
            hTMLWriter.endTag("p");
            if (this.reportKinds.contains("html")) {
                hTMLWriter.startTag("p");
                hTMLWriter.startTag("a");
                hTMLWriter.writeAttr("href", "html/report.html");
                hTMLWriter.write("HTML Report");
                hTMLWriter.endTag("a");
                hTMLWriter.startTag("br");
                hTMLWriter.write("Contains links to the reports for the tests grouped by test suite.");
                hTMLWriter.endTag("p");
            }
            if (this.reportKinds.contains("text")) {
                hTMLWriter.startTag("p");
                hTMLWriter.startTag("a");
                hTMLWriter.writeAttr("href", "text/summary.txt");
                hTMLWriter.write("Plain Text Report");
                hTMLWriter.endTag("a");
                hTMLWriter.startTag("br");
                hTMLWriter.write("Combined text report for all the tests.");
                hTMLWriter.endTag("p");
            }
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(File file) throws IOException {
        String string;
        byte[] byArray = new byte[(int)file.length()];
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            dataInputStream.readFully(byArray);
            string = new String(byArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            dataInputStream.close();
            throw throwable;
        }
        dataInputStream.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(string.getBytes());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    private static File getCommonParent(Set<RegressionTestSuite> set) {
        String string = File.separator;
        String string2 = null;
        for (RegressionTestSuite regressionTestSuite : set) {
            int n;
            File file = regressionTestSuite.getRootDir();
            File file2 = file.isDirectory() ? file : file.getParentFile();
            File file3 = file2 == null ? new File(System.getProperty("user.dir")) : file2.getAbsoluteFile();
            String string3 = file3.getPath();
            if (!string3.endsWith(string)) {
                string3 = string3 + string;
            }
            if (string2 == null || string2.startsWith(string3)) {
                string2 = string3;
                continue;
            }
            if (string3.startsWith(string2)) continue;
            int n2 = -1;
            while ((n = string2.indexOf(string, n2 + 1)) != -1 && n < string3.length() && string3.substring(n2 + 1, n).equals(string2.substring(n2 + 1, n))) {
                n2 = n;
            }
            if (n2 == -1) {
                return null;
            }
            string2 = string2.substring(0, n2 + 1);
        }
        return string2 == null ? null : new File(string2);
    }

    private static File relativize(File file, File file2) {
        if (file != null) {
            StringBuilder stringBuilder = new StringBuilder();
            while (file2 != null) {
                if (file2.equals(file)) {
                    return new File(stringBuilder.toString());
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, File.separator);
                }
                stringBuilder.insert(0, file2.getName());
                file2 = file2.getParentFile();
            }
        }
        return file2;
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private static <T> boolean equal(T t, T t2) {
        return t == null ? t2 == null : t.equals(t2);
    }
}

