/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.ProcessUtils;
import com.sun.javatest.regtest.StreamCopier;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.Alarm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCommand {
    private HashMap statusTable;
    private Status defaultStatus = Status.error("unknown reason");
    private File execDir;
    private List<String> cmd;
    private Map<String, String> env;
    private PrintWriter out;
    private PrintWriter err;
    private long timeout;
    private TimeoutHandler timeoutHandler;

    public ProcessCommand setStatusForExit(int n, Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
            if (this.defaultStatus == null) {
                this.defaultStatus = Status.error("unrecognized exit code");
            }
        }
        this.statusTable.put(n, status);
        return this;
    }

    public ProcessCommand setDefaultStatus(Status status) {
        if (this.statusTable == null) {
            this.statusTable = new HashMap();
        }
        this.defaultStatus = status;
        return this;
    }

    public ProcessCommand setExecDir(File file) {
        this.execDir = file;
        return this;
    }

    public File getExecDir() {
        return this.execDir;
    }

    public ProcessCommand setCommand(List<String> list) {
        this.cmd = list;
        return this;
    }

    public List<String> getCommand() {
        return this.cmd;
    }

    public ProcessCommand setEnvironment(Map<String, String> map) {
        this.env = map;
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.env;
    }

    public ProcessCommand setStreams(PrintWriter printWriter, PrintWriter printWriter2) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (printWriter2 == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        this.out = printWriter;
        this.err = printWriter2;
        return this;
    }

    public PrintWriter getOutStream() {
        return this.out;
    }

    public PrintWriter getErrorStream() {
        return this.err;
    }

    public ProcessCommand setTimeout(long l, TimeUnit timeUnit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ProcessCommand setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    public TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status exec() {
        if (this.out == null) {
            throw new IllegalArgumentException("Output stream is required");
        }
        if (this.err == null) {
            throw new IllegalArgumentException("Error stream is required");
        }
        try {
            Status status;
            Object object;
            ProcessBuilder processBuilder = new ProcessBuilder(this.cmd);
            processBuilder.directory(this.execDir);
            if (this.env != null) {
                processBuilder.environment().clear();
                processBuilder.environment().putAll(this.env);
            }
            final Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            Alarm alarm = Alarm.NONE;
            if (this.timeout > 0L) {
                object = Thread.currentThread();
                alarm = Alarm.schedule(this.timeout, TimeUnit.MILLISECONDS, this.out, new Runnable((Thread)object){
                    final /* synthetic */ Thread val$victim;
                    {
                        this.val$victim = thread;
                    }

                    public void run() {
                        if (ProcessCommand.this.timeoutHandler != null) {
                            ProcessCommand.this.timeoutHandler.handleTimeout(process);
                        }
                        ProcessUtils.destroyForcibly(process);
                        this.val$victim.interrupt();
                    }
                });
            }
            if ((object = process.getOutputStream()) != null) {
                ((OutputStream)object).close();
            }
            try {
                try {
                    StatusScanner statusScanner = new StatusScanner();
                    StreamCopier streamCopier = new StreamCopier(inputStream, this.out);
                    StreamCopier streamCopier2 = new StreamCopier(inputStream2, this.err, statusScanner);
                    streamCopier.start();
                    streamCopier2.start();
                    streamCopier.join();
                    streamCopier2.join();
                    int n = process.waitFor();
                    alarm.cancel();
                    status = this.getStatus(n, statusScanner.exitStatus());
                    Object var13_17 = null;
                }
                catch (InterruptedException interruptedException) {
                    alarm.cancel();
                    String string = alarm.didFire() ? "Program `" + this.cmd.get(0) + "' timed out!" : "Program `" + this.cmd.get(0) + "' interrupted!";
                    Status status2 = Status.error(string);
                    Object var13_18 = null;
                    inputStream.close();
                    inputStream2.close();
                    alarm.cancel();
                    return status2;
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                inputStream.close();
                inputStream2.close();
                alarm.cancel();
                throw throwable;
            }
            inputStream.close();
            inputStream2.close();
            alarm.cancel();
            return status;
        }
        catch (IOException iOException) {
            String string = "Error invoking program `" + this.cmd.get(0) + "': " + iOException;
            return Status.error(string);
        }
    }

    protected Status getStatus(int n, Status status) {
        if (status != null) {
            return status;
        }
        if (this.statusTable != null) {
            Status status2 = (Status)this.statusTable.get(n);
            return status2 == null ? this.defaultStatus.augment("exit code: " + n) : status2;
        }
        if (n == 0) {
            return Status.passed("exit code 0");
        }
        return Status.failed("exit code " + n);
    }

    private static class StatusScanner
    implements StreamCopier.LineScanner {
        private String lastStatusLine;

        private StatusScanner() {
        }

        public void scan(String string) {
            if (string.startsWith("STATUS:")) {
                this.lastStatusLine = string = Status.decode(string);
            }
        }

        public Status exitStatus() {
            if (this.lastStatusLine == null) {
                return null;
            }
            return Status.parse(this.lastStatusLine.substring("STATUS:".length()));
        }
    }
}

