/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;

public class OS {
    public final String name;
    public final String arch;
    public final String version;
    public final String family;
    public final String simple_arch;
    public final String simple_version;
    public final int processors;
    public final long maxMemory;
    public final long maxSwap;
    private static OS current;

    public static OS current() {
        if (current == null) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.arch");
            String string3 = System.getProperty("os.version");
            current = new OS(string, string2, string3);
        }
        return current;
    }

    public OS(String string, String string2, String string3) {
        char c;
        int n;
        this.name = string;
        this.arch = string2;
        this.version = string3;
        this.family = string.startsWith("Linux") ? "linux" : (string.startsWith("Mac") || string.startsWith("Darwin") ? "mac" : (string.startsWith("SunOS") || string.startsWith("Solaris") ? "solaris" : (string.startsWith("Windows") ? "windows" : string.replaceFirst("^([^ ]+).*", "$1"))));
        this.simple_arch = string2.contains("64") && !string2.equals("ia64") && !string2.equals("ppc64") ? "x64" : (string2.contains("86") ? "i586" : (string2.equals("ppc") || string2.equals("powerpc") ? "ppc" : string2));
        for (n = 0; n < string3.length() && (Character.isDigit(c = string3.charAt(n)) || c == '.'); ++n) {
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string4 : string3.substring(0, n).split("\\.")) {
            if (string4.length() <= 0) continue;
            arrayList.add(Integer.valueOf(string4));
        }
        switch (arrayList.size()) {
            case 0: {
                this.simple_version = "99.99";
                break;
            }
            case 1: {
                this.simple_version = arrayList.get(0) + ".0";
                break;
            }
            default: {
                this.simple_version = arrayList.get(0) + "." + arrayList.get(1);
            }
        }
        this.processors = Runtime.getRuntime().availableProcessors();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.maxMemory = operatingSystemMXBean.getTotalPhysicalMemorySize();
        this.maxSwap = operatingSystemMXBean.getTotalSwapSpaceSize();
    }
}

