/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Keywords;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.regtest.Agent;
import com.sun.javatest.regtest.AntOptionDecoder;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.BasicObserver;
import com.sun.javatest.regtest.ElapsedTimeHandler;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.GroupManager;
import com.sun.javatest.regtest.Help;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.JCovManager;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.Lock;
import com.sun.javatest.regtest.NaturalComparator;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.regtest.OptionDecoder;
import com.sun.javatest.regtest.ProcessUtils;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.RegressionReporter;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.TestManager;
import com.sun.javatest.regtest.TestStats;
import com.sun.javatest.regtest.TimeoutHandlerProvider;
import com.sun.javatest.regtest.Verbose;
import com.sun.javatest.regtest.VerboseHandler;
import com.sun.javatest.regtest.Version;
import com.sun.javatest.regtest.XMLWriter;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Startup;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.junit.runner.JUnitCore;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static final String MAIN = "main";
    public static final String SELECT = "select";
    public static final String JDK = "jdk";
    public static final String MODE = "mode";
    public static final String VERBOSE = "verbose";
    public static final String DOC = "doc";
    List<Option> options = Arrays.asList(new Option(Option.ArgType.OPT, "verbose", "verbose", new String[]{"v", "verbose"}){

        public String[] getChoices() {
            String[] stringArray = new String[Verbose.values().length];
            int n = 0;
            for (String string : Verbose.values()) {
                stringArray[n++] = string;
            }
            return stringArray;
        }

        public void process(String string, String string2) throws BadArgs {
            if (string2 == null) {
                Main.verbose = Verbose.DEFAULT;
            } else {
                Main.verbose = Verbose.decode(string2);
                if (verbose == null) {
                    throw new BadArgs(i18n, "main.unknownVerbose", string2);
                }
            }
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"v1"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.SUMMARY;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"va"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.ALL;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vp"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.PASS;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vf"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.FAIL;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"ve"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.ERROR;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vt"}){

        public void process(String string, String string2) {
            Main.verbose = Verbose.TIME;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"t", "tagspec"}){

        public void process(String string, String string2) {
            Main.this.help.setTagSpec(true);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"n", "relnote"}){

        public void process(String string, String string2) {
            Main.this.help.setReleaseNotes(true);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"w", "workDir"}){

        public void process(String string, String string2) {
            Main.this.workDirArg = new File(string2);
            Main.this.childArgs.add("-w:" + Main.getNormalizedFile(Main.this.workDirArg));
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"retain"}){

        public String[] getChoices() {
            return new String[]{"none", "pass", "fail", "error", "all", "file-pattern"};
        }

        public void process(String string, String string2) throws BadArgs {
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string2 == null || string2.length() == 0) {
                Main.this.retainArgs = Collections.singletonList("all");
            } else {
                Main.this.retainArgs = Arrays.asList(string2.split(","));
            }
            if (Main.this.retainArgs.contains("none") && Main.this.retainArgs.size() > 1) {
                throw new BadArgs(i18n, "main.badRetainNone", string2);
            }
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"r", "reportDir"}){

        public void process(String string, String string2) {
            Main.this.reportDirArg = new File(string2);
            Main.this.childArgs.add("-r:" + Main.getNormalizedFile(Main.this.reportDirArg));
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"ro", "reportOnly"}){

        public void process(String string, String string2) {
            Main.this.reportOnlyFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"nr", "noreport"}){

        public void process(String string, String string2) {
            Main.this.noReportFlag = true;
        }
    }, new Option(Option.ArgType.STD, "main", "ro-nr", new String[]{"show"}){

        public void process(String string, String string2) {
            Main.this.noReportFlag = true;
            Main.this.showStream = string2;
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"timeout", "timeoutFactor"}){

        public void process(String string, String string2) {
            Main.this.timeoutFactorArg = string2;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"tl", "timelimit"}){

        public void process(String string, String string2) {
            Main.this.timeLimitArg = string2;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"conc", "concurrency"}){

        public void process(String string, String string2) {
            Main.this.concurrencyArg = string2;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"xml"}){

        public void process(String string, String string2) {
            Main.this.xmlFlag = true;
            Main.this.xmlVerifyFlag = "verify".equals(string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"dir"}){

        public void process(String string, String string2) {
            Main.this.baseDirArg = new File(string2);
            Main.this.childArgs.add("-dir:" + Main.getNormalizedFile(Main.this.baseDirArg));
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"allowSetSecurityManager"}){

        public String[] getChoices() {
            return new String[]{"yes", "no", "on", "off", "true", "false"};
        }

        public void process(String string, String string2) {
            boolean bl = string2 == null || Arrays.asList("yes", "on", "true").contains(string2);
            Main.this.allowSetSecurityManagerFlag = bl;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", "", new String[]{"status"}){

        public String[] getChoices() {
            return new String[]{"pass", "fail", "notRun", "error"};
        }

        public void process(String string, String string2) {
            Main.this.priorStatusValuesArg = string2.toLowerCase();
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"exclude", "Xexclude"}){

        public void process(String string, String string2) {
            File file = Main.getNormalizedFile(new File(string2));
            Main.this.excludeListArgs.add(file);
            Main.this.childArgs.add("-exclude:" + file);
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"startHttpd"}){

        public void process(String string, String string2) {
            Main.this.httpdFlag = true;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"o", "observer"}){

        public void process(String string, String string2) {
            Main.this.observerClassName = string2;
            Main.this.childArgs.add(string);
            Main.this.childArgs.add(string2);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"od", "observerDir", "op", "observerPath"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.observerPathArg = new ArrayList();
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Main.this.observerPathArg.add(new File(string3));
            }
            Main.this.childArgs.add("-op:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"th", "timeoutHandler"}){

        public void process(String string, String string2) {
            TimeoutHandlerProvider.setClassName(string2);
            Main.this.childArgs.add("-th:" + string2);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"thd", "timeoutHandlerDir"}){

        public void process(String string, String string2) throws BadArgs {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                arrayList.add(new File(string3));
            }
            try {
                TimeoutHandlerProvider.setClassPath(arrayList);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BadArgs(i18n, malformedURLException.toString(), new Object[0]);
            }
            Main.this.childArgs.add("-thd:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"g", "gui"}){

        public void process(String string, String string2) {
            Main.this.guiFlag = true;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"c", "check"}){

        public void process(String string, String string2) {
            Main.this.checkFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"l", "listtests"}){

        public void process(String string, String string2) {
            Main.this.listTestsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"showGroups"}){

        public void process(String string, String string2) {
            Main.this.showGroupsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ignore", new String[]{"noignore"}){

        public void process(String string, String string2) {
            Main.this.ignoreKind = IgnoreKind.RUN;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "ignore", new String[]{"ignore"}){

        public String[] getChoices() {
            String[] stringArray = new String[IgnoreKind.values().length];
            int n = 0;
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                stringArray[n++] = ignoreKind.toString().toLowerCase();
            }
            return stringArray;
        }

        public void process(String string, String string2) throws BadArgs {
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                if (!string2.equalsIgnoreCase(ignoreKind.toString())) continue;
                if (ignoreKind == IgnoreKind.QUIET) {
                    Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "!ignore");
                }
                Main.this.ignoreKind = ignoreKind;
                Main.this.childArgs.add(string);
                return;
            }
            throw new BadArgs(i18n, "main.unknownIgnore", string2);
        }
    }, new Option(Option.ArgType.OLD, "main", null, new String[]{"e"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.envVarArgs.addAll(Arrays.asList(string2.split(",")));
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"lock"}){

        public void process(String string, String string2) throws BadArgs {
            File file = Main.getNormalizedFile(new File(string2));
            try {
                if (!(!file.exists() ? file.createNewFile() : file.isFile() && file.canRead())) {
                    throw new BadArgs(i18n, "main.badLockFile", string2);
                }
            }
            catch (IOException iOException) {
                throw new BadArgs(i18n, "main.cantCreateLockFile", string2);
            }
            Main.this.exclusiveLockArg = file;
            Main.this.childArgs.add("-lock:" + file);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"nativepath"}){

        public void process(String string, String string2) throws BadArgs {
            if (string2.contains(File.pathSeparator)) {
                throw new BadArgs(i18n, "main.nativePathMultiplePath", string2);
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new BadArgs(i18n, "main.nativePathNotExist", string2);
            }
            if (!file.isDirectory()) {
                throw new BadArgs(i18n, "main.nativePathNotDir", string2);
            }
            Main.this.nativeDirArg = file;
            Main.this.childArgs.add("-nativepath:" + Main.getNormalizedFile(Main.this.nativeDirArg));
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"a", "automatic", "automagic"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, Main.AUTOMATIC);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"m", "manual"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, Main.MANUAL);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"shell"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "shell");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"noshell"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "!shell");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"bug"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "bug" + string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"k", "keywords"}){

        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "(" + string2 + ")");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "mode", "svm-ovm", new String[]{"ovm", "othervm"}){

        public void process(String string, String string2) {
            Main.this.execMode = ExecMode.OTHERVM;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "mode", "svm-ovm", new String[]{"s", "svm", "samevm"}){

        public void process(String string, String string2) {
            if (Main.isTrue(System.getenv("JTREG_USE_AGENTVM_FOR_SAMEVM"))) {
                Main.this.execMode = ExecMode.AGENTVM;
            } else {
                Main.this.execMode = ExecMode.SAMEVM;
            }
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "mode", "svm-ovm", new String[]{"avm", "agentvm"}){

        public void process(String string, String string2) {
            Main.this.execMode = ExecMode.AGENTVM;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"jdk", "testjdk"}){

        public void process(String string, String string2) {
            Main.this.testJDK = com.sun.javatest.regtest.JDK.of(string2);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"compilejdk"}){

        public void process(String string, String string2) {
            Main.this.compileJDK = com.sun.javatest.regtest.JDK.of(string2);
        }
    }, new Option(Option.ArgType.STD, "jdk", "", new String[]{"cpa", "classpathappend"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Main.this.classPathAppendArg.add(new File(string3));
            }
            Main.this.childArgs.add("-cpa:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"jit"}){

        public void process(String string, String string2) {
            Main.this.jitFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"nojit"}){

        public void process(String string, String string2) {
            Main.this.jitFlag = false;
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"Xrunjcov"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"classic", "green", "native", "hotspot", "client", "server", "d32", "d64"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.OPT, "jdk", null, new String[]{"enableassertions", "ea", "disableassertions", "da"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"enablesystemassertions", "esa", "disablesystemassertions", "dsa"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"XX", "Xms", "Xmx"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"Xint", "Xmixed", "Xcomp"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath/a"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath/a:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath/p"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath/p:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"X"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"D"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"vmoption"}){

        public void process(String string, String string2) {
            if (string2.length() > 0) {
                Main.this.testVMOpts.add(string2);
            }
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"vmoptions"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testVMOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"agentlib"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"agentpath"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javaagent"}){

        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javacoption"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testCompilerOpts.add(string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javacoptions"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testCompilerOpts.addAll(Arrays.asList(string2.split("\\s+")));
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javaoption"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testJavaOpts.add(string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javaoptions"}){

        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testJavaOpts.addAll(Arrays.asList(string2.split("\\s+")));
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"h", "help", "usage"}){

        public void process(String string, String string2) {
            Main.this.help.setCommandLineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"onlineHelp"}){

        public void process(String string, String string2) {
            Main.this.help.setOnlineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"version"}){

        public void process(String string, String string2) {
            Main.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "main", null, new String[0]){
        Pattern groupPtn;
        {
            this.groupPtn = System.getProperty("os.name").matches("(?i)windows.*") ? Pattern.compile("(|[^A-Za-z]|.{2,}):[A-Za-z0-9_,]+") : Pattern.compile(".*:[A-Za-z0-9_,]+");
        }

        public void process(String string, String string2) {
            if (this.groupPtn.matcher(string2).matches()) {
                Main.this.testGroupArgs.add(string2);
            } else {
                Main.this.testFileArgs.add(new File(string2));
            }
            Main.this.childArgs.add(string2);
        }
    });
    public static final int EXIT_OK = 0;
    public static final int EXIT_NO_TESTS = 1;
    public static final int EXIT_TEST_FAILED = 2;
    public static final int EXIT_TEST_ERROR = 3;
    public static final int EXIT_BAD_ARGS = 4;
    public static final int EXIT_FAULT = 5;
    public static final int EXIT_EXCEPTION = 6;
    int errors;
    private PrintWriter out;
    private PrintWriter err;
    private File workDirArg;
    private List<String> retainArgs;
    private List<File> excludeListArgs = new ArrayList<File>();
    private String keywordsExprArg;
    private String concurrencyArg;
    private String timeoutFactorArg;
    private String priorStatusValuesArg;
    private File reportDirArg;
    private List<String> testGroupArgs = new ArrayList<String>();
    private List<File> testFileArgs = new ArrayList<File>();
    private List<File> antFileArgs = new ArrayList<File>();
    private File baseDirArg;
    private ExecMode execMode;
    private JDK compileJDK;
    private JDK testJDK;
    private boolean guiFlag;
    private boolean reportOnlyFlag;
    private boolean noReportFlag;
    private String showStream;
    private boolean allowSetSecurityManagerFlag = true;
    private static Verbose verbose;
    private boolean httpdFlag;
    private String timeLimitArg;
    private String observerClassName;
    private List<File> observerPathArg;
    private List<String> testCompilerOpts = new ArrayList<String>();
    private List<String> testJavaOpts = new ArrayList<String>();
    private List<String> testVMOpts = new ArrayList<String>();
    private boolean checkFlag;
    private boolean listTestsFlag;
    private boolean showGroupsFlag;
    private List<String> envVarArgs = new ArrayList<String>();
    private IgnoreKind ignoreKind;
    private List<File> classPathAppendArg = new ArrayList<File>();
    private File nativeDirArg;
    private boolean jitFlag = true;
    private Help help;
    private boolean xmlFlag;
    private boolean xmlVerifyFlag;
    private File exclusiveLockArg;
    File jtreg_home;
    File javatest_jar;
    File jtreg_jar;
    File junit_jar;
    File testng_jar;
    File policyFile;
    JCovManager jcovManager;
    private List<String> childArgs = new ArrayList<String>();
    private TestStats testStats;
    private static final String AUTOMATIC = "!manual";
    private static final String MANUAL = "manual";
    private static final String[] DEFAULT_UNIX_ENV_VARS;
    private static final String[] DEFAULT_WINDOWS_ENV_VARS;
    private static final String JAVATEST_ANT_FILE_LIST = "javatest.ant.file.list";
    private static boolean debugChild;
    private static I18NResourceBundle i18n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        Main main = new Main(printWriter, printWriter2);
        try {
            int n;
            try {
                n = main.run(stringArray);
                Object var6_12 = null;
                printWriter.flush();
                printWriter2.flush();
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                printWriter.flush();
                printWriter2.flush();
                throw throwable;
            }
            if (!main.guiFlag || n != 0) {
                Main.exit(n);
            }
        }
        catch (Harness.Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(5);
        }
        catch (TestManager.NoTests noTests) {
            printWriter2.println(i18n.getString("main.error", noTests.getMessage()));
            Main.exit(1);
        }
        catch (Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(5);
        }
        catch (BadArgs badArgs) {
            printWriter2.println(i18n.getString("main.badArgs", badArgs.getMessage()));
            new Help(main.options).showCommandLineHelp(printWriter);
            Main.exit(4);
        }
        catch (InterruptedException interruptedException) {
            printWriter2.println(i18n.getString("main.interrupted"));
            Main.exit(6);
        }
        catch (SecurityException securityException) {
            printWriter2.println(i18n.getString("main.securityException", securityException.getMessage()));
            securityException.printStackTrace(System.err);
            Main.exit(6);
        }
        catch (Exception exception) {
            printWriter2.println(i18n.getString("main.unexpectedException", exception.toString()));
            exception.printStackTrace(System.err);
            Main.exit(6);
        }
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
        this.javatest_jar = this.findJar("javatest.jar", "lib/javatest.jar", Harness.class);
        if (this.javatest_jar != null) {
            System.setProperty("javatestClassDir", this.javatest_jar.getPath());
        }
        this.jtreg_jar = this.findJar("jtreg.jar", "lib/jtreg.jar", this.getClass());
        if (this.jtreg_jar != null) {
            this.jcovManager = new JCovManager(this.jtreg_jar.getParentFile());
            if (this.jcovManager.isJCovInstalled()) {
                this.options = new ArrayList<Option>(this.options);
                this.options.addAll(this.jcovManager.options);
            }
        }
        this.help = new Help(this.options);
        if (this.jcovManager != null && this.jcovManager.isJCovInstalled()) {
            this.help.addVersionHelper(new Help.VersionHelper(){

                public void showVersion(PrintWriter printWriter) {
                    printWriter.println(Main.this.jcovManager.version());
                }
            });
        }
    }

    public final int run(String[] stringArray) throws BadArgs, Fault, Harness.Fault, InterruptedException {
        if (stringArray.length > 0) {
            new OptionDecoder(this.options).decodeArgs(Main.expandAtFiles(stringArray));
        } else {
            this.help = new Help(this.options);
            this.help.setCommandLineHelpQuery(null);
        }
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run() throws BadArgs, Fault, Harness.Fault, InterruptedException {
        int n;
        block63: {
            int n2;
            block62: {
                Object object;
                Object object2;
                Object object3;
                File file;
                this.findSystemJarFiles();
                if (this.help.isEnabled()) {
                    this.guiFlag = this.help.show(this.out);
                    return 0;
                }
                if (this.baseDirArg == null) {
                    file = new File(System.getProperty("user.dir"));
                } else {
                    if (!this.baseDirArg.exists()) {
                        throw new Fault(i18n, "main.cantFindFile", this.baseDirArg);
                    }
                    file = this.baseDirArg.getAbsoluteFile();
                }
                String string = System.getProperty(JAVATEST_ANT_FILE_LIST);
                if (string != null) {
                    this.antFileArgs.addAll(Main.readFileList(new File(string)));
                }
                TestManager testManager = new TestManager(this.out, file);
                testManager.addTests(this.testFileArgs, false);
                testManager.addTests(this.antFileArgs, true);
                testManager.addGroups(this.testGroupArgs);
                if (testManager.isEmpty()) {
                    throw new TestManager.NoTests(testManager);
                }
                boolean bl = testManager.isMultiRun();
                for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                    Version version = regressionTestSuite.getRequiredVersion();
                    if (version.compareTo((Version)(object3 = Version.getCurrent())) <= 0) continue;
                    throw new Fault(i18n, "main.requiredVersion", regressionTestSuite.getPath(), version.version, version.build, object3.version, object3.build);
                }
                if (this.execMode == null) {
                    object2 = EnumSet.noneOf(ExecMode.class);
                    for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                        object3 = regressionTestSuite.getDefaultExecMode();
                        if (object3 == null) continue;
                        object2.add(object3);
                    }
                    switch (object2.size()) {
                        case 0: {
                            this.execMode = ExecMode.OTHERVM;
                            break;
                        }
                        case 1: {
                            this.execMode = (ExecMode)((Object)object2.iterator().next());
                            break;
                        }
                        default: {
                            throw new Fault(i18n, "main.cantDetermineExecMode", new Object[0]);
                        }
                    }
                }
                if (this.execMode == ExecMode.SAMEVM && !this.testJavaOpts.isEmpty()) {
                    throw new Fault(i18n, "main.cant.mix.samevm.java.options", new Object[0]);
                }
                if (this.execMode == ExecMode.SAMEVM && this.compileJDK != null) {
                    throw new Fault(i18n, "main.cant.mix.samevm.compile.jdk.options", new Object[0]);
                }
                if (this.execMode == ExecMode.SAMEVM && this.concurrencyArg != null) {
                    throw new Fault(i18n, "main.cant.mix.samevm.concurrency.options", new Object[0]);
                }
                if (this.testJDK == null) {
                    void var6_15;
                    object2 = null;
                    if (this.execMode != ExecMode.SAMEVM) {
                        object2 = System.getenv("JAVA_HOME");
                    }
                    if (object2 == null || ((String)object2).length() == 0) {
                        object2 = System.getProperty("java.home");
                        if (object2 == null) throw new BadArgs(i18n, "main.jdk.not.set", new Object[0]);
                        if (((String)object2).length() == 0) {
                            throw new BadArgs(i18n, "main.jdk.not.set", new Object[0]);
                        }
                    }
                    File file2 = new File((String)object2);
                    if (this.compileJDK == null && file2.getName().toLowerCase().equals("jre") && file2.getParentFile() != null) {
                        File file3 = file2.getParentFile();
                    }
                    this.testJDK = com.sun.javatest.regtest.JDK.of((File)var6_15);
                }
                if (!this.jitFlag) {
                    if (this.execMode == ExecMode.SAMEVM) {
                        this.testVMOpts.add("-Djava.compiler=");
                    } else {
                        this.envVarArgs.add("JAVA_COMPILER=");
                    }
                }
                if (this.classPathAppendArg.size() > 0) {
                    this.envVarArgs.add("CPAPPEND=" + Main.filesToAbsolutePath(this.classPathAppendArg));
                }
                if (this.compileJDK != null) {
                    this.checkJDK(this.compileJDK);
                }
                this.checkJDK(this.testJDK);
                if (this.workDirArg == null) {
                    this.workDirArg = new File("JTwork");
                    this.childArgs.add(0, "-w:" + Main.getNormalizedFile(this.workDirArg));
                }
                if (this.reportDirArg == null && !this.noReportFlag) {
                    this.reportDirArg = new File("JTreport");
                    this.childArgs.add(0, "-r:" + Main.getNormalizedFile(this.reportDirArg));
                }
                this.makeDir(this.workDirArg, false);
                testManager.setWorkDirectory(this.workDirArg);
                if (this.showGroupsFlag) {
                    this.showGroups(testManager);
                    return 0;
                }
                if (this.listTestsFlag) {
                    this.listTests(testManager);
                    return 0;
                }
                this.makeDir(new File(this.workDirArg, "scratch"), true);
                if (!this.noReportFlag) {
                    this.makeDir(this.reportDirArg, false);
                    testManager.setReportDirectory(this.reportDirArg);
                }
                if (this.allowSetSecurityManagerFlag) {
                    switch (this.execMode) {
                        case AGENTVM: {
                            this.initPolicyFile();
                            Agent.Pool.instance().setSecurityPolicy(this.policyFile);
                            break;
                        }
                        case SAMEVM: {
                            this.initPolicyFile();
                            break;
                        }
                    }
                }
                if (this.jcovManager.isEnabled()) {
                    boolean bl2;
                    this.jcovManager.setTestJDK(this.testJDK);
                    this.jcovManager.setWorkDir(Main.getNormalizedFile(this.workDirArg));
                    this.jcovManager.setReportDir(Main.getNormalizedFile(this.reportDirArg));
                    boolean bl3 = bl2 = System.getProperty("javatest.child") != null;
                    if (!bl2) {
                        this.jcovManager.instrumentClasses();
                        object = this.jcovManager.instrClasses + File.pathSeparator + this.jcovManager.jcov_network_saver_jar;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        for (int i = 0; i < this.testVMOpts.size(); ++i) {
                            String string2 = this.testVMOpts.get(i);
                            if (string2.startsWith("-Xbootclasspath/p:")) {
                                string2 = string2.substring(0, "-Xbootclasspath/p:".length()) + (String)object + File.pathSeparator + string2.substring("-Xbootclasspath/p:".length());
                                this.testVMOpts.set(i, string2);
                                bl4 = true;
                                break;
                            }
                            if (!string2.startsWith("-Xms")) continue;
                            bl5 = true;
                        }
                        if (!bl4) {
                            this.testVMOpts.add("-Xbootclasspath/p:" + (String)object);
                        }
                        if (!bl5) {
                            this.testVMOpts.add("-Xms20m");
                        }
                        this.jcovManager.startGrabber();
                        this.testVMOpts.add("-Djcov.port=" + this.jcovManager.grabberPort);
                        if (JCovManager.showJCov) {
                            System.err.println("Modified VM opts: " + this.testVMOpts);
                        }
                    }
                }
                try {
                    if (!this.isThisVMOK()) {
                        int n3 = this.execChild();
                        Object var17_33 = null;
                        if (!this.jcovManager.isEnabled()) return n3;
                        this.jcovManager.stopGrabber();
                        if (this.jcovManager.results.exists()) {
                            this.jcovManager.writeReport();
                            this.out.println("JCov report written to " + Main.canon(new File(this.jcovManager.report, "index.html")));
                            return n3;
                        }
                        this.out.println("Note: no jcov results found; no report generated");
                        return n3;
                    }
                    Harness.setClassDir(ProductInfo.getJavaTestClassDir());
                    Keywords.setAllowNumericKeywords(true);
                    if (this.httpdFlag) {
                        this.startHttpServer();
                    }
                    if (bl && this.guiFlag) {
                        throw new Fault(i18n, "main.onlyOneTestSuiteInGuiMode", new Object[0]);
                    }
                    this.testStats = new TestStats();
                    for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                        Object var15_37;
                        if (bl && verbose != null && Main.verbose.multiRun) {
                            this.out.println("Running tests in " + regressionTestSuite.getRootDir());
                        }
                        RegressionParameters regressionParameters = this.createParameters(testManager, regressionTestSuite);
                        this.checkLockFiles(regressionParameters.getWorkDirectory().getRoot(), "start");
                        TestEnvironment.addDefaultPropTable("(system properties)", System.getProperties());
                        if (this.execMode == ExecMode.SAMEVM) {
                            RegressionSecurityManager.install();
                            SecurityManager securityManager = System.getSecurityManager();
                            if (securityManager instanceof RegressionSecurityManager) {
                                object = (RegressionSecurityManager)securityManager;
                                ((RegressionSecurityManager)object).setAllowPropertiesAccess(true);
                                if (this.allowSetSecurityManagerFlag) {
                                    ((RegressionSecurityManager)object).setAllowSetSecurityManager(true);
                                }
                                ((RegressionSecurityManager)object).setAllowSetIO(true);
                            }
                        }
                        if (this.guiFlag) {
                            this.showTool(regressionParameters);
                            n2 = 0;
                            break block62;
                        }
                        try {
                            boolean bl6 = bl && (verbose == null || !Main.verbose.multiRun);
                            this.testStats.addAll(this.batchHarness(regressionParameters, bl6));
                            var15_37 = null;
                            this.checkLockFiles(regressionParameters.getWorkDirectory().getRoot(), "done");
                        }
                        catch (Throwable throwable) {
                            var15_37 = null;
                            this.checkLockFiles(regressionParameters.getWorkDirectory().getRoot(), "done");
                            throw throwable;
                        }
                    }
                    if (bl) {
                        this.testStats.showResultStats(this.out);
                        RegressionReporter regressionReporter = new RegressionReporter(this.workDirArg, this.reportDirArg, this.out);
                        regressionReporter.report(testManager);
                        if (!this.reportOnlyFlag) {
                            this.out.println("Results written to " + Main.canon(this.workDirArg));
                        }
                    }
                    n = this.testStats.counts[2] > 0 ? 3 : (this.testStats.counts[1] > 0 ? 2 : (this.testStats.counts[0] == 0 ? 1 : (this.errors != 0 ? 5 : 0)));
                    break block63;
                }
                catch (Throwable throwable) {
                    Object var17_36 = null;
                    if (!this.jcovManager.isEnabled()) throw throwable;
                    this.jcovManager.stopGrabber();
                    if (this.jcovManager.results.exists()) {
                        this.jcovManager.writeReport();
                        this.out.println("JCov report written to " + Main.canon(new File(this.jcovManager.report, "index.html")));
                        throw throwable;
                    }
                    this.out.println("Note: no jcov results found; no report generated");
                    throw throwable;
                }
            }
            Object var17_34 = null;
            if (!this.jcovManager.isEnabled()) return n2;
            this.jcovManager.stopGrabber();
            if (this.jcovManager.results.exists()) {
                this.jcovManager.writeReport();
                this.out.println("JCov report written to " + Main.canon(new File(this.jcovManager.report, "index.html")));
                return n2;
            }
            this.out.println("Note: no jcov results found; no report generated");
            return n2;
        }
        Object var17_35 = null;
        if (!this.jcovManager.isEnabled()) return n;
        this.jcovManager.stopGrabber();
        if (this.jcovManager.results.exists()) {
            this.jcovManager.writeReport();
            this.out.println("JCov report written to " + Main.canon(new File(this.jcovManager.report, "index.html")));
            return n;
        }
        this.out.println("Note: no jcov results found; no report generated");
        return n;
    }

    void checkJDK(JDK jDK) throws Fault {
        if (!jDK.exists()) {
            throw new Fault(i18n, "main.jdk.not.found", jDK);
        }
        JDK_Version jDK_Version = jDK.getVersion(this.execMode, new SearchPath(this.jtreg_jar, this.javatest_jar));
        if (jDK_Version == null) {
            throw new Fault(i18n, "main.jdk.unknown.version", jDK);
        }
        if (jDK_Version.compareTo(JDK_Version.V1_1) <= 0) {
            throw new Fault(i18n, "main.jdk.unsupported.version", jDK, jDK_Version.name);
        }
    }

    void showGroups(TestManager testManager) throws Fault {
        for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
            this.out.println(i18n.getString("main.tests.suite", regressionTestSuite.getRootDir()));
            try {
                Set<String> set = testManager.getGroups(regressionTestSuite);
                GroupManager groupManager = regressionTestSuite.getGroupManager(this.out);
                TreeSet<String> treeSet = new TreeSet<String>(new NaturalComparator(false));
                if (set.isEmpty()) {
                    treeSet.addAll(groupManager.getGroups());
                } else {
                    for (String string : groupManager.getGroups()) {
                        if (!set.contains(string)) continue;
                        treeSet.add(string);
                    }
                }
                if (treeSet.isEmpty()) {
                    this.out.println(i18n.getString("main.groups.nogroups"));
                    continue;
                }
                for (String string : treeSet) {
                    this.out.print(string);
                    this.out.print(":");
                    TreeSet<String> treeSet2 = new TreeSet<String>(new NaturalComparator(false));
                    for (File file : groupManager.getFiles(string)) {
                        treeSet2.add(regressionTestSuite.getRootDir().toURI().relativize(file.toURI()).getPath());
                    }
                    for (String string2 : treeSet2) {
                        this.out.print(" ");
                        this.out.print(string2);
                    }
                    this.out.println();
                }
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantReadGroups", regressionTestSuite.getRootDir(), iOException);
            }
        }
    }

    void listTests(TestManager testManager) throws BadArgs, Fault {
        int n = 0;
        for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
            int n2 = 0;
            this.out.println(i18n.getString("main.tests.suite", regressionTestSuite.getRootDir()));
            RegressionParameters regressionParameters = this.createParameters(testManager, regressionTestSuite);
            Iterator<TestResult> iterator = this.getResultsIterator(regressionParameters);
            while (iterator.hasNext()) {
                TestResult testResult = iterator.next();
                this.out.println(testResult.getTestName());
                ++n2;
            }
            this.out.println(i18n.getString("main.tests.found", n2));
            n += n2;
        }
        if (testManager.isMultiRun()) {
            this.out.println(i18n.getString("main.tests.total", n));
        }
    }

    private static String[] expandAtFiles(String[] stringArray) throws Fault {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() > 1 && string.charAt(0) == '@') {
                if ((string = string.substring(1)).charAt(0) == '@') {
                    arrayList.add(string);
                    continue;
                }
                Main.loadCmdFile(string, arrayList);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadCmdFile(String string, List<String> list) throws Fault {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindFile", string);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenFile", string, iOException);
        }
        try {
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(32, 255);
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.commentChar(35);
                streamTokenizer.quoteChar(34);
                streamTokenizer.quoteChar(39);
                while (streamTokenizer.nextToken() != -1) {
                    list.add(streamTokenizer.sval);
                }
                Object var5_7 = null;
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantRead", string, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                ((Reader)bufferedReader).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((Reader)bufferedReader).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> readFileList(File file) throws Fault {
        ArrayList<File> arrayList2;
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenFile", file, iOException);
        }
        try {
            try {
                String string;
                ArrayList<File> arrayList = new ArrayList<File>();
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(new File(string));
                }
                arrayList2 = arrayList;
                Object var6_8 = null;
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantRead", file, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return arrayList2;
        }
        bufferedReader.close();
        return arrayList2;
    }

    private static void writeFileList(File file, List<File> list) throws Fault {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (File file2 : list) {
                String string = file2.getPath();
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantWrite", file, iOException);
        }
    }

    public int[] getTestStats() {
        return this.testStats.counts;
    }

    private boolean isThisVMOK() {
        boolean bl;
        if (this.reportOnlyFlag || this.checkFlag || this.listTestsFlag || this.showStream != null || this.execMode != ExecMode.SAMEVM) {
            return true;
        }
        File file = Main.canon(new File(this.workDirArg, "scratch"));
        File file2 = Main.canon(new File(""));
        if (!file2.equals(file)) {
            if (debugChild) {
                System.err.println("dir mismatch: " + file2 + " " + file);
            }
            return false;
        }
        File file3 = Main.canon(new File(System.getProperty("java.home")));
        if (file3.getName().toLowerCase().equals("jre")) {
            file3 = file3.getParentFile();
        }
        if (!file3.equals(this.testJDK.getCanonicalFile())) {
            if (debugChild) {
                System.err.println("jdk mismatch: " + file3 + " " + this.testJDK + " (" + this.testJDK.getCanonicalFile() + ")");
            }
            return false;
        }
        boolean bl2 = bl = System.getProperty("javatest.child") != null;
        if (!bl && !this.testVMOpts.isEmpty()) {
            if (debugChild) {
                System.err.println("need VM opts: " + this.testVMOpts);
            }
            return false;
        }
        if (this.classPathAppendArg.size() > 0) {
            SearchPath searchPath;
            SearchPath searchPath2;
            if (debugChild) {
                System.err.println("need classPathAppend: " + this.classPathAppendArg);
            }
            if (!(searchPath2 = new SearchPath(System.getProperty("java.class.path"))).contains(searchPath = Main.filesToAbsolutePath(this.classPathAppendArg))) {
                return false;
            }
        }
        if (!bl && this.allowSetSecurityManagerFlag) {
            if (debugChild) {
                System.err.println("need policy file for setSecurityManager");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int execChild() throws Fault {
        int n;
        Object object;
        String[] stringArray;
        if (System.getProperty("javatest.child") != null) {
            throw new AssertionError();
        }
        File file = Main.getNormalizedFile(this.testJDK.getAbsoluteFile());
        File file2 = new File(new File(file, "bin"), "java");
        File file3 = new File(new File(file, "lib"), "tools.jar");
        File file4 = Main.canon(new File(this.workDirArg, "scratch"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file2.getPath());
        arrayList.add("-classpath");
        ArrayList<File> arrayList2 = new ArrayList<File>();
        arrayList2.add(this.jtreg_jar);
        if (file3.exists()) {
            arrayList2.add(file3);
        }
        if (this.junit_jar.exists()) {
            arrayList2.add(this.junit_jar);
        }
        if (this.testng_jar.exists()) {
            arrayList2.add(this.testng_jar);
        }
        arrayList2.addAll(this.classPathAppendArg);
        arrayList.add(Main.filesToAbsolutePath(arrayList2).toString());
        arrayList.addAll(this.testVMOpts);
        if (this.nativeDirArg != null) {
            arrayList.add("-Djava.library.path=" + this.nativeDirArg.getAbsolutePath());
        }
        if (this.allowSetSecurityManagerFlag) {
            arrayList.add("-Djava.security.policy=" + this.policyFile.toURI());
        }
        if (this.antFileArgs.size() > 0) {
            try {
                stringArray = File.createTempFile("jtreg.", ".tmp", file4);
                Main.writeFileList((File)stringArray, this.antFileArgs);
                arrayList.add("-Djavatest.ant.file.list=" + stringArray);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantWriteTempFile", iOException);
            }
        }
        for (Map.Entry object42 : System.getProperties().entrySet()) {
            object = (String)object42.getKey();
            if (!((String)object).startsWith("javatest.") && !((String)object).startsWith("jtreg.")) continue;
            arrayList.add("-D" + (String)object + "=" + object42.getValue());
        }
        arrayList.add("-Djavatest.child=true");
        if (this.junit_jar != null) {
            arrayList.add("-Djunit.jar=" + this.junit_jar.getPath());
        }
        if (this.testng_jar != null) {
            arrayList.add("-Dtestng.jar=" + this.testng_jar.getPath());
        }
        arrayList.add(Main.class.getName());
        for (String string : this.testVMOpts) {
            arrayList.add("-vmoption:" + string);
        }
        if (this.baseDirArg == null) {
            arrayList.add("-dir:" + System.getProperty("user.dir"));
        }
        arrayList.addAll(this.childArgs);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        File file5 = file4;
        if (debugChild) {
            System.err.println("Starting JavaTest child");
            System.err.println("Dir " + file5 + "; Command " + arrayList);
        }
        object = Runtime.getRuntime();
        Process process = null;
        try {
            try {
                Object n5;
                Object interruptedException;
                try {
                    interruptedException = new SearchPath().append(this.javatest_jar, this.jtreg_jar, this.testJDK.getToolsJar());
                    n5 = new ProcessBuilder(new String[0]);
                    ((ProcessBuilder)n5).environment().clear();
                    ((ProcessBuilder)n5).environment().putAll(this.getEnvVars());
                    ((ProcessBuilder)n5).environment().put("CLASSPATH", ((SearchPath)interruptedException).toString());
                    process = ((ProcessBuilder)n5).command(stringArray).directory(file5).start();
                }
                catch (IOException iOException) {
                    this.err.println("cannot start child VM: " + iOException);
                    int n2 = 5;
                    Object var19_23 = null;
                    if (process == null) return n2;
                    ProcessUtils.destroyForcibly(process);
                    return n2;
                }
                interruptedException = process.getInputStream();
                n5 = new StreamCopier((InputStream)interruptedException, this.out);
                ((Thread)n5).start();
                InputStream inputStream = process.getErrorStream();
                StreamCopier streamCopier = new StreamCopier(inputStream, this.err);
                streamCopier.start();
                OutputStream outputStream = process.getOutputStream();
                if (outputStream != null) {
                    outputStream.close();
                }
                ((StreamCopier)n5).waitUntilDone();
                streamCopier.waitUntilDone();
                int n3 = process.waitFor();
                process = null;
                if (debugChild) {
                    System.err.println("JavaTest child process: rc=" + n3);
                }
                ((InputStream)interruptedException).close();
                inputStream.close();
                n = n3;
                Object var19_24 = null;
                if (process == null) return n;
            }
            catch (IOException iOException) {
                int n4 = 6;
                Object var19_25 = null;
                if (process == null) return n4;
                ProcessUtils.destroyForcibly(process);
                return n4;
            }
            catch (InterruptedException interruptedException2) {
                int n6 = 6;
                Object var19_26 = null;
                if (process == null) return n6;
                ProcessUtils.destroyForcibly(process);
                return n6;
            }
        }
        catch (Throwable throwable) {
            Object var19_27 = null;
            if (process == null) throw throwable;
            ProcessUtils.destroyForcibly(process);
            throw throwable;
        }
        ProcessUtils.destroyForcibly(process);
        return n;
    }

    void findSystemJarFiles() throws Fault {
        String string;
        String string2;
        if (this.javatest_jar == null) {
            this.javatest_jar = this.findJar("javatest.jar", "lib/javatest.jar", Harness.class);
            if (this.javatest_jar == null) {
                throw new Fault(i18n, "main.cantFind.javatest.jar", new Object[0]);
            }
        }
        if (this.jtreg_jar == null) {
            this.jtreg_jar = this.findJar("jtreg.jar", "lib/jtreg.jar", this.getClass());
            if (this.jtreg_jar == null) {
                throw new Fault(i18n, "main.cantFind.jtreg.jar", new Object[0]);
            }
        }
        if ((string2 = System.getProperty("junit.jar")) != null) {
            this.junit_jar = new File(string2);
        } else {
            try {
                this.junit_jar = this.findJar("junit.jar", "lib/junit.jar", JUnitCore.class);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.junit_jar == null) {
            this.junit_jar = new File(this.jtreg_jar.getParentFile(), "junit.jar");
        }
        if ((string = System.getProperty("testng.jar")) != null) {
            this.testng_jar = new File(string);
        } else {
            try {
                this.testng_jar = this.findJar("testng.jar", "lib/testng.jar", Test.class);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.testng_jar == null) {
            this.testng_jar = new File(this.jtreg_jar.getParentFile(), "testng.jar");
        }
        this.help.addJarVersionHelper("TestNG", this.testng_jar, "META-INF/maven/org.testng/testng/pom.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPolicyFile() throws Fault {
        File file = new File(this.workDirArg, "jtreg.policy");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                String string = System.getProperty("line.separator");
                for (File file2 : Arrays.asList(this.jtreg_jar, this.javatest_jar)) {
                    bufferedWriter.write("grant codebase \"" + file2.toURI().toURL() + "\" {" + string);
                    bufferedWriter.write("    permission java.security.AllPermission;" + string);
                    bufferedWriter.write("};" + string);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                bufferedWriter.close();
                throw throwable;
            }
            bufferedWriter.close();
            this.policyFile = file;
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantWritePolicyFile", iOException);
        }
    }

    private void makeDir(File file, boolean bl) throws Fault {
        if (file.isDirectory()) {
            return;
        }
        if (!bl) {
            this.out.println("Directory \"" + file + "\" not found: creating");
        }
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new Fault(i18n, "main.cantCreateDir", file);
        }
    }

    private static List<File> pathToFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    private static SearchPath filesToAbsolutePath(List<File> list) {
        SearchPath searchPath = new SearchPath();
        for (File file : list) {
            searchPath.append(Main.getNormalizedFile(file));
        }
        return searchPath;
    }

    private RegressionParameters createParameters(TestManager testManager, RegressionTestSuite regressionTestSuite) throws BadArgs, Fault {
        try {
            Object object;
            RegressionParameters regressionParameters = regressionTestSuite.createInterview();
            WorkDirectory workDirectory = testManager.getWorkDirectory(regressionTestSuite);
            regressionParameters.setWorkDirectory(workDirectory);
            regressionParameters.setFile(workDirectory.getFile("config.jti"));
            regressionParameters.setRetainArgs(this.retainArgs);
            regressionParameters.setTests(testManager.getTests(regressionTestSuite));
            if (this.keywordsExprArg != null) {
                regressionParameters.setKeywordsExpr(this.keywordsExprArg);
            }
            regressionParameters.setExcludeLists(this.excludeListArgs.toArray(new File[this.excludeListArgs.size()]));
            if (this.priorStatusValuesArg == null || this.priorStatusValuesArg.length() == 0) {
                regressionParameters.setPriorStatusValues(null);
            } else {
                object = new boolean[]{this.priorStatusValuesArg.indexOf("pass") != -1, this.priorStatusValuesArg.indexOf("fail") != -1, this.priorStatusValuesArg.indexOf("erro") != -1, this.priorStatusValuesArg.indexOf("notr") != -1};
                regressionParameters.setPriorStatusValues((boolean[])object);
            }
            if (this.concurrencyArg != null) {
                try {
                    int n = this.concurrencyArg.equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(this.concurrencyArg);
                    regressionParameters.setConcurrency(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badConcurrency", new Object[0]);
                }
            }
            if (this.timeoutFactorArg != null) {
                try {
                    regressionParameters.setTimeoutFactor(Float.parseFloat(this.timeoutFactorArg));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
                }
            }
            if ((object = (Object)testManager.getReportDirectory(regressionTestSuite)) != null) {
                regressionParameters.setReportDir((File)object);
            }
            if (this.exclusiveLockArg != null) {
                regressionParameters.setExclusiveLock(this.exclusiveLockArg);
            }
            if (!regressionParameters.isValid()) {
                throw new Fault(i18n, "main.badParams", regressionParameters.getErrorMessage());
            }
            for (String string : this.testVMOpts) {
                if (!string.startsWith("-Xrunjcov")) continue;
                if (this.testVMOpts.contains("-XX:+EnableJVMPIInstructionStartEvent")) break;
                this.testVMOpts.add("-XX:+EnableJVMPIInstructionStartEvent");
                break;
            }
            if (this.testVMOpts.size() > 0) {
                regressionParameters.setTestVMOptions(this.testVMOpts);
            }
            if (this.testCompilerOpts.size() > 0) {
                regressionParameters.setTestCompilerOptions(this.testCompilerOpts);
            }
            if (this.testJavaOpts.size() > 0) {
                regressionParameters.setTestJavaOptions(this.testJavaOpts);
            }
            regressionParameters.setCheck(this.checkFlag);
            regressionParameters.setExecMode(this.execMode);
            regressionParameters.setEnvVars(this.getEnvVars());
            regressionParameters.setCompileJDK(this.compileJDK != null ? this.compileJDK : this.testJDK);
            regressionParameters.setTestJDK(this.testJDK);
            if (this.ignoreKind != null) {
                regressionParameters.setIgnoreKind(this.ignoreKind);
            }
            if (this.junit_jar != null) {
                regressionParameters.setJUnitJar(this.junit_jar);
            }
            if (this.testng_jar != null) {
                regressionParameters.setTestNGJar(this.testng_jar);
            }
            if (this.timeLimitArg != null) {
                try {
                    regressionParameters.setTimeLimit(Integer.parseInt(this.timeLimitArg));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badTimeLimit", new Object[0]);
                }
            }
            if (this.nativeDirArg != null) {
                regressionParameters.setNativeDir(this.nativeDirArg);
            }
            return regressionParameters;
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "main.cantOpenTestSuite", regressionTestSuite.getRootDir(), fault);
        }
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return Main.getNormalizedFile(file);
        }
    }

    private static Harness.Observer getObserver(List<File> list, String string) throws Fault {
        try {
            Class<?> clazz;
            if (list == null) {
                clazz = Class.forName(string);
            } else {
                URL[] uRLArray = new URL[list.size()];
                int n = 0;
                for (File file : list) {
                    try {
                        uRLArray[n++] = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                clazz = uRLClassLoader.loadClass(string);
            }
            return clazz.asSubclass(Harness.Observer.class).newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new Fault(i18n, "main.obsvrType", Harness.Observer.class.getName(), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault(i18n, "main.obsvrNotFound", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "main.obsvrFault", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "main.obsvrFault", instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestStats batchHarness(RegressionParameters regressionParameters, boolean bl) throws Fault, Harness.Fault, InterruptedException {
        boolean bl2 = !this.noReportFlag && !Boolean.getBoolean("javatest.noReportRequired");
        try {
            boolean bl3;
            Object object;
            TestStats testStats = new TestStats();
            ElapsedTimeHandler elapsedTimeHandler = null;
            if (this.reportOnlyFlag) {
                object = this.getResultsIterator(regressionParameters);
                while (object.hasNext()) {
                    TestResult testResult = (TestResult)object.next();
                    testStats.add(testResult);
                }
                bl3 = testStats.isOK();
            } else if (this.showStream != null) {
                object = null;
                Iterator<TestResult> iterator = this.getResultsIterator(regressionParameters);
                while (iterator.hasNext()) {
                    if (object != null) {
                        this.out.println("More than one test specified");
                        object = null;
                        break;
                    }
                    object = iterator.next();
                }
                if (object == null) {
                    bl3 = false;
                } else if (((TestResult)object).getStatus().isNotRun()) {
                    this.out.println("Test has not been run");
                    bl3 = false;
                } else {
                    try {
                        ((TestResult)object).getProperty("sections");
                        for (int i = 0; i < ((TestResult)object).getSectionCount(); ++i) {
                            TestResult.Section section = ((TestResult)object).getSection(i);
                            String string = section.getOutput(this.showStream);
                            if (string == null) continue;
                            this.out.println("### Section " + section.getTitle());
                            this.out.println(string);
                        }
                        bl3 = true;
                    }
                    catch (TestResult.Fault fault) {
                        this.out.println("Cannot reload test results: " + fault.getMessage());
                        bl3 = false;
                    }
                }
                bl = true;
            } else {
                object = this.createBackupPolicy();
                Harness harness = new Harness();
                harness.setBackupPolicy((BackupPolicy)object);
                if (this.xmlFlag) {
                    this.out.println("XML output " + (this.xmlVerifyFlag ? "with verification to " : " to ") + regressionParameters.getWorkDirectory().getPath());
                    harness.addObserver(new XMLWriter.XMLHarnessObserver(this.xmlVerifyFlag, this.out, this.err));
                }
                if (this.observerClassName != null) {
                    harness.addObserver(Main.getObserver(this.observerPathArg, this.observerClassName));
                }
                if (verbose != null) {
                    new VerboseHandler(verbose, this.out, this.err).register(harness);
                }
                testStats.register(harness);
                harness.addObserver(new BasicObserver(){

                    public void error(String string) {
                        Main.this.error(string);
                    }
                });
                regressionParameters.getWorkDirectory().getTestResultTable().getTestFinder().setErrorHandler(new TestFinder.ErrorHandler(){

                    public void error(String string) {
                        Main.this.error(string);
                    }
                });
                if (bl2) {
                    elapsedTimeHandler = new ElapsedTimeHandler();
                    elapsedTimeHandler.register(harness);
                }
                bl3 = harness.batch(regressionParameters);
                Agent.Pool.instance().flush();
                Lock.get(regressionParameters).close();
            }
            if (!bl) {
                testStats.showResultStats(this.out);
            }
            if (bl2) {
                object = new RegressionReporter(this.workDirArg, this.reportDirArg, this.out);
                ((RegressionReporter)object).report(regressionParameters, elapsedTimeHandler, testStats, bl);
            }
            if (!this.reportOnlyFlag && !bl) {
                this.out.println("Results written to " + regressionParameters.getWorkDirectory().getPath());
            }
            if (!bl3 && !bl) {
                this.err.println(i18n.getString("main.testsFailed"));
            }
            object = testStats;
            Object var12_15 = null;
            this.out.flush();
            this.err.flush();
            return object;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.out.flush();
            this.err.flush();
            throw throwable;
        }
    }

    private Iterator<TestResult> getResultsIterator(InterviewParameters interviewParameters) {
        TestResultTable testResultTable = interviewParameters.getWorkDirectory().getTestResultTable();
        testResultTable.waitUntilReady();
        String[] stringArray = interviewParameters.getTests();
        TestFilter[] testFilterArray = interviewParameters.getFilters();
        if (stringArray == null) {
            return testResultTable.getIterator(testFilterArray);
        }
        return testResultTable.getIterator(stringArray, testFilterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTool(final InterviewParameters interviewParameters) throws BadArgs {
        Startup startup = new Startup();
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Desktop desktop = new Desktop();
                    ExecToolManager execToolManager = (ExecToolManager)desktop.getToolManager(ExecToolManager.class);
                    if (execToolManager == null) {
                        throw new AssertionError((Object)"Cannot find ExecToolManager");
                    }
                    execToolManager.startTool(interviewParameters);
                    desktop.setVisible(true);
                }
            });
            Object var4_3 = null;
            startup.disposeLater();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            startup.disposeLater();
            throw throwable;
        }
    }

    private BackupPolicy createBackupPolicy() {
        return new BackupPolicy(){
            private int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (int i = 0; i < this.ignoreExtns.length; ++i) {
                        if (!file.getPath().endsWith(this.ignoreExtns[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private void startHttpServer() {
        HttpdServer httpdServer = new HttpdServer();
        Thread thread = new Thread(httpdServer);
        PageGenerator.setSWName(ProductInfo.getName());
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Date date = ProductInfo.getBuildDate();
        String string = date != null ? dateFormat.format(date) : i18n.getString("main.noDate");
        PageGenerator.setSWBuildDate(string);
        PageGenerator.setSWVersion(ProductInfo.getVersion());
        thread.start();
    }

    private Map<String, String> getEnvVars() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            this.addEnvVars(treeMap, DEFAULT_WINDOWS_ENV_VARS);
            this.addEnvVars(treeMap, "PATH");
        } else {
            this.addEnvVars(treeMap, DEFAULT_UNIX_ENV_VARS);
            this.addEnvVars(treeMap, "PATH=/bin:/usr/bin");
        }
        this.addEnvVars(treeMap, this.envVarArgs);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (!string2.startsWith("JTREG_")) continue;
            treeMap.put(string2, string3);
        }
        return treeMap;
    }

    private void addEnvVars(Map<String, String> map, String string) {
        this.addEnvVars(map, string.split(","));
    }

    private void addEnvVars(Map<String, String> map, String[] stringArray) {
        this.addEnvVars(map, Arrays.asList(stringArray));
    }

    private void addEnvVars(Map<String, String> map, List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            String string2;
            if ((string = string.trim()).length() == 0) continue;
            int n = string.indexOf("=");
            if (n == -1) {
                string2 = System.getenv(string);
                if (string2 == null) continue;
                map.put(string, string2);
                continue;
            }
            if (n <= 0) continue;
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            map.put(string2, string3);
        }
    }

    private static String combineKeywords(String string, String string2) {
        return string == null ? string2 : string + " & " + string2;
    }

    private File findJar(String string, String string2, Class<?> clazz) {
        String string3;
        if (string != null && (string3 = System.getProperty(string)) != null) {
            return new File(string3);
        }
        if (string2 != null && (string3 = System.getProperty("jtreg.home")) != null) {
            return new File(string3, string2);
        }
        if (clazz != null) {
            try {
                string3 = clazz.getName().replace(".", "/") + ".class";
                URI uRI = this.getClass().getClassLoader().getResource(string3).toURI();
                if (uRI.getScheme().equals("jar")) {
                    String string4 = uRI.getRawSchemeSpecificPart();
                    int n = string4.lastIndexOf("!");
                    uRI = new URI(string4.substring(0, n));
                }
                if (uRI.getScheme().equals("file")) {
                    return new File(uRI.getPath());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace(System.err);
            }
        }
        return null;
    }

    private void error(String string) {
        this.err.println(i18n.getString("main.error", string));
        ++this.errors;
    }

    private static void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)securityManager).setAllowExit(true);
        }
        System.exit(n);
    }

    private static boolean isTrue(String string) {
        return string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
    }

    private void checkLockFiles(File file, String string) {
    }

    private static File getNormalizedFile(File file) {
        return new File(file.getAbsoluteFile().toURI().normalize());
    }

    static {
        DEFAULT_UNIX_ENV_VARS = new String[]{"DISPLAY", "GNOME_DESKTOP_SESSION_ID", "HOME", "LANG", "LC_ALL", "LC_CTYPE", "LPDEST", "PRINTER", "TZ", "XMODIFIERS"};
        DEFAULT_WINDOWS_ENV_VARS = new String[]{"SystemDrive", "SystemRoot", "windir", "TMP", "TEMP"};
        debugChild = Boolean.getBoolean("javatest.regtest.debugChild");
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
    }

    static class StreamCopier
    extends Thread {
        private BufferedReader in;
        private PrintWriter out;
        private boolean done;
        private static int serial;

        StreamCopier(InputStream inputStream, PrintWriter printWriter) {
            super(Thread.currentThread().getName() + "_StreamCopier_" + serial++);
            this.in = new BufferedReader(new InputStreamReader(inputStream));
            this.out = printWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                while ((object = this.in.readLine()) != null) {
                    this.out.println((String)object);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.done = true;
                this.notifyAll();
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }

        public synchronized void waitUntilDone() throws InterruptedException {
            boolean bl = false;
            while (!(bl = Thread.interrupted()) && !this.done) {
                this.wait(1000L);
            }
            if (bl) {
                throw new InterruptedException();
            }
        }
    }

    public static class Ant
    extends MatchingTask {
        private Main m = new Main();
        private File jdk;
        private File dir;
        private File reportDir;
        private File workDir;
        private File nativeDir;
        private String concurrency;
        private String status;
        private String vmOption;
        private String vmOptions;
        private String javacOption;
        private String javacOptions;
        private String javaOption;
        private String javaOptions;
        private String verbose;
        private boolean agentVM;
        private boolean sameVM;
        private boolean otherVM;
        private Boolean failOnError;
        private String resultProperty;
        private String failureProperty;
        private String errorProperty;
        private List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();

        public void setDir(File file) {
            this.dir = file;
        }

        public void setReportDir(File file) {
            this.reportDir = file;
        }

        public void setWorkDir(File file) {
            this.workDir = file;
        }

        public void setNativeDir(File file) {
            this.nativeDir = file;
        }

        public void setJDK(File file) {
            this.jdk = file;
        }

        public void setConcurrency(String string) {
            this.concurrency = string;
        }

        public void setVMOption(String string) {
            this.vmOption = string;
        }

        public void setVMOptions(String string) {
            this.vmOptions = string;
        }

        public void setJavacOption(String string) {
            this.javacOption = string;
        }

        public void setJavacOptions(String string) {
            this.javacOptions = string;
        }

        public void setJavaOption(String string) {
            this.javaOption = string;
        }

        public void setJavaOptions(String string) {
            this.javaOptions = string;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public void setVerbose(String string) {
            this.verbose = string;
        }

        public void setAgentVM(boolean bl) {
            this.agentVM = bl;
        }

        public void setSameVM(boolean bl) {
            this.sameVM = bl;
        }

        public void setOtherVM(boolean bl) {
            this.otherVM = bl;
        }

        public void setResultProperty(String string) {
            this.resultProperty = string;
        }

        public void setFailureProperty(String string) {
            this.failureProperty = string;
        }

        public void setErrorProperty(String string) {
            this.errorProperty = string;
        }

        public void setFailOnError(boolean bl) {
            this.failOnError = bl;
        }

        public void addArg(Commandline.Argument argument) {
            this.args.add(argument);
        }

        public void execute() {
            Project project = this.getProject();
            Hashtable hashtable = project.getProperties();
            for (Map.Entry entry : hashtable.entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith("javatest.")) continue;
                System.setProperty(string, (String)entry.getValue());
            }
            try {
                Map.Entry entry;
                AntOptionDecoder antOptionDecoder = new AntOptionDecoder(this.m.options);
                antOptionDecoder.process("concurrency", this.concurrency);
                antOptionDecoder.process("dir", this.dir);
                antOptionDecoder.process("reportDir", this.reportDir);
                antOptionDecoder.process("workDir", this.workDir);
                antOptionDecoder.process("nativeDir", this.nativeDir);
                antOptionDecoder.process(Main.JDK, this.jdk);
                antOptionDecoder.process(Main.VERBOSE, this.verbose);
                antOptionDecoder.process("agentVM", this.agentVM);
                antOptionDecoder.process("sameVM", this.sameVM);
                antOptionDecoder.process("otherVM", this.otherVM);
                antOptionDecoder.process("vmoption", this.vmOption);
                antOptionDecoder.process("vmoptions", this.vmOptions);
                antOptionDecoder.process("javaoption", this.javaOption);
                antOptionDecoder.process("javaoptions", this.javaOptions);
                antOptionDecoder.process("javacoption", this.javacOption);
                antOptionDecoder.process("javacoptions", this.javacOptions);
                antOptionDecoder.process("status", this.status);
                if (this.args.size() > 0) {
                    entry = new ArrayList();
                    for (Commandline.Argument argument : this.args) {
                        entry.addAll(Arrays.asList(argument.getParts()));
                    }
                    antOptionDecoder.decodeArgs((List<String>)((Object)entry));
                }
                if (this.m.testFileArgs.isEmpty() && this.dir != null) {
                    entry = this.getDirectoryScanner(this.dir);
                    this.addPaths(this.dir, entry.getIncludedFiles());
                }
                int n = this.m.run();
                if (this.resultProperty != null) {
                    project.setProperty(this.resultProperty, String.valueOf(n));
                }
                if (this.failureProperty != null && n >= 2) {
                    project.setProperty(this.failureProperty, i18n.getString("main.testsFailed"));
                }
                if (this.errorProperty != null && n >= 3) {
                    project.setProperty(this.errorProperty, i18n.getString("main.testsError"));
                }
                if (this.failOnError == null) {
                    this.failOnError = this.resultProperty == null && this.failureProperty == null && this.errorProperty == null;
                }
                if (this.failOnError.booleanValue() && n != 0) {
                    throw new BuildException(i18n.getString("main.testsFailed"));
                }
            }
            catch (BadArgs badArgs) {
                throw new BuildException(badArgs.getMessage(), (Throwable)badArgs);
            }
            catch (Fault fault) {
                throw new BuildException(fault.getMessage(), (Throwable)fault);
            }
            catch (Harness.Fault fault) {
                throw new BuildException(fault.getMessage(), (Throwable)fault);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException(i18n.getString("main.interrupted"), (Throwable)interruptedException);
            }
        }

        private void addPaths(File file, String[] stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.m.antFileArgs.add(new File(file, string));
                }
            }
        }
    }

    public static class Fault
    extends Exception {
        static final long serialVersionUID = -6780999176737139046L;

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object ... objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

