/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.agent.RStatus;

public class IgnoreAction
extends Action {
    public static final String NAME = "ignore";

    public String getName() {
        return NAME;
    }

    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        super.init(stringArray, stringArray2, string, regressionScript);
        if (stringArray.length != 0) {
            throw new ParseException("Unexpected option(s) for `ignore'");
        }
    }

    public Status run() throws TestRunException {
        Status status;
        this.startAction();
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            switch (this.script.getIgnoreKind()) {
                case QUIET: {
                    throw new IllegalStateException();
                }
                case ERROR: {
                    this.recorder.exec("# @ignore: " + StringUtils.join(this.args) + "\nexit 1");
                    if (this.args.length == 0) {
                        status = RStatus.error("Test ignored");
                        break;
                    }
                    status = RStatus.error("Test ignored: " + StringUtils.join(this.args));
                    break;
                }
                case RUN: {
                    this.recorder.exec("# @ignore: " + StringUtils.join(this.args) + " (suppressed)");
                    if (this.args.length == 0) {
                        status = RStatus.passed("@ignore suppressed by command line option");
                        break;
                    }
                    status = RStatus.passed("@ignore suppressed by command line option: " + StringUtils.join(this.args));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.endAction(status);
        return status;
    }
}

