/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.diff.MultiMap;
import com.sun.javatest.diff.Reporter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleReporter
extends Reporter {
    private MultiMap<String, TestResult> table;
    private int size;
    private PrintWriter out;
    private String[] statusStrings;
    private int maxStatusStringLength;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SimpleReporter.class);

    public SimpleReporter(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException();
        }
        this.out = printWriter;
        this.statusStrings = new String[4];
        this.statusStrings[0] = i18n.getString("simple.pass");
        this.statusStrings[1] = i18n.getString("simple.fail");
        this.statusStrings[2] = i18n.getString("simple.error");
        this.statusStrings[3] = i18n.getString("simple.notRun");
        for (String string : this.statusStrings) {
            this.maxStatusStringLength = Math.max(this.maxStatusStringLength, string.length());
        }
    }

    @Override
    public void write(MultiMap<String, TestResult> multiMap) throws IOException {
        this.table = multiMap;
        this.size = multiMap.getColumns();
        if (this.title != null) {
            this.println(this.title);
            this.println();
        }
        this.writeHead();
        this.writeBody();
        this.writeSummary();
    }

    private void writeHead() throws IOException {
        for (int i = 0; i < this.size; ++i) {
            int[] nArray = (int[])this.testCounts.get(i);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = nArray[3];
            this.writeI18N("simple.set", i, this.table.getColumnName(i));
            this.print("  ");
            this.writeI18N("simple.counts", new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4));
            this.println();
        }
    }

    private void writeBody() throws IOException {
        this.diffs = 0;
        for (Map.Entry<String, MultiMap.Entry<TestResult>> entry : this.table.entrySet()) {
            int n;
            String string = entry.getKey();
            MultiMap.Entry<TestResult> entry2 = entry.getValue();
            if (entry2.allEqual(this.comparator)) continue;
            if (this.diffs == 0) {
                this.println();
                for (n = 0; n < entry2.getSize(); ++n) {
                    this.print(String.valueOf(n), this.maxStatusStringLength + 2);
                }
                this.writeI18N("simple.test", new Object[0]);
                this.println();
            }
            for (n = 0; n < entry2.getSize(); ++n) {
                TestResult testResult = entry2.get(n);
                Status status = testResult == null ? null : testResult.getStatus();
                this.print(this.getStatusString(status), this.maxStatusStringLength + 2);
            }
            this.println(string);
            ++this.diffs;
        }
    }

    private void writeSummary() throws IOException {
        this.println();
        if (this.diffs == 0) {
            this.writeI18N("simple.diffs.none", new Object[0]);
        } else {
            this.writeI18N("simple.diffs.count", this.diffs);
        }
        this.println();
    }

    private void writeI18N(String string, Object ... objectArray) throws IOException {
        this.print(i18n.getString(string, objectArray));
    }

    private void print(Object object) throws IOException {
        this.out.print(object.toString());
    }

    private void print(String string, int n) throws IOException {
        this.out.print(string);
        for (int i = string.length(); i < n; ++i) {
            this.out.print(' ');
        }
    }

    private void println() throws IOException {
        this.out.println();
    }

    private void println(Object object) throws IOException {
        this.out.println(object.toString());
    }

    private String getStatusString(Status status) {
        return this.statusStrings[status == null ? 3 : status.getType()];
    }
}

