/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PrefixMap
implements Map {
    private Map map;
    private String prefix;

    public PrefixMap(Map map, String prefix) {
        this.map = map;
        this.prefix = prefix + ".";
    }

    public void clear() {
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(this.prefix)) continue;
            i.remove();
        }
    }

    public String getPrefix() {
        if (this.prefix.length() > 1) {
            return this.prefix.substring(0, this.prefix.length() - 1);
        }
        return "";
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(this.prefix + key);
    }

    public boolean containsValue(Object value) {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (!key.startsWith(this.prefix) || !e.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashMap m = new HashMap();
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (!key.startsWith(this.prefix)) continue;
            m.put(key.substring(this.prefix.length()), e.getValue());
        }
        return m.entrySet();
    }

    public Object get(Object key) {
        return this.map.get(this.prefix + key);
    }

    public int hashCode() {
        return this.map.hashCode() + this.prefix.hashCode();
    }

    public boolean isEmpty() {
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(this.prefix)) continue;
            return false;
        }
        return true;
    }

    public Set keySet() {
        HashSet<String> s = new HashSet<String>();
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(this.prefix)) continue;
            s.add(key.substring(this.prefix.length()));
        }
        return s;
    }

    public Object put(Object key, Object value) {
        return this.map.put(this.prefix + key, value);
    }

    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            this.put(key, e.getValue());
        }
    }

    public Object remove(Object key) {
        return this.map.remove(this.prefix + key);
    }

    public int size() {
        int n = 0;
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(this.prefix)) continue;
            ++n;
        }
        return n;
    }

    public Collection values() {
        Vector c = new Vector();
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            if (!key.startsWith(this.prefix)) continue;
            c.add(e.getValue());
        }
        return c;
    }
}

