/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.TestResultsByStatusAndTitleComparator;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;

class ResultSection
extends HTMLSection {
    private TestResultTable resultTable;
    private File[] initFiles;
    TreeSet[] lists;
    private int totalFound;
    private final int[] fileCodes = new int[]{5, 6, 7, 8};
    private final int[] groupedFileCodes = new int[]{13, 14, 15};
    private final I18NResourceBundle i18n;
    private final String[] headings;

    ResultSection(HTMLReport parent, ReportSettings settings, File dir, I18NResourceBundle i18n, TreeSet[] sortedResults) {
        super(i18n.getString("result.title"), settings, dir, parent);
        this.i18n = i18n;
        this.headings = new String[]{i18n.getString("result.heading.passed"), i18n.getString("result.heading.failed"), i18n.getString("result.heading.errors"), i18n.getString("result.heading.notRun")};
        this.resultTable = settings.getInterview().getWorkDirectory().getTestResultTable();
        this.initFiles = settings.getInitialFiles();
        this.lists = sortedResults;
        for (TreeSet s : sortedResults) {
            this.totalFound += s.size();
        }
    }

    void writeSummary(ReportWriter out) throws IOException {
        super.writeSummary(out);
        out.startTag("table");
        out.writeAttr("border", 1);
        boolean thirdColumn = false;
        boolean secondColumn = false;
        for (int i = 0; i < this.lists.length; ++i) {
            thirdColumn |= this.settings.isStateFileEnabled(i) && this.hasGroupedReport(i);
            secondColumn |= this.settings.isStateFileEnabled(i);
        }
        String grouped = this.i18n.getString("result.grouped");
        String plain = this.i18n.getString("result.plain");
        for (int i = 0; i < this.lists.length; ++i) {
            String reportFile = HTMLReport.files[this.fileCodes[i]];
            TreeSet l = this.lists[i];
            int n = l.size();
            if (n <= 0) continue;
            out.startTag("tr");
            out.writeTH(this.headings[i], "row");
            out.startTag("td");
            out.writeAttr("align", "right");
            out.write(Integer.toString(n));
            out.endTag("td");
            if (secondColumn) {
                out.startTag("td");
                if (this.settings.isStateFileEnabled(i)) {
                    out.writeLink(reportFile, plain);
                } else {
                    out.writeLine(" ");
                }
                out.endTag("td");
            }
            if (thirdColumn) {
                out.startTag("td");
                if (this.hasGroupedReport(i) && this.settings.isStateFileEnabled(i)) {
                    out.writeLink(HTMLReport.files[this.groupedFileCodes[i]], grouped);
                } else {
                    out.writeLine(" ");
                }
                out.endTag("td");
            }
            out.endTag("tr");
        }
        out.startTag("tr");
        out.writeTH(this.i18n.getString("result.total"), "row");
        out.writeTD(Integer.toString(this.totalFound));
        if (secondColumn) {
            out.writeTD("");
        }
        if (thirdColumn) {
            out.writeTD("");
        }
        out.endTag("tr");
        out.endTag("table");
    }

    private boolean hasGroupedReport(int st) {
        return st == 1 || st == 0 || st == 2;
    }

    void writeExtraFiles() throws IOException {
        this.writeStatusFiles();
    }

    private void writeStatusFiles() throws IOException {
        for (int i = 0; i < this.lists.length; ++i) {
            if (!this.settings.isStateFileEnabled(i)) continue;
            this.writeUnGroupedReport(i);
            if (!this.hasGroupedReport(i)) continue;
            TreeSet newS = new TreeSet(new TestResultsByStatusAndTitleComparator());
            newS.addAll(this.lists[i]);
            this.lists[i] = newS;
            this.writeGroupedReport(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnGroupedReport(int i) throws IOException {
        ReportWriter out = this.openAuxFile(this.fileCodes[i], this.headings[i], this.i18n);
        try {
            TreeSet list = this.lists[i];
            if (list.size() > 0) {
                boolean inList = false;
                for (TestResult e : list) {
                    String title;
                    try {
                        TestDescription e_td = e.getDescription();
                        title = e_td.getTitle();
                    }
                    catch (TestResult.Fault ex) {
                        title = null;
                    }
                    Status e_s = e.getStatus();
                    if (!inList) {
                        inList = true;
                    }
                    String eWRPath = e.getWorkRelativePath();
                    File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                    String eName = e.getTestName();
                    if (eFile == null || e_s.getType() == 3) {
                        out.write(eName);
                    } else {
                        out.writeLink(eFile, eName);
                    }
                    if (title != null) {
                        out.write(": " + title);
                    }
                    out.startTag("br");
                    out.newLine();
                }
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGroupedReport(int i) throws IOException {
        ReportWriter out = this.openAuxFile(this.groupedFileCodes[i], this.headings[i], this.i18n);
        out.write(this.i18n.getString("result.groupByStatus"));
        try {
            TreeSet list = this.lists[i];
            if (list.size() > 0) {
                boolean inList = false;
                String currentHead = null;
                for (TestResult e : list) {
                    String title;
                    try {
                        TestDescription e_td = e.getDescription();
                        title = e_td.getTitle();
                    }
                    catch (TestResult.Fault ex) {
                        title = null;
                    }
                    Status e_s = e.getStatus();
                    if (!e_s.getReason().equals(currentHead)) {
                        currentHead = e_s.getReason();
                        if (inList) {
                            inList = false;
                            out.endTag("ul");
                            out.newLine();
                        }
                        out.startTag("h4");
                        out.write(currentHead.length() == 0 ? this.i18n.getString("result.noReason") : currentHead);
                        out.endTag("h4");
                        out.newLine();
                    }
                    if (!inList) {
                        inList = true;
                        out.startTag("ul");
                    }
                    out.startTag("li");
                    String eWRPath = e.getWorkRelativePath();
                    File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                    String eName = e.getTestName();
                    if (eFile == null || e_s.getType() == 3) {
                        out.write(eName);
                    } else {
                        out.writeLink(eFile, eName);
                    }
                    if (title != null) {
                        out.write(": " + title);
                    }
                    out.newLine();
                }
                if (inList) {
                    inList = false;
                    out.endTag("ul");
                }
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

