/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.TestResult;
import com.sun.javatest.report.KflSorter;
import com.sun.javatest.report.ReportSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KflPlainText {
    private KflSorter sorter;
    private File dir;
    private KnownFailuresList kfl;

    KflPlainText(ReportSettings s) {
        this.sorter = s.getKflSorter();
        this.kfl = this.sorter.getKfl();
    }

    public void write(File dir, boolean writeTcs) {
        this.dir = dir;
        this.writeTestSet("fail2missing.txt", "kfl.f2m", this.sorter.getSet(KflSorter.Transitions.FAIL2MISSING));
        this.writeTestSet("fail2pass.txt", "kfl.f2p", this.sorter.getSet(KflSorter.Transitions.FAIL2PASS));
        this.writeTestSet("faiL2error.txt", "kfl.f2e", this.sorter.getSet(KflSorter.Transitions.FAIL2ERROR));
        this.writeTestSet("fail2notrun.txt", "kfl.f2nr", this.sorter.getSet(KflSorter.Transitions.FAIL2NOTRUN));
        this.writeTestSet("fail2fail.txt", "kfl.f2f", this.sorter.getSet(KflSorter.Transitions.FAIL2FAIL));
        this.writeTestSet("newfailures.txt", "kfl.new", this.sorter.getSet(KflSorter.Transitions.NEWFAILURES));
        this.writeTestSet("other_errors.txt", "kfl.errors", this.sorter.getSet(KflSorter.Transitions.OTHER_ERRORS));
        if (writeTcs) {
            this.writeTestCaseSet("tc_fail2missing.txt", "kfl.tc_f2m", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2MISSING));
            this.writeTestCaseSet("tc_fail2pass.txt", "kfl.tc_f2p", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2PASS));
            this.writeTestCaseSet("tc_fail2error.txt", "kfl.tc_f2e", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2ERROR));
            this.writeTestCaseSet("tc_fail2notrun.txt", "kfl.tc_f2nr", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2NOTRUN));
            this.writeTestCaseSet("tc_newfailures.txt", "kfl.tc_new", this.sorter.getSet(KflSorter.Transitions.TC_NEWFAILURES));
        }
    }

    private void writeTestSet(String f, String id, TreeSet<KflSorter.TestDiff> tests) {
        try {
            FileWriter out = new FileWriter(new File(this.dir, f));
            out.write("# ");
            out.write(f);
            out.write("\n");
            for (KflSorter.TestDiff diff : tests) {
                TestResult tr = diff.getTestResult();
                out.write(diff.getName());
                out.write(" ");
                this.writeBugs(diff, out);
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeBugs(KflSorter.TestDiff diff, Writer writer) throws IOException {
        KnownFailuresList.Entry[] e = null;
        if (diff.getTestCase() == null) {
            e = this.kfl.find(diff.getTestName());
        } else {
            KnownFailuresList.Entry ee = this.kfl.find(diff.getTestName(), diff.getTestCase());
            if (ee != null) {
                e = new KnownFailuresList.Entry[]{ee};
            }
        }
        if (e == null || e.length == 0) {
            if (diff.getKflEntry() != null) {
                e = new KnownFailuresList.Entry[]{diff.getKflEntry()};
            } else {
                return;
            }
        }
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < e.length; ++i) {
            String[] bugs = e[i].getBugIdStrings();
            if (bugs == null || bugs.length == 0) continue;
            for (int j = 0; j < bugs.length; ++j) {
                if (bugs[j].equals("0000000") || bugs[j].equals("0") || hs.contains(bugs[j])) continue;
                hs.add(bugs[j]);
                writer.write(bugs[j]);
                if (bugs.length == j + 1) continue;
                writer.write(",");
            }
        }
        writer.write("\n");
    }

    private void writeTestCaseSet(String f, String id, TreeSet<KflSorter.TestDiff> tests) {
        this.writeTestSet(f, id, tests);
    }
}

