/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.mrep.CopyHandler;
import com.sun.javatest.mrep.XMLReportReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

class XMLReportWriter {
    public static String XML_CHARSET = "UTF-8";
    private final AttributesImpl emptyAttr = new AttributesImpl();
    private TransformerHandler ser;
    private Writer fw;

    public XMLReportWriter(File file) throws IOException {
        Properties outputProps = new Properties();
        outputProps.put("indent", "yes");
        outputProps.put("encoding", XML_CHARSET);
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        stf.setAttribute("indent-number", 4);
        try {
            this.ser = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        this.ser.getTransformer().setOutputProperties(outputProps);
        this.fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        this.ser.setResult(new StreamResult(this.fw));
    }

    static String dateToISO8601(Date date) {
        SimpleDateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String dateStr = dfISO8601.format(date);
        return dateStr.substring(0, 22) + ":" + dateStr.substring(22);
    }

    static Date ISO8601toDate(String dateStr) throws ParseException {
        SimpleDateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        Date date = dfISO8601.parse(dateStr.substring(0, 22) + dateStr.substring(23));
        return date;
    }

    private void sReport() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "xmlns:xsi", "String", "http://www.w3.org/2001/XMLSchema-instance");
        atts.addAttribute("", "", "xsi:noNamespaceSchemaLocation", "String", "test_run_report.xsd");
        atts.addAttribute("", "", "formatVersion", "String", "v1");
        atts.addAttribute("", "", "generatedTime", "String", XMLReportWriter.dateToISO8601(new Date()));
        this.ser.startElement("", "", "Report", atts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File[] file, Map[] map) throws SAXException, ParserConfigurationException, IOException {
        try {
            XMLReader reader;
            int i;
            this.ser.startDocument();
            this.sReport();
            this.ser.startElement("", "", "WorkDirectories", this.emptyAttr);
            for (i = 0; i < file.length; ++i) {
                reader = XMLReportReader.createXMLReader(false);
                reader.setContentHandler(new CopyHandler(this.ser, true, map[i]));
                reader.parse(new InputSource(file[i].getAbsolutePath()));
            }
            this.ser.endElement("", "", "WorkDirectories");
            this.ser.startElement("", "", "TestResults", this.emptyAttr);
            for (i = 0; i < file.length; ++i) {
                reader = XMLReportReader.createXMLReader(false);
                reader.setContentHandler(new CopyHandler(this.ser, false, map[i]));
                reader.parse(new InputSource(file[i].getAbsolutePath()));
            }
            this.ser.endElement("", "", "TestResults");
            this.ser.endElement("", "", "Report");
            this.ser.endDocument();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.fw.close();
            throw throwable;
        }
        this.fw.close();
    }
}

