/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLTestFinder
extends TestFinder {
    private Hashtable namesInFile = new Hashtable();
    private Hashtable excludeList = new Hashtable(excludeNames.length);
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files"};
    private Hashtable extensionTable;
    private static final String[] extensions = new String[]{".html", ".htm"};
    public static final int WEB_WALK = 1;
    public static final int DIR_WALK = 2;
    private int mode = 2;
    private boolean ignoreErrors = false;
    private File validatedRoot;
    private File currFile;
    private Reader input;
    private int c;
    private int line;
    private StringBuffer text;
    private String endTestDescriptionTag;
    private Hashtable params;
    private String defTerm;
    private Vector tableRow;
    private String lastName;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HTMLTestFinder.class);

    public HTMLTestFinder() {
        int i;
        for (i = 0; i < excludeNames.length; ++i) {
            this.excludeList.put(excludeNames[i], excludeNames[i]);
        }
        this.extensionTable = new Hashtable(extensions.length);
        for (i = 0; i < extensions.length; ++i) {
            this.extensionTable.put(extensions[i], extensions[i]);
        }
    }

    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equalsIgnoreCase("-webWalk")) {
            this.mode = 1;
            return 1;
        }
        if (args[i].equalsIgnoreCase("-dirWalk")) {
            this.mode = 2;
            return 1;
        }
        if (args[i].equalsIgnoreCase("-IGNORE-ERRORS")) {
            this.ignoreErrors = true;
            return 1;
        }
        return super.decodeArg(args, i);
    }

    public File getRoot() {
        File providedRoot = super.getRoot();
        if (this.mode == 2 && providedRoot.isFile()) {
            this.validatedRoot = new File(providedRoot.getParent());
        } else {
            if (this.mode == 1 && providedRoot.isDirectory()) {
                throw new IllegalStateException(i18n.getString("html.badRootForWebWalk", providedRoot.getPath()));
            }
            this.validatedRoot = new File(providedRoot.getPath());
        }
        return this.validatedRoot;
    }

    protected void localizedError(String msg) {
        if (!this.ignoreErrors) {
            super.localizedError(msg);
        }
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    protected void scan(File file) {
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    private void scanDirectory(File dir) {
        if (this.mode == 1) {
            return;
        }
        String[] names = dir.list();
        for (int i = 0; i < names.length; ++i) {
            String extn;
            String name = names[i];
            if (this.excludeList.containsKey(name)) continue;
            File file = new File(dir, name);
            if (file.isDirectory()) {
                this.foundFile(file);
                continue;
            }
            int dot = name.lastIndexOf(46);
            if (dot == -1 || !this.extensionTable.containsKey(extn = name.substring(dot))) continue;
            this.foundFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void scanFile(File file) {
        block49: {
            this.input = null;
            this.lastName = null;
            this.namesInFile.clear();
            this.input = new BufferedReader(new FileReader(file));
            this.currFile = file;
            this.line = 1;
            this.nextCh();
            block19: while (this.c >= 0) {
                switch (this.c) {
                    case 60: {
                        String tag;
                        this.nextCh();
                        this.skipSpace();
                        switch (this.c) {
                            case 33: {
                                this.nextCh();
                                if (this.c != 45) continue block19;
                                this.nextCh();
                                if (this.c != 45) continue block19;
                                this.nextCh();
                                this.skipComment();
                                continue block19;
                            }
                            case 47: {
                                this.nextCh();
                                tag = this.scanIdentifier();
                                if (tag.equals("dl")) {
                                    this.endDefList();
                                } else if (tag.equals("td") || tag.equals("th")) {
                                    this.endTableData();
                                } else if (tag.equals("tr") || tag.equals("table")) {
                                    this.endTableRow();
                                }
                                this.skipTag();
                                if (!this.inTestDescription() || !tag.equals(this.endTestDescriptionTag)) continue block19;
                                this.foundTestDescription(this.params, file, this.line);
                                this.params = null;
                                continue block19;
                            }
                        }
                        tag = this.scanIdentifier();
                        if (tag.equals("a")) {
                            this.scanLink(file);
                            continue block19;
                        }
                        if (tag.equals("table")) {
                            this.scanTable(file);
                            continue block19;
                        }
                        if (tag.equals("tr")) {
                            this.scanTableRow();
                            continue block19;
                        }
                        if (tag.equals("td") || tag.equals("th")) {
                            this.scanTableData();
                            continue block19;
                        }
                        if (tag.equals("dl")) {
                            this.scanDefList(file);
                            continue block19;
                        }
                        if (tag.equals("dt")) {
                            this.scanDefTerm();
                            continue block19;
                        }
                        if (tag.equals("dd")) {
                            this.scanDefData();
                            continue block19;
                        }
                        this.skipTag();
                        continue block19;
                    }
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        if (this.text != null && this.text.length() > 0 && this.text.charAt(this.text.length() - 1) != ' ') {
                            this.text.append(' ');
                        }
                        this.nextCh();
                        continue block19;
                    }
                    case 38: {
                        String tag;
                        String replace = null;
                        this.nextCh();
                        if (this.c == 35) {
                            int n = 0;
                            this.nextCh();
                            tag = "#";
                            while (48 <= this.c && this.c <= 57) {
                                tag = tag + (char)this.c;
                                n = n * 10 + (this.c - 48);
                                this.nextCh();
                            }
                            replace = "" + (char)n;
                        } else {
                            tag = this.scanIdentifier();
                            if (tag.equals("lt")) {
                                replace = "<";
                            } else if (tag.equals("gt")) {
                                replace = ">";
                            } else if (tag.equals("amp")) {
                                replace = "&";
                            } else if (tag.equals("copy")) {
                                replace = "\u00a9";
                            }
                            if (replace == null) {
                                replace = "&" + tag + (char)this.c;
                            }
                        }
                        if (this.c != 59) {
                            if (!Character.isWhitespace((char)this.c)) {
                                tag = tag + (char)this.c;
                            }
                            this.error(i18n, "html.badEscape", new Object[]{tag, file});
                        }
                        if (this.text != null) {
                            this.text.append(replace);
                        }
                        this.nextCh();
                        continue block19;
                    }
                }
                if (this.text != null) {
                    this.text.append((char)this.c);
                }
                this.nextCh();
            }
            Object var6_7 = null;
            if (this.input == null) break block49;
            try {
                this.input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.input = null;
            {
                break block49;
                catch (FileNotFoundException ex) {
                    this.error(i18n, "html.cantFindFile", file);
                    Object var6_8 = null;
                    if (this.input == null) break block49;
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.input = null;
                    break block49;
                }
                catch (IOException ex) {
                    this.error(i18n, "html.ioError", new Object[]{file, new Integer(this.line), ex});
                    Object var6_9 = null;
                    if (this.input == null) break block49;
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.input = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (this.input != null) {
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.input = null;
                }
                throw throwable;
            }
        }
    }

    protected File getCurrentFile() {
        return this.currFile;
    }

    private void nextCh() throws IOException {
        this.c = this.input.read();
        if (this.c == 10) {
            ++this.line;
        }
    }

    private boolean inTestDescription() {
        return this.params != null;
    }

    private void scanTable(File context) throws IOException {
        if (debug) {
            System.err.println("scanning table starting in line " + this.line);
        }
        String id = this.lastName;
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            String value = this.scanValue();
            this.skipSpace();
            if (att.equals("class") && "TestDescription".equals(value)) {
                this.params = new Hashtable();
                this.endTestDescriptionTag = "table";
                continue;
            }
            if (!att.equals("id")) continue;
            id = value;
        }
        this.nextCh();
        if (this.params != null && id != null) {
            this.processEntry(this.params, "id", id);
        }
    }

    private void scanTableRow() throws IOException {
        this.skipTag();
        if (this.params != null) {
            this.endTableRow();
            this.tableRow = new Vector();
        }
    }

    private void endTableRow() throws IOException {
        if (this.params != null && this.tableRow != null) {
            this.endTableData();
            if (this.tableRow.size() == 2) {
                this.processEntry(this.params, (String)this.tableRow.elementAt(0), (String)this.tableRow.elementAt(1));
            }
            this.tableRow = null;
        }
    }

    private void scanTableData() throws IOException {
        this.skipTag();
        if (this.params != null && this.tableRow != null) {
            this.endTableData();
            this.text = new StringBuffer();
        }
    }

    private void endTableData() throws IOException {
        if (this.params != null && this.tableRow != null && this.text != null) {
            while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                this.text.setLength(this.text.length() - 1);
            }
            this.tableRow.addElement(new String(this.text));
            this.text = null;
        }
    }

    private void scanDefList(File context) throws IOException {
        String id = this.lastName;
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            String value = this.scanValue();
            this.skipSpace();
            if (att.equals("class") && "TestDescription".equals(value)) {
                this.params = new Hashtable();
                this.endTestDescriptionTag = "dl";
                continue;
            }
            if (!att.equals("id")) continue;
            id = value;
        }
        this.nextCh();
        if (this.params != null && id != null) {
            this.processEntry(this.params, "id", id);
        }
    }

    private void scanDefTerm() throws IOException {
        this.skipTag();
        if (this.params != null) {
            if (this.defTerm != null && this.text != null) {
                while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                    this.text.setLength(this.text.length() - 1);
                }
                String defData = new String(this.text);
                this.processEntry(this.params, this.defTerm, defData);
            }
            this.defTerm = null;
            this.text = new StringBuffer();
        }
    }

    private void scanDefData() throws IOException {
        this.skipTag();
        if (this.params != null && this.text != null) {
            while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                this.text.setLength(this.text.length() - 1);
            }
            this.defTerm = new String(this.text);
            this.text = new StringBuffer();
        }
    }

    private void endDefList() throws IOException {
        if (this.params != null) {
            if (this.defTerm != null && this.text != null) {
                while (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == ' ') {
                    this.text.setLength(this.text.length() - 1);
                }
                String defData = new String(this.text);
                this.processEntry(this.params, this.defTerm, defData);
            }
            this.defTerm = null;
            this.text = null;
        }
    }

    private String scanIdentifier() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            if (this.c >= 97 && this.c <= 122) {
                buf.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c >= 65 && this.c <= 90) {
                buf.append((char)(97 + (this.c - 65)));
                this.nextCh();
                continue;
            }
            if (this.c >= 48 && this.c <= 57) {
                buf.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c != 45) break;
            buf.append((char)this.c);
            this.nextCh();
        }
        if (buf.length() == 0) {
            throw new IOException("Identifier expected");
        }
        return buf.toString();
    }

    private void scanLink(File context) throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            String value = this.scanValue();
            this.skipSpace();
            if (this.mode == 1 && att.equals("href") && value.indexOf(58) == -1 && !value.startsWith("/") && !value.startsWith("../")) {
                int refStart = value.lastIndexOf(35);
                if (refStart != -1) {
                    value = value.substring(0, refStart);
                }
                value = value.trim();
                File file = new File(context.getParent(), value.replace('/', File.separatorChar));
                String f = file.getPath();
                if (f.endsWith(".html") || f.endsWith(".htm")) {
                    this.foundFile(file);
                }
            }
            if (!att.equals("name")) continue;
            this.lastName = value;
            Integer here = new Integer(this.line);
            Integer prev = this.namesInFile.put(value, here);
            if (prev == null) continue;
            this.error(i18n, "html.multipleName", new Object[]{value, context, here, prev});
        }
        this.nextCh();
    }

    private String scanValue() throws IOException {
        this.skipSpace();
        if (this.c != 61) {
            return "";
        }
        int quote = -1;
        this.nextCh();
        this.skipSpace();
        if (this.c == 39 || this.c == 34) {
            quote = this.c;
            this.nextCh();
            this.skipSpace();
        }
        StringBuffer buf = new StringBuffer();
        while (quote < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || quote >= 0 && this.c != quote) {
            if (this.c == -1 || this.c == 10 || this.c == 13) {
                this.error(i18n, "html.quoteMismatch", new Object[]{this.currFile, new Integer(this.line)});
                break;
            }
            buf.append((char)this.c);
            this.nextCh();
        }
        if (this.c == quote) {
            this.nextCh();
        }
        this.skipSpace();
        return buf.toString();
    }

    private void skipComment() throws IOException {
        int numHyphens = 0;
        while (this.c != -1 && (numHyphens < 2 || this.c != 62)) {
            numHyphens = this.c == 45 ? ++numHyphens : 0;
            this.nextCh();
        }
        this.nextCh();
    }

    private void skipSpace() throws IOException {
        while (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13) {
            this.nextCh();
        }
    }

    private void skipTag() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            if (att == "") {
                throw new IOException("error parsing HTML input");
            }
            String value = this.scanValue();
            this.skipSpace();
        }
        this.nextCh();
    }
}

