/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BinaryTestWriter {
    private static final TestDescription[] noTests = new TestDescription[0];
    private PrintStream log = System.out;
    private boolean strictFinder = false;
    private int numFinderErrors = 0;

    public static void main(String[] args) {
        int result = 0;
        try {
            BinaryTestWriter m = new BinaryTestWriter();
            result = m.run(args);
        }
        catch (BadArgs e) {
            System.err.println("Bad Arguments: " + e.getMessage());
            BinaryTestWriter.usage(System.err);
            System.exit(1);
        }
        catch (Fault f) {
            System.err.println("Error: " + f.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
            System.exit(3);
        }
        System.exit(result);
    }

    private static void usage(PrintStream out) {
        String prog = System.getProperty("program", "java " + BinaryTestWriter.class.getName());
        out.println("Usage:");
        out.println("  " + prog + " [options]  test-suite [tests...]");
        out.println("Options:");
        out.println("  -finder finderClass finderArgs... -end");
        out.println("  -o output-file");
        out.println("  -strictFinder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws BadArgs, Fault, IOException {
        IOException e222;
        int n;
        FileOutputStream fos;
        block32: {
            ZipOutputStream zos;
            block29: {
                IOException e222;
                int n2;
                block30: {
                    File testSuite = null;
                    String finder = "com.sun.javatest.finder.TagTestFinder";
                    String[] finderArgs = new String[]{};
                    File outFile = null;
                    File[] tests = null;
                    for (int i = 0; i < args.length; ++i) {
                        int j;
                        if (args[i].equalsIgnoreCase("-finder") && i + 1 < args.length) {
                            finder = args[++i];
                            j = ++i;
                            while (i < args.length - 1 && !args[i].equalsIgnoreCase("-end")) {
                                ++i;
                            }
                            finderArgs = new String[i - j];
                            System.arraycopy(args, j, finderArgs, 0, finderArgs.length);
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-o") && i + 1 < args.length) {
                            outFile = new File(args[++i]);
                            continue;
                        }
                        if (args[i].equalsIgnoreCase("-strictFinder")) {
                            this.strictFinder = true;
                            continue;
                        }
                        if (args[i].startsWith("-")) {
                            throw new BadArgs(args[i]);
                        }
                        testSuite = new File(args[i++]);
                        if (i >= args.length) break;
                        tests = new File[args.length - i];
                        for (j = 0; j < tests.length; ++j) {
                            tests[j] = new File(args[i + j]);
                        }
                        break;
                    }
                    if (testSuite == null) {
                        throw new BadArgs("testsuite.html file not specified");
                    }
                    TestFinder testFinder = this.initializeTestFinder(finder, finderArgs, testSuite);
                    if (tests == null) {
                        tests = new File[]{testFinder.getRoot()};
                    }
                    if (outFile == null) {
                        outFile = new File(testFinder.getRootDir(), "testsuite.jtd");
                    }
                    if (this.strictFinder) {
                        testFinder.setErrorHandler(new TestFinder.ErrorHandler(){

                            public void error(String msg) {
                                BinaryTestWriter.this.numFinderErrors++;
                                System.err.println("Finder reported error:\n" + msg);
                                System.err.println("");
                            }
                        });
                    }
                    StringTable stringTable = new StringTable();
                    TestTable testTable = new TestTable(stringTable);
                    TestTree testTree = new TestTree(testTable);
                    if (this.log != null) {
                        this.log.println("Reading tests...");
                    }
                    this.read(testFinder, tests, testTree);
                    if (testTree.getSize() == 0) {
                        throw new Fault("No tests found -- check arguments.");
                    }
                    if (this.log != null) {
                        this.log.println("Writing " + outFile);
                    }
                    fos = new FileOutputStream(outFile);
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new BufferedOutputStream(fos));
                        zos.setMethod(8);
                        zos.setLevel(9);
                        ZipEntry stringZipEntry = stringTable.write(zos);
                        ZipEntry testTableZipEntry = testTable.write(zos);
                        ZipEntry testTreeZipEntry = testTree.write(zos);
                        zos.close();
                        if (this.log != null) {
                            this.log.println("strings: " + stringTable.getSize() + " entries, " + this.zipStats(stringZipEntry));
                            this.log.println("tests: " + testTable.getSize() + " tests, " + this.zipStats(testTableZipEntry));
                            this.log.println("tree: " + testTree.getSize() + " nodes, " + this.zipStats(testTreeZipEntry));
                        }
                        if (!this.strictFinder || this.numFinderErrors <= 0) break block29;
                        System.err.println("*** Source finder reported " + this.numFinderErrors + " errors during execution. ***");
                        n2 = 4;
                        Object var18_20 = null;
                        if (zos == null) break block30;
                    }
                    catch (Throwable throwable) {
                        block34: {
                            IOException e222;
                            Object var18_22 = null;
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (IOException e222) {
                                    // empty catch block
                                }
                            }
                            if (fos == null) break block34;
                            try {
                                fos.close();
                            }
                            catch (IOException e222) {}
                        }
                        throw throwable;
                    }
                    try {
                        zos.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                return n2;
            }
            n = 0;
            Object var18_21 = null;
            if (zos == null) break block32;
            try {
                zos.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e222) {
                // empty catch block
            }
        }
        return n;
    }

    private TestFinder initializeTestFinder(String finder, String[] args, File ts) throws Fault {
        TestFinder testFinder;
        if (ts == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> c = Class.forName(finder);
            testFinder = (TestFinder)c.newInstance();
            testFinder.init(args, ts, null);
        }
        catch (ClassNotFoundException e) {
            throw new Fault("Error: Can't find class for test finder specified: " + finder);
        }
        catch (InstantiationException e) {
            throw new Fault("Error: Can't create new instance of test finder: " + e);
        }
        catch (IllegalAccessException e) {
            throw new Fault("Error: Can't access test finder: " + e);
        }
        catch (TestFinder.Fault e) {
            throw new Fault("Error: Can't initialize test-finder: " + e.getMessage());
        }
        return testFinder;
    }

    private File getTestSuiteFile(String file) throws Fault {
        File tsa = new File(file);
        if (tsa.isFile()) {
            return tsa;
        }
        File tsb = new File(tsa, "testsuite.html");
        if (tsb.exists()) {
            return tsb;
        }
        File tsc = new File(tsa, "tests/testsuite.html");
        if (tsc.exists()) {
            return tsc;
        }
        throw new Fault("Bad input. " + file + " is not a JCK");
    }

    private String zipStats(ZipEntry e) {
        long size = e.getSize();
        long csize = e.getCompressedSize();
        return size + " bytes (" + csize + " compressed, " + csize * 100L / size + "%)";
    }

    void read(TestFinder finder, File[] files, TestTree testTree) throws Fault {
        if (files.length < 1) {
            throw new IllegalArgumentException();
        }
        File rootDir = finder.getRootDir();
        HashSet allFiles = new HashSet();
        TestTree.Node r = null;
        for (int i = 0; i < files.length; ++i) {
            TestTree.Node n;
            File f = files[i];
            if (!f.isAbsolute()) {
                f = new File(rootDir, f.getPath());
            }
            if ((n = this.read0(finder, f, testTree, allFiles)) == null) continue;
            while (!f.equals(rootDir)) {
                f = f.getParentFile();
                TestTree testTree2 = testTree;
                testTree2.getClass();
                n = testTree2.new TestTree.Node(f.getName(), noTests, new TestTree.Node[]{n});
            }
            r = r == null ? n : r.merge(n);
        }
        if (r == null) {
            throw new Fault("No tests found");
        }
        testTree.setRoot(r);
    }

    private TestTree.Node read0(TestFinder finder, File file, TestTree testTree, Set allFiles) {
        if (allFiles.contains(file)) {
            return null;
        }
        allFiles.add(file);
        finder.read(file);
        TestDescription[] tests = finder.getTests();
        Object[] files = finder.getFiles();
        if (tests.length == 0 && files.length == 0) {
            return null;
        }
        Arrays.sort(files);
        Arrays.sort(tests, new Comparator(){

            public int compare(Object o1, Object o2) {
                TestDescription td1 = (TestDescription)o1;
                TestDescription td2 = (TestDescription)o2;
                return td1.getRootRelativeURL().compareTo(td2.getRootRelativeURL());
            }
        });
        Vector<TestTree.Node> v = new Vector<TestTree.Node>();
        for (int i = 0; i < files.length; ++i) {
            TestTree.Node n = this.read0(finder, (File)files[i], testTree, allFiles);
            if (n == null) continue;
            v.addElement(n);
        }
        Object[] nodes = new TestTree.Node[v.size()];
        v.copyInto(nodes);
        TestTree testTree2 = testTree;
        testTree2.getClass();
        return testTree2.new TestTree.Node(file.getName(), tests, (TestTree.Node[])nodes);
    }

    private static void writeInt(DataOutputStream out, int v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException();
        }
        boolean leadZero = true;
        for (int i = 28; i > 0; i -= 7) {
            int b = v >> i & 0x7F;
            boolean bl = leadZero = leadZero && b == 0;
            if (leadZero) continue;
            out.writeByte(0x80 | b);
        }
        out.writeByte(v & 0x7F);
    }

    static class TestTree {
        private Node root;
        private TestTable testTable;

        TestTree(TestTable testTable) {
            this.testTable = testTable;
        }

        void setRoot(Node root) {
            this.root = root;
        }

        int getSize() {
            return this.root == null ? 0 : this.root.getSize();
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("tree");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            this.root.write(o);
        }

        class Node {
            private String name;
            private TestDescription[] tests;
            private Node[] children;

            Node(String name, TestDescription[] tests, Node[] children) {
                this.name = name;
                this.tests = tests;
                this.children = children;
                for (int i = 0; i < tests.length; ++i) {
                    TestTree.this.testTable.add(tests[i]);
                }
            }

            int getSize() {
                int n = 1;
                if (this.children != null) {
                    for (int i = 0; i < this.children.length; ++i) {
                        n += this.children[i].getSize();
                    }
                }
                return n;
            }

            Node merge(Node other) {
                TestDescription[] mergedTests;
                int i;
                if (!other.name.equals(this.name)) {
                    throw new IllegalArgumentException(this.name + ":" + other.name);
                }
                TreeMap<String, Node> mergedChildrenMap = new TreeMap<String, Node>();
                for (i = 0; i < this.children.length; ++i) {
                    Node child = this.children[i];
                    mergedChildrenMap.put(child.name, child);
                }
                for (i = 0; i < other.children.length; ++i) {
                    Node otherChild = other.children[i];
                    Node c = (Node)mergedChildrenMap.get(otherChild.name);
                    mergedChildrenMap.put(otherChild.name, c == null ? otherChild : otherChild.merge(c));
                }
                Node[] mergedChildren = mergedChildrenMap.values().toArray(new Node[mergedChildrenMap.size()]);
                if (this.tests.length + other.tests.length == 0) {
                    mergedTests = noTests;
                } else {
                    mergedTests = new TestDescription[this.tests.length + other.tests.length];
                    System.arraycopy(this.tests, 0, mergedTests, 0, this.tests.length);
                    System.arraycopy(other.tests, 0, mergedTests, this.tests.length, other.tests.length);
                }
                return new Node(this.name, mergedTests, mergedChildren);
            }

            void write(DataOutputStream o) throws IOException {
                int i;
                o.writeUTF(this.name);
                BinaryTestWriter.writeInt(o, this.tests.length);
                for (i = 0; i < this.tests.length; ++i) {
                    BinaryTestWriter.writeInt(o, TestTree.this.testTable.getIndex(this.tests[i]));
                }
                BinaryTestWriter.writeInt(o, this.children.length);
                for (i = 0; i < this.children.length; ++i) {
                    this.children[i].write(o);
                }
            }
        }
    }

    static class TestTable {
        private HashMap testMap = new HashMap();
        private Vector tests = new Vector();
        private StringTable stringTable;

        TestTable(StringTable stringTable) {
            this.stringTable = stringTable;
        }

        void add(TestDescription td) {
            this.tests.addElement(td);
            this.testMap.put(td, new Entry());
            this.stringTable.add(td);
        }

        int getSize() {
            return this.tests.size();
        }

        int getIndex(TestDescription td) {
            Entry e = (Entry)this.testMap.get(td);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            return e.index;
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("tests");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            BinaryTestWriter.writeInt(o, this.tests.size());
            for (int i = 0; i < this.tests.size(); ++i) {
                TestDescription td = (TestDescription)this.tests.elementAt(i);
                Entry e = (Entry)this.testMap.get(td);
                e.index = o.size();
                this.write(td, o);
            }
        }

        private void write(TestDescription td, DataOutputStream o) throws IOException {
            BinaryTestWriter.writeInt(o, td.getParameterCount());
            Iterator i = td.getParameterKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = td.getParameter(key);
                this.stringTable.writeRef(key, o);
                this.stringTable.writeRef(value, o);
            }
        }

        class Entry {
            int index = -1;

            Entry() {
            }
        }
    }

    static class StringTable {
        private TreeMap map = new TreeMap();
        private int writtenSize;

        StringTable() {
        }

        void add(String s) {
            Entry e = (Entry)this.map.get(s);
            if (e == null) {
                e = new Entry();
                this.map.put(s, e);
            }
            ++e.useCount;
        }

        void add(TestDescription test) {
            Iterator i = test.getParameterKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                String param = test.getParameter(key);
                this.add(key);
                this.add(param);
            }
        }

        int getSize() {
            return this.map.size();
        }

        int getWrittenSize() {
            return this.writtenSize;
        }

        int getIndex(String s) {
            Entry e = (Entry)this.map.get(s);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            return e.index;
        }

        ZipEntry write(ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry("strings");
            zos.putNextEntry(entry);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.write(dos);
            dos.flush();
            zos.closeEntry();
            return entry;
        }

        void write(DataOutputStream o) throws IOException {
            Vector<String> v = new Vector<String>(this.map.size());
            v.addElement("");
            int nextIndex = 1;
            for (Map.Entry e : this.map.entrySet()) {
                String key = (String)e.getKey();
                Entry entry = (Entry)e.getValue();
                if (!entry.isFrequent()) continue;
                entry.index = nextIndex++;
                v.addElement(key);
            }
            BinaryTestWriter.writeInt(o, v.size());
            for (int i = 0; i < v.size(); ++i) {
                o.writeUTF((String)v.elementAt(i));
            }
            this.writtenSize = nextIndex;
        }

        void writeRef(String s, DataOutputStream o) throws IOException {
            Entry e = (Entry)this.map.get(s);
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (e.isFrequent()) {
                BinaryTestWriter.writeInt(o, e.index);
            } else {
                BinaryTestWriter.writeInt(o, 0);
                o.writeUTF(s);
            }
        }

        static class Entry {
            int useCount = 0;
            int index = 0;

            Entry() {
            }

            boolean isFrequent() {
                return this.useCount > 1;
            }
        }
    }

    public class Fault
    extends Exception {
        Fault(String msg) {
            super(msg);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String msg) {
            super(msg);
        }
    }
}

