/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ServiceViewer
extends ToolDialog
implements Interview.Observer {
    private ServiceManager mgr;
    private String[] ids;
    private JTable table;
    private JButton btnStart;
    private JButton btnStop;

    public ServiceViewer(final ServiceManager mgr, UIFactory uif, Component parent) {
        super(parent, uif, "serviceviewer");
        this.mgr = mgr;
        Set<String> keys = mgr.getAllServices().keySet();
        this.ids = new String[keys.size()];
        keys.toArray(this.ids);
        Arrays.sort(this.ids);
        this.initGUI();
        mgr.addObserver(new ServiceManager.Observer(){

            public void handleAlive(String sID, boolean alive) {
                int i = Arrays.binarySearch(ServiceViewer.this.ids, sID);
                if (i != -1) {
                    if (alive) {
                        ServiceViewer.this.table.getModel().setValueAt((Object)Status.ALIVE, i, 2);
                    } else {
                        ServiceViewer.this.table.getModel().setValueAt((Object)Status.NOT_ALIVE, i, 2);
                    }
                }
                ServiceViewer.this.table.repaint();
            }

            public void handleNotConnected(String sID, Service.NotConnectedException ex) {
                int i = Arrays.binarySearch(ServiceViewer.this.ids, sID);
                if (i != -1) {
                    ServiceViewer.this.table.getModel().setValueAt((Object)Status.NOT_CONNECTED, i, 2);
                }
                ServiceViewer.this.table.repaint();
            }

            public void handleError(String sID, Service.ServiceError ex) {
                int i = Arrays.binarySearch(ServiceViewer.this.ids, sID);
                if (i != -1) {
                    ServiceViewer.this.table.getModel().setValueAt((Object)Status.ERROR, i, 2);
                }
                ServiceViewer.this.table.repaint();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int[] ix;
                for (int i : ix = ServiceViewer.this.table.getSelectedRows()) {
                    Status stat;
                    try {
                        boolean isAlive = mgr.getAllServices().get(ServiceViewer.this.ids[i]).isAlive();
                        stat = isAlive ? Status.ALIVE : Status.NOT_ALIVE;
                    }
                    catch (Service.NotConnectedException ex) {
                        stat = Status.NOT_CONNECTED;
                    }
                    catch (Service.ServiceError ex) {
                        stat = Status.ERROR;
                    }
                    ServiceViewer.this.table.getModel().setValueAt((Object)stat, i, 2);
                }
                ServiceViewer.this.table.repaint();
            }
        });
    }

    ServiceManager getServiceManager() {
        return this.mgr;
    }

    protected void initGUI() {
        ServicesTableModel model = new ServicesTableModel();
        this.table = this.uif.createTable("serviceviewer", model);
        this.table.setModel(model);
        JScrollPane sp = this.uif.createScrollPane(this.table);
        Border b = BorderFactory.createEtchedBorder(0);
        sp.setBorder(b);
        this.btnStart = this.uif.createButton("serviceviewer.button.start");
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selected;
                for (int i : selected = ServiceViewer.this.table.getSelectedRows()) {
                    ServiceViewer.this.mgr.startService(ServiceViewer.this.ids[i]);
                }
            }
        });
        this.btnStop = this.uif.createButton("serviceviewer.button.stop");
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selected;
                for (int i : selected = ServiceViewer.this.table.getSelectedRows()) {
                    ServiceViewer.this.mgr.stopService(ServiceViewer.this.ids[i]);
                }
            }
        });
        JButton btnClose = this.uif.createButton("serviceviewer.button.close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceViewer.this.setVisible(false);
            }
        });
        this.setButtons(new JButton[]{this.btnStart, this.btnStop, btnClose}, btnClose);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        sp.setPreferredSize(new Dimension(600, 400));
        this.setBody(sp);
        this.setI18NTitle("serviceviewer.title");
    }

    public void currentQuestionChanged(Question q) {
    }

    public void pathUpdated() {
        ExecTool et = (ExecTool)this.parent;
        this.mgr.setParameters(et.getInterviewParameters());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        ALIVE("Running..."),
        NOT_ALIVE("Stopped"),
        NOT_CONNECTED("Not Connected"),
        ERROR("Error");

        private String str;

        private Status(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServicesTableModel
    extends DefaultTableModel {
        private String[] names = new String[]{"ID", "Description", "Status"};
        private Status[] stats = new Status[this.getRowCount()];

        public ServicesTableModel() {
            for (int i = 0; i < this.stats.length; ++i) {
                Status stat;
                try {
                    boolean isAlive = ServiceViewer.this.mgr.getAllServices().get(ServiceViewer.this.ids[i]).isAlive();
                    stat = isAlive ? Status.ALIVE : Status.NOT_ALIVE;
                }
                catch (Service.NotConnectedException ex) {
                    stat = Status.NOT_CONNECTED;
                }
                catch (Service.ServiceError ex) {
                    stat = Status.ERROR;
                }
                this.setValueAt((Object)stat, i, 2);
            }
        }

        @Override
        public int getRowCount() {
            if (ServiceViewer.this.ids != null) {
                return ServiceViewer.this.ids.length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.names[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ServiceViewer.this.ids[rowIndex];
                }
                case 1: {
                    return ServiceViewer.this.mgr.getAllServices().get(ServiceViewer.this.ids[rowIndex]).getDescription();
                }
                case 2: {
                    return this.stats[rowIndex];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.stats[rowIndex] = (Status)((Object)aValue);
        }
    }
}

