/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.FileSystemTableModel;
import com.sun.javatest.exec.FileTableNode;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FileTable
extends JTable {
    ArrayList<Resize> autoResizeColumns;
    private UIFactory uif;

    public FileTable(FileSystemTableModel model, UIFactory uif) {
        super(model);
        this.uif = uif;
        this.setCellSelectionEnabled(false);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setShowGrid(false);
        this.getColumnModel().getColumn(0).setCellRenderer(new IconRenderer());
        this.autoResizeColumns = new ArrayList();
        this.setAutoResizeMode(0);
        this.getColumnModel().getColumn(0).setMinWidth(130);
        this.getColumnModel().getColumn(2).setMinWidth(130);
        this.addAutoResizeColumn(2, true);
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                FileTable.this.updateWidth();
            }
        });
        this.updateWidth();
    }

    public boolean addAutoResizeColumn(int column, boolean keepSize) {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column " + column + " doesn't exist in the table");
        }
        for (Resize r : this.autoResizeColumns) {
            if (r.column != column) continue;
            return false;
        }
        this.autoResizeColumns.add(new Resize(column, keepSize));
        return true;
    }

    public boolean removeAutoResizeColumn(int column) {
        for (Resize r : this.autoResizeColumns) {
            if (r.column != column) continue;
            this.autoResizeColumns.remove(r);
            return true;
        }
        return false;
    }

    void updateWidth() {
        for (Resize r : this.autoResizeColumns) {
            this.updateWidth(r.column, r.keep);
        }
    }

    void updateWidth(int columnIndex, boolean keepWidth) {
        int width = 0;
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        if (keepWidth) {
            width = column.getWidth();
        }
        boolean modified = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object o = this.getValueAt(i, columnIndex);
            if (o == null) continue;
            String s = o.toString();
            int stringWidth = this.getFontMetrics(this.getFont()).stringWidth(s);
            if (stringWidth <= width) continue;
            width = stringWidth;
            modified = true;
        }
        if (modified) {
            width = (int)((double)width * 1.1);
        }
        column.setPreferredWidth(width);
    }

    private static class Resize {
        private int column;
        private boolean keep;

        public Resize(int column, boolean keepSize) {
            this.column = column;
            this.keep = keepSize;
        }
    }

    private class IconRenderer
    extends DefaultTableCellRenderer {
        private Icon up;
        private Icon dir;

        private IconRenderer() {
            this.up = FileTable.this.uif.createIcon("upper");
            this.dir = FileTable.this.uif.createIcon("folder");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileTableNode fn;
            this.setFont(table.getFont());
            this.setIcon(null);
            this.setText("");
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }
            if (value instanceof FileTableNode && (fn = (FileTableNode)value).getMode() != 'f') {
                if (fn.getMode() == 'u') {
                    this.setIcon(this.up);
                    return this;
                }
                if (fn.getMode() == 'd') {
                    this.setIcon(this.dir);
                    this.setText(fn.toString());
                    return this;
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

