/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.exec.TextPane;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

class ChecklistBrowser
extends ToolDialog {
    private static final String SAVE_AS = "SaveAs";
    private static final String PRINT_SETUP = "PrintSetup";
    private static final String PRINT = "Print";
    private ExecModel model;
    private InterviewParameters params;
    private MultiFormatPane body;
    private FileChooser fileChooser;
    private Listener listener;

    ChecklistBrowser(JComponent parent, ExecModel model, UIFactory uif) {
        super(parent, uif, "cb");
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        this.params = model.getInterviewParameters();
        if (this.params == null) {
            throw new NullPointerException();
        }
        this.listener = new Listener();
    }

    protected void initGUI() {
        this.setHelp("checklist.window.csh");
        JMenuBar mb = this.uif.createMenuBar("cb");
        String[] fileActions = new String[]{SAVE_AS, PRINT_SETUP, PRINT};
        JMenu fileMenu = this.uif.createMenu("cb.file", fileActions, this.listener);
        mb.add(fileMenu);
        this.setJMenuBar(mb);
        this.body = new MultiFormatPane(this.uif);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uif.setAccessibleName(this.body, "cb");
        this.uif.setToolTip(this.body, "cb");
        int dpi = this.uif.getDotsPerInch();
        this.body.setPreferredSize(new Dimension(6 * dpi, 8 * dpi));
        this.setBody(this.body);
        JButton helpBtn = this.uif.createHelpButton("cb.help", "checklist.window.csh");
        JButton closeBtn = this.uif.createCloseButton("cb.close");
        this.setButtons(new JButton[]{helpBtn, closeBtn}, closeBtn);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        File f;
        if (this.body == null) {
            this.initGUI();
        }
        if ((f = this.params.getFile()) == null) {
            this.setI18NTitle("cb.title");
        } else {
            this.setI18NTitle("cb.titleWithFile", f);
        }
        try {
            Checklist c = this.params.createChecklist();
            StringWriter out = new StringWriter();
            this.writeChecklist(c, out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeChecklist(Checklist c, Writer out) throws IOException {
        out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n");
        out.write("<html><body>\n");
        TestEnvironment env = this.params.getEnv();
        if (env != null) {
            out.write("<h1>");
            out.write(this.escape(this.uif.getI18NString("cb.html.title", env.getName())));
            out.write("</h1>\n");
        }
        if (c.isEmpty()) {
            out.write(this.escape(this.uif.getI18NString("cb.html.noEntries")));
        } else {
            out.write(this.escape(this.uif.getI18NString("cb.html.intro")));
            String[] names = c.getSectionNames();
            for (int i = 0; i < names.length; ++i) {
                this.writeSection(c, names[i], out);
            }
        }
        out.write("</body></html>");
        out.close();
        TextPane pane = (TextPane)this.body.getMediaPane(0);
        pane.showText(out.toString(), "text/html");
        pane.getCaret().setDot(0);
    }

    private void writeSection(Checklist c, String name, Writer out) throws IOException {
        out.write("<h2>");
        out.write(this.escape(name));
        out.write("</h2>\n");
        out.write("<ul>");
        String[] msgs = c.getSectionMessages(name);
        for (int i = 0; i < msgs.length; ++i) {
            out.write("<li>");
            out.write(this.escape(msgs[i]));
            out.write("\n");
        }
        out.write("</ul>\n");
    }

    private String escape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuffer sb = new StringBuffer(s.length() * 2);
                    block9: for (int j = 0; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        switch (c) {
                            case '<': {
                                sb.append("&lt;");
                                continue block9;
                            }
                            case '>': {
                                sb.append("&gt;");
                                continue block9;
                            }
                            case '&': {
                                sb.append("&amp;");
                                continue block9;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    return sb.toString();
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doSaveAs() {
        block31: {
            IOException e222;
            Writer out;
            FileWriter fw;
            File file;
            block29: {
                if (this.fileChooser == null) {
                    this.fileChooser = new FileChooser(true);
                    this.fileChooser.addChoosableExtension(".html", this.uif.getI18NString("cb.htmlFiles"));
                }
                this.fileChooser.setDialogTitle(this.uif.getI18NString("cb.save.title"));
                file = null;
                block16: while (file == null) {
                    String path;
                    int rc = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("cb.save.btn"));
                    if (rc != 0) {
                        return;
                    }
                    file = this.fileChooser.getSelectedFile();
                    if (!file.exists() && !(path = file.getPath()).endsWith(".html")) {
                        file = new File(path + ".html");
                    }
                    if (!file.exists()) continue;
                    rc = this.uif.showYesNoCancelDialog("cb.save.warn");
                    switch (rc) {
                        case 0: {
                            continue block16;
                        }
                        case 1: {
                            this.fileChooser.setSelectedFile(null);
                            file = null;
                            continue block16;
                        }
                    }
                    return;
                }
                fw = null;
                out = null;
                fw = new FileWriter(file);
                out = new BufferedWriter(fw);
                TextPane pane = (TextPane)this.body.getMediaPane(0);
                out.write(pane.getText());
                out.close();
                Object var6_7 = null;
                if (out == null) break block29;
                try {
                    out.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e222) {}
            }
            break block31;
            {
                catch (IOException e3) {
                    IOException e222;
                    if (!file.canWrite()) {
                        this.uif.showError("cb.save.cantWriteFile", file);
                    } else if (e3 instanceof FileNotFoundException) {
                        this.uif.showError("cb.save.cantFindFile", file);
                    } else {
                        this.uif.showError("cb.save.error", new Object[]{file, e3});
                    }
                    Object var6_8 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var6_9 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void doPrintSetup() {
        this.model.printSetup();
    }

    private void doPrint() {
        this.model.print(this.body);
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    Interview.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(ChecklistBrowser.SAVE_AS)) {
                ChecklistBrowser.this.doSaveAs();
            } else if (cmd.equals(ChecklistBrowser.PRINT_SETUP)) {
                ChecklistBrowser.this.doPrintSetup();
            } else if (cmd.equals(ChecklistBrowser.PRINT)) {
                ChecklistBrowser.this.doPrint();
            }
        }

        public void componentShown(ComponentEvent e) {
            ChecklistBrowser.this.params.addObserver(this);
            ChecklistBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent e) {
            ChecklistBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question q) {
        }

        public void pathUpdated() {
            ChecklistBrowser.this.updateContent();
        }
    }
}

