/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.MissingResourceException;

class AgentClassLoader2
extends ClassLoader {
    private CodeSource cs = null;
    private final HashMap<CodeSource, ProtectionDomain> pdcache = new HashMap(11);
    private static volatile AgentClassLoader2 instance = null;
    private Agent.Task parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentClassLoader2(Agent.Task parent) {
        super(parent.getClass().getClassLoader());
        ProtectionDomain pd;
        this.parent = parent;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        if ((pd = this.getClass().getProtectionDomain()) != null) {
            this.cs = this.getClass().getProtectionDomain().getCodeSource();
            HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
            synchronized (hashMap) {
                this.pdcache.put(this.cs, pd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource cs) {
        ProtectionDomain pd = null;
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
        synchronized (hashMap) {
            pd = this.pdcache.get(cs);
            if (pd == null) {
                Permissions perms = new Permissions();
                pd = new ProtectionDomain(cs, perms, this, null);
                this.pdcache.put(cs, pd);
            }
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AgentClassLoader2 getInstance(Agent.Task parent) {
        if (instance == null) {
            Class<AgentClassLoader2> clazz = AgentClassLoader2.class;
            // MONITORENTER : com.sun.javatest.agent.AgentClassLoader2.class
            if (instance == null) {
                instance = new AgentClassLoader2(parent);
            }
            // MONITOREXIT : clazz
        }
        AgentClassLoader2.instance.parent = parent;
        return instance;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        if (className != null) {
            String pkgName;
            int i = className.lastIndexOf(46);
            if (i > 0 && this.getPackage(pkgName = className.substring(0, i)) == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            byte[] data = this.parent.getClassData(className);
            return this.defineClass(className, data, 0, data.length, this.getProtectionDomain(this.cs));
        }
        throw new ClassNotFoundException();
    }

    protected URL findResource(String name) {
        URL u = null;
        if (this.parent == null || name == null) {
            return null;
        }
        try {
            byte[] bytes = this.parent.getResourceData(name);
            u = bytes == null ? null : new URL("file", "", -1, name, new AgentURLStreamHandler(bytes));
        }
        catch (MissingResourceException e) {
            u = null;
        }
        catch (IOException e) {
            u = null;
        }
        return u;
    }

    private class AgentURLConnection
    extends URLConnection {
        private byte[] bytes;

        AgentURLConnection(URL url) {
            super(url);
        }

        AgentURLConnection(URL url, byte[] bytes) {
            super(url);
            this.bytes = bytes;
        }

        public void connect() throws IOException {
            this.connected = this.bytes != null;
        }

        public InputStream getInputStream() throws IOException {
            if (AgentClassLoader2.this.parent == null) {
                throw new IOException("No parent agent to open connection with!");
            }
            if (this.bytes == null) {
                throw new IOException("No bytes available!!");
            }
            return new ByteArrayInputStream(this.bytes);
        }

        public String getContentEncoding() {
            return null;
        }

        public int getContentLength() {
            if (this.bytes != null) {
                return this.bytes.length;
            }
            return -1;
        }

        public String getContentType() {
            URL u;
            if (this.bytes == null) {
                return null;
            }
            String type = null;
            try {
                type = AgentURLConnection.guessContentTypeFromStream(this.getInputStream());
            }
            catch (Exception e) {
                type = null;
            }
            if (type == null && (u = this.getURL()) != null) {
                type = AgentURLConnection.guessContentTypeFromName(this.url.getPath());
            }
            return type;
        }

        public long getDate() {
            return 0L;
        }

        public long getExpiration() {
            return 0L;
        }

        public long getLastModified() {
            return 0L;
        }
    }

    private class AgentURLStreamHandler
    extends URLStreamHandler {
        private byte[] bytes;

        AgentURLStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL url) throws IOException {
            return new AgentURLConnection(url, this.bytes);
        }
    }
}

