/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveModeOptions;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.AgentPanel;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.Map;
import com.sun.javatest.agent.ModeOptions;
import com.sun.javatest.agent.PassiveModeOptions;
import com.sun.javatest.agent.SerialPortModeOptions;
import com.sun.javatest.util.MainAppletContext;
import com.sun.javatest.util.MainFrame;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;
import java.net.URL;

public class AgentApplet
extends Applet
implements Agent.Observer {
    private boolean shareAppletContext;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Observer;

    public void init() {
        String appletName;
        String mode = this.getParameter("mode", "active");
        URL docBase = this.getDocumentBase();
        String defaultActiveHost = docBase == null ? "localhost" : docBase.getHost();
        String activeHost = this.getParameter("activeHost", defaultActiveHost);
        int activePort = this.getIntParameter("activePort", 1907);
        int passivePort = this.getIntParameter("passivePort", 1908);
        String serialPort = this.getParameter("serialPort");
        int concurrency = this.getIntParameter("concurrency", 1);
        int history = this.getIntParameter("history", -1);
        int delay = this.getIntParameter("retryDelay", -1);
        String mapFile = this.getParameter("map");
        String usac = this.getParameter("useSharedAppletContext");
        this.shareAppletContext = usac != null && usac.equals("true");
        String usf = this.getParameter("useSharedFrame");
        boolean shareFrame = usf == null || usf.equals("true");
        final boolean tracing = "true".equals(this.getParameter("trace"));
        boolean autostart = "true".equals(this.getParameter("start"));
        String observerClassName = this.getParameter("observer");
        if (this.shareAppletContext) {
            appletName = this.getParameter("appletName");
            if (appletName == null) {
                String line1 = "Error: Applet parameter \"appletName\" must be defined";
                String line2 = "and match the applet's \"name\" attribute.";
                this.showStatus("Error starting Applet: Applet parameter \"appletName\" must be defined.");
                Panel p = new Panel(new GridLayout(0, 1));
                Label label1 = new Label(line1);
                Label label2 = new Label(line2);
                p.add(label1);
                p.add(label2);
                this.add(p);
                return;
            }
        } else {
            appletName = null;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        ActiveModeOptions amo = new ActiveModeOptions();
        if (activeHost != null) {
            amo.setHost(activeHost);
        }
        amo.setPort(activePort);
        PassiveModeOptions pmo = new PassiveModeOptions();
        pmo.setPort(passivePort);
        SerialPortModeOptions smo = new SerialPortModeOptions();
        if (serialPort != null) {
            smo.setPort(serialPort);
        }
        ModeOptions[] modeOptions = new ModeOptions[]{amo, pmo, smo};
        AgentPanel.MapReader mapReader = new AgentPanel.MapReader(){

            public Map read(String name) throws IOException {
                if (name == null || name.length() == 0) {
                    return null;
                }
                Map m = Map.readURL(new URL(AgentApplet.this.getDocumentBase(), name));
                m.setTracing(tracing, System.out);
                return m;
            }
        };
        AgentPanel ap = new AgentPanel(modeOptions, mapReader);
        if (observerClassName != null) {
            try {
                Class<?> observerClass = Class.forName(observerClassName);
                Agent.Observer observer = (Agent.Observer)observerClass.newInstance();
                ap.addObserver(observer);
            }
            catch (ClassCastException e) {
                this.showStatus("observer is not of type " + (class$com$sun$javatest$agent$Agent$Observer == null ? (class$com$sun$javatest$agent$Agent$Observer = AgentApplet.class$("com.sun.javatest.agent.Agent$Observer")) : class$com$sun$javatest$agent$Agent$Observer).getName() + ": " + observerClassName);
            }
            catch (ClassNotFoundException e) {
                this.showStatus("cannot find observer class: " + observerClassName);
            }
            catch (IllegalAccessException e) {
                this.showStatus("problem instantiating observer: " + e);
            }
            catch (InstantiationException e) {
                this.showStatus("problem instantiating observer: " + e);
            }
        }
        ap.setMode(mode);
        ap.setConcurrency(concurrency);
        ap.setTracing(tracing, System.out);
        if (mapFile != null) {
            ap.setMapFile(mapFile);
        }
        if (history != -1) {
            ap.setHistoryLimit(history);
        }
        if (delay != -1) {
            ap.setRetryDelay(delay);
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)ap, c);
        if (shareFrame) {
            try {
                Container x;
                for (x = this; x != null && !(x instanceof Frame); x = x.getParent()) {
                }
                if (x != null) {
                    MainFrame.setFrame((Frame)x);
                }
            }
            catch (SecurityException e) {
                System.err.println("Security Exception occurred while attempting to access shared frame; " + e);
            }
        }
        if (this.shareAppletContext) {
            AppletContext context = this.getAppletContext();
            MainAppletContext.setAppletContext(context);
            MainAppletContext.putApplet(appletName, this);
            MainAppletContext.setAgentApplet(this);
        }
        if (autostart) {
            ap.start();
        }
    }

    public void start() {
        if (this.shareAppletContext) {
            MainAppletContext.setStarted(true);
        }
        super.start();
    }

    public void destroy() {
        Component c = this.getComponent(0);
        if (c instanceof AgentPanel) {
            AgentPanel ap = (AgentPanel)c;
            ap.stop();
        }
    }

    public String getAppletInfo() {
        return "JT Harness Agent JTA_4.6 Copyright (c) 1996, 2014, Oracle and/or its affiliates. All rights reserved.";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"mode", "\"active\" or \"passive\"", "the mode for the agent"}, {"activeHost", "hostname", "the host for active connections"}, {"activePort", "port", "the port for active connections"}, {"passivePort", "port", "the port for passive connections"}, {"map", "url", "map file for translating arguments of incoming requests"}, {"concurrency", "number", "the maximum number of simultaneous connections"}, {"history", "int", "the size of the execution history"}, {"trace", "boolean", "trace the execution of the agent"}};
        return pinfo;
    }

    private int getIntParameter(String name, int dflt) {
        try {
            String s = this.getParameter(name);
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dflt;
    }

    private String getParameter(String name, String dflt) {
        String s = this.getParameter(name);
        return s == null ? dflt : s;
    }

    public void started(Agent sl) {
        this.showStatus("agent started");
    }

    public void errorOpeningConnection(Agent sl, Exception e) {
        this.showStatus("error opening connection: " + e.getMessage());
    }

    public void finished(Agent sl) {
        this.showStatus("agent stopped");
    }

    public synchronized void openedConnection(Agent sl, Connection c) {
        this.showStatus("OPENED SOCKET");
    }

    public synchronized void execTest(Agent sl, Connection c, String tag, String className, String[] args) {
        this.showStatus("EXEC");
    }

    public synchronized void execCommand(Agent sl, Connection c, String tag, String className, String[] args) {
        this.showStatus("EXEC");
    }

    public synchronized void execMain(Agent sl, Connection c, String tag, String className, String[] args) {
        this.showStatus("EXEC");
    }

    public synchronized void result(Agent sl, Connection c, Status r) {
        this.showStatus("RESULT");
    }

    public synchronized void exception(Agent sl, Connection c, Throwable t) {
        this.showStatus("EXCEPTION (NYI)");
    }

    public synchronized void completed(Agent sl, Connection c) {
        this.showStatus("COMPLETED (NYI)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

