/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class TestDescription
implements Serializable {
    private String rootDir;
    private String rootRelativePath;
    private String[] fields;
    private String rrurl;
    private static File cachedRoot;
    private static String cachedRootDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestDescription(File root, File file, Map params) throws IllegalArgumentException {
        String rootRelativeFile;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (root.equals(cachedRoot)) {
                this.rootDir = cachedRootDir;
            } else {
                this.rootDir = (root.exists() ? root.isFile() : root.getName().endsWith(".html")) ? root.getParent() : root.getPath();
                cachedRoot = root;
                cachedRootDir = this.rootDir;
            }
        }
        String fp = file.getPath();
        if (file.isAbsolute()) {
            String rp = this.rootDir;
            if (!fp.startsWith(rp) || fp.charAt(rp.length()) != File.separatorChar) {
                throw new IllegalArgumentException("file must be relative to root: " + file);
            }
            rootRelativeFile = fp.substring(rp.length() + 1);
        } else {
            rootRelativeFile = fp;
        }
        this.rootRelativePath = rootRelativeFile.replace(File.separatorChar, '/');
        Vector v = new Vector(0, params.size() * 2);
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            TestDescription.insert(v, key, value);
        }
        this.fields = new String[v.size()];
        v.copyInto(this.fields);
    }

    private TestDescription(String root, String file, String[] params) {
        this.rootDir = root;
        char sep = file.charAt(root.length());
        this.rootRelativePath = file.substring(root.length() + 1).replace(sep, '/');
        Vector v = new Vector(0, params.length);
        for (int i = 0; i < params.length; i += 2) {
            String key = params[i];
            if (key.startsWith("$") || key.equals("testsuite") || key.equals("file")) continue;
            String value = params[i + 1];
            TestDescription.insert(v, key, value);
        }
        this.fields = new String[v.size()];
        v.copyInto(this.fields);
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Arrays.deepHashCode(this.fields);
        return hash;
    }

    public boolean equals(Object td) {
        if (!(td instanceof TestDescription)) {
            return false;
        }
        TestDescription otherTd = (TestDescription)td;
        if (otherTd.getParameterCount() != this.getParameterCount()) {
            return false;
        }
        for (int pos = 0; pos < this.fields.length; pos += 2) {
            String otherVal = otherTd.getParameter(this.fields[pos]);
            if (otherVal != null && otherVal.equals(this.fields[pos + 1])) continue;
            return false;
        }
        return true;
    }

    public File getDir() {
        return new File(this.getFile().getParent());
    }

    public File getFile() {
        return new File(this.rootDir, this.rootRelativePath.replace('/', File.separatorChar));
    }

    public String getId() {
        return this.getParameter("id");
    }

    public String getTitle() {
        String title = this.getParameter("title");
        if (title == null) {
            title = this.getName();
        }
        return title;
    }

    public String getName() {
        String id;
        int lastSep = this.rootRelativePath.lastIndexOf(47);
        String name = lastSep == -1 ? this.rootRelativePath : this.rootRelativePath.substring(lastSep + 1);
        int dot = name.indexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        if ((id = this.getParameter("id")) != null) {
            name = name + "_" + id;
        }
        return name;
    }

    public String[] getKeywords() {
        return StringArray.split(this.getParameter("keywords"));
    }

    public Set getKeywordTable() {
        String[] keys = StringArray.split(this.getParameter("keywords"));
        TreeSet<String> s = new TreeSet<String>();
        for (int i = 0; i < keys.length; ++i) {
            String k = keys[i].toLowerCase();
            s.add(k);
        }
        return s;
    }

    public String[] getSources() {
        return StringArray.split(this.getParameter("source"));
    }

    public File[] getSourceFiles() {
        String dir = this.getFile().getParent();
        String[] srcs = this.getSources();
        File[] sourceFiles = new File[srcs.length];
        String userCurrDir = System.getProperty("user.dir") + File.separator;
        for (int i = 0; i < srcs.length; ++i) {
            File f = new File(dir, srcs[i].replace('/', File.separatorChar));
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            String s = f.getPath();
            if (s.startsWith(userCurrDir)) {
                s = s.substring(userCurrDir.length());
                sourceFiles[i] = new File(s);
                continue;
            }
            sourceFiles[i] = f;
        }
        return sourceFiles;
    }

    public URL[] getSourceURLs() {
        ArrayList<File> res = new ArrayList<File>();
        res.add(this.getFile());
        res.addAll(Arrays.asList(this.getSourceFiles()));
        URL[] urls = new URL[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            try {
                urls[i] = ((File)res.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                urls[i] = null;
            }
        }
        return urls;
    }

    public String getClassDir() {
        return this.getParameter("classDir");
    }

    public String getExecuteClass() {
        return this.getParameter("executeClass");
    }

    public String getExecuteArgs() {
        return this.getParameter("executeArgs");
    }

    public int getTimeout() {
        String t = this.getParameter("timeout");
        if (t == null) {
            return 0;
        }
        return Integer.parseInt(t);
    }

    public File getRoot() {
        return new File(this.rootDir, "testsuite.html");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getRootRelativePath() {
        return this.rootRelativePath;
    }

    public File getRootRelativeFile() {
        return new File(this.rootRelativePath.replace('/', File.separatorChar));
    }

    public String getRootRelativeURL() {
        if (this.rrurl == null) {
            String id = this.getParameter("id");
            this.rrurl = id == null ? this.rootRelativePath : this.rootRelativePath + "#" + id;
            this.rrurl = this.rrurl.intern();
        }
        return this.rrurl;
    }

    public File getRootRelativeDir() {
        String p = this.getRootRelativeFile().getParent();
        return p == null ? new File(".") : new File(p);
    }

    public int getParameterCount() {
        return this.fields.length / 2;
    }

    public Iterator getParameterKeys() {
        return new Iterator(){
            int pos = 0;

            public boolean hasNext() {
                return TestDescription.this.fields != null && TestDescription.this.fields.length != 0 && this.pos < TestDescription.this.fields.length;
            }

            public Object next() {
                if (TestDescription.this.fields == null || TestDescription.this.fields.length == 0 || this.pos == TestDescription.this.fields.length) {
                    return null;
                }
                String current = TestDescription.this.fields[this.pos];
                this.pos += 2;
                return current;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getParameter(String key) {
        int lower = 0;
        int upper = this.fields.length - 2;
        if (upper < 0) {
            return null;
        }
        String last = this.fields[upper];
        int cmp = key.compareTo(last);
        if (cmp > 0) {
            return null;
        }
        while (lower <= upper) {
            int mid = lower + (upper - lower) / 4 * 2;
            String e = this.fields[mid];
            cmp = key.compareTo(e);
            if (cmp < 0) {
                upper = mid - 2;
                continue;
            }
            if (cmp > 0) {
                lower = mid + 2;
                continue;
            }
            return this.fields[mid + 1];
        }
        return null;
    }

    public String toString() {
        return "TestDescription[" + this.getTitle() + "]";
    }

    void save(Map p) {
        this.saveField(p, "$root", this.rootDir);
        this.saveField(p, "$file", this.getFile().getPath());
        for (int i = 0; i < this.fields.length; i += 2) {
            this.saveField(p, this.fields[i], this.fields[i + 1]);
        }
    }

    private void saveField(Map p, String key, String value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    static TestDescription load(String[] params) {
        String f;
        String r = PropertyArray.get(params, "$root");
        if (r == null) {
            r = PropertyArray.get(params, "testsuite");
        }
        if ((f = PropertyArray.get(params, "$file")) == null) {
            f = PropertyArray.get(params, "file");
        }
        return new TestDescription(r, f, params);
    }

    private static void insert(Vector v, String key, String value) {
        int lower = 0;
        int upper = v.size() - 2;
        int mid = 0;
        if (upper < 0) {
            v.addElement(key);
            v.addElement(value);
            return;
        }
        String last = (String)v.elementAt(upper);
        int cmp = key.compareTo(last);
        if (cmp > 0) {
            v.addElement(key);
            v.addElement(value);
            return;
        }
        while (lower <= upper) {
            mid = lower + (upper - lower) / 4 * 2;
            String e = (String)v.elementAt(mid);
            cmp = key.compareTo(e);
            if (cmp < 0) {
                upper = mid - 2;
                continue;
            }
            if (cmp > 0) {
                lower = mid + 2;
                continue;
            }
            throw new Error("should not happen");
        }
        if (cmp > 0) {
            mid += 2;
        }
        v.insertElementAt(key, mid);
        v.insertElementAt(value, mid + 1);
    }
}

