/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class EditLinks {
    private File[] inFiles = new File[0];
    private File outFile;
    private String[][] edits = new String[0][];
    private Set ignores = new HashSet();
    private int c;
    private int line;
    private File currFile;
    private Reader in;
    private Writer out;
    private boolean copying;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(EditLinks.class);

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                EditLinks.usage(System.err);
            } else {
                EditLinks el = new EditLinks(args);
                if (el.edits.length == 0) {
                    System.err.println(i18n.getString("editLinks.noEdits"));
                }
                el.run();
            }
        }
        catch (BadArgs e) {
            System.err.println(e.getMessage());
            EditLinks.usage(System.err);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
    }

    private static void usage(PrintStream out) {
        int i;
        String program = System.getProperty("program", "java " + EditLinks.class.getName());
        String msg = i18n.getString("editLinks.usage", program);
        int start = 0;
        while ((i = msg.indexOf("\n", start)) != -1) {
            System.err.println(msg.substring(start, i));
            start = i + 1;
        }
        if (start < msg.length()) {
            System.err.println(msg.substring(start));
        }
    }

    public EditLinks() {
    }

    public EditLinks(String[] args) throws BadArgs {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-e") && i + 2 < args.length) {
                String oldPrefix = args[++i];
                String newPrefix = args[++i];
                this.addEdit(oldPrefix, newPrefix);
                continue;
            }
            if (args[i].equals("-ignore") && i + 2 < args.length) {
                this.ignore(args[++i]);
                continue;
            }
            if (args[i].equals("-o") && i + 1 < args.length) {
                this.outFile = new File(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new BadArgs(i18n, "editLinks.badOpt", args[i]);
            }
            this.inFiles = new File[args.length - i];
            for (int j = 0; j < this.inFiles.length; ++j) {
                this.inFiles[j] = new File(args[i++]);
            }
        }
        if (this.inFiles == null || this.inFiles.length == 0) {
            throw new BadArgs(i18n, "editLinks.noInput");
        }
        if (this.outFile == null) {
            if (this.inFiles.length == 1) {
                this.outFile = this.inFiles[0];
            } else {
                throw new BadArgs(i18n, "editLinks.noOutput");
            }
        }
    }

    public void addEdit(String oldPrefix, String newPrefix) {
        String[][] newEdits = new String[this.edits.length + 1][];
        System.arraycopy(this.edits, 0, newEdits, 0, this.edits.length);
        newEdits[this.edits.length] = new String[]{oldPrefix, newPrefix};
        this.edits = newEdits;
    }

    public void ignore(String file) {
        this.ignores.add(file);
    }

    public void run() throws IOException {
        this.edit(this.inFiles, this.outFile);
    }

    public void edit(File[] src, File dest) throws IOException {
        for (int i = 0; i < src.length; ++i) {
            this.edit(src[i], dest);
        }
    }

    public void edit(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.getPath());
        }
        if (src.isDirectory()) {
            if (!dest.exists()) {
                if (!dest.mkdir()) {
                    throw new FileNotFoundException(dest.getPath());
                }
            } else if (!dest.isDirectory()) {
                throw new IllegalArgumentException(i18n.getString("editLinks.dirExpected", dest));
            }
            File canonicalDest = dest.getCanonicalFile();
            this.ignores.add(canonicalDest);
            String[] files = src.list();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    if (this.ignores.contains(file) || this.ignores.contains(srcFile.getCanonicalFile())) continue;
                    this.edit(srcFile, destFile);
                }
            }
            this.ignores.remove(canonicalDest);
        } else {
            if (dest.exists() && dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (src.getName().endsWith(".html")) {
                this.in = new BufferedReader(new FileReader(src));
                if (dest.equals(src)) {
                    int size = (int)src.length();
                    char[] data = new char[size];
                    for (int total = 0; total < data.length; total += this.in.read(data, total, data.length - total)) {
                    }
                    this.in.close();
                    String s = new String(data, 0, data.length);
                    this.in = new StringReader(s);
                }
                this.out = new BufferedWriter(new FileWriter(dest));
                this.currFile = src;
                this.line = 1;
                this.edit(this.in, this.out);
                this.in.close();
                this.out.close();
            } else {
                this.copyFile(src, dest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, File to) throws IOException {
        if (from.equals(to)) {
            return;
        }
        int size = (int)from.length();
        byte[] data = new byte[size];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        try {
            for (int total = 0; total < data.length; total += ((InputStream)in).read(data, total, data.length - total)) {
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
        try {
            ((OutputStream)out).write(data, 0, data.length);
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    private void edit(Reader in, Writer out) throws IOException {
        this.copying = false;
        this.nextCh();
        this.copying = true;
        block4: while (this.c >= 0) {
            if (this.c == 60) {
                this.nextCh();
                this.skipSpace();
                switch (this.c) {
                    case 33: {
                        this.nextCh();
                        if (this.c != 45) continue block4;
                        this.nextCh();
                        if (this.c != 45) continue block4;
                        this.nextCh();
                        this.skipComment();
                        continue block4;
                    }
                    case 47: {
                        this.nextCh();
                        this.scanIdentifier();
                        this.skipTag();
                        continue block4;
                    }
                }
                String tag = this.scanIdentifier();
                if (tag.equals("a")) {
                    this.scanLink();
                    continue;
                }
                this.skipTag();
                continue;
            }
            this.nextCh();
        }
    }

    private void scanLink() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            if (att.equalsIgnoreCase("href")) {
                this.out.write(61);
                this.copying = false;
                String target = this.scanValue();
                this.out.write(34);
                this.out.write(this.edit(target));
                this.out.write(34);
                this.copying = true;
            } else {
                this.scanValue();
            }
            this.skipSpace();
        }
        this.nextCh();
    }

    private String scanIdentifier() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            if (this.c >= 97 && this.c <= 122) {
                buf.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c >= 65 && this.c <= 90) {
                buf.append((char)(97 + (this.c - 65)));
                this.nextCh();
                continue;
            }
            if (this.c >= 48 && this.c <= 57) {
                buf.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c != 45) break;
            buf.append((char)this.c);
            this.nextCh();
        }
        if (buf.length() == 0) {
            throw new IOException(i18n.getString("editLinks.idExpected", new Object[]{this.currFile, new Integer(this.line)}));
        }
        return buf.toString();
    }

    private String scanValue() throws IOException {
        this.skipSpace();
        if (this.c != 61) {
            return "";
        }
        int quote = -1;
        this.nextCh();
        this.skipSpace();
        if (this.c == 39 || this.c == 34) {
            quote = this.c;
            this.nextCh();
            this.skipSpace();
        }
        StringBuffer buf = new StringBuffer();
        while (quote < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || quote >= 0 && this.c != quote) {
            if (this.c == -1 || this.c == 10 || this.c == 13) {
                throw new IOException(i18n.getString("editLinks.mismatchQuotes", new Object[]{this.currFile, new Integer(this.line)}));
            }
            buf.append((char)this.c);
            this.nextCh();
        }
        if (this.c == quote) {
            this.nextCh();
        }
        this.skipSpace();
        return buf.toString();
    }

    private void skipComment() throws IOException {
        int numHyphens = 0;
        while (this.c != -1 && (numHyphens < 2 || this.c != 62)) {
            numHyphens = this.c == 45 ? ++numHyphens : 0;
            this.nextCh();
        }
        this.nextCh();
    }

    private void skipSpace() throws IOException {
        while (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13) {
            this.nextCh();
        }
    }

    private void skipTag() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String att = this.scanIdentifier();
            if (att == "") {
                throw new IOException(i18n.getString("editLinks.badHTML", new Object[]{this.currFile, new Integer(this.line)}));
            }
            String value = this.scanValue();
            this.skipSpace();
        }
        this.nextCh();
    }

    private void nextCh() throws IOException {
        if (this.copying) {
            this.out.write((char)this.c);
        }
        this.c = this.in.read();
        if (this.c == 10) {
            ++this.line;
        }
    }

    private String edit(String ref) {
        for (int i = 0; i < this.edits.length; ++i) {
            String[] entry = this.edits[i];
            if (!ref.startsWith(entry[0])) continue;
            String oldHead = entry[0];
            String newHead = entry[1];
            char oldSep = EditLinks.guessSep(oldHead);
            char newSep = EditLinks.guessSep(newHead);
            String oldTail = ref.substring(oldHead.length());
            String newTail = oldSep != '\u0000' && newSep != '\u0000' && oldSep != newSep ? oldTail.replace(oldSep, newSep) : oldTail;
            return newHead + newTail;
        }
        return ref;
    }

    private static char guessSep(String path) {
        int back;
        int fwd = path.lastIndexOf(47);
        if (fwd > (back = path.lastIndexOf(92))) {
            return '/';
        }
        if (back > fwd) {
            return '\\';
        }
        return '\u0000';
    }

    public static class BadArgs
    extends Exception {
        BadArgs(I18NResourceBundle i18n, String key) {
            super(i18n.getString(key));
        }

        BadArgs(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n.getString(key, arg));
        }
    }
}

