/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.HelpSetFactory;
import com.sun.interview.Interview;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;

public class JavaHelpFactory
implements HelpSetFactory {
    private static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");

    public Object createHelpSetObject(String name, Class c) throws Interview.Fault {
        try {
            String hsn;
            ClassLoader cl = c.getClassLoader();
            if (name.startsWith("/")) {
                hsn = name.substring(1);
            } else {
                String cn = c.getName();
                String pn = cn.substring(0, cn.lastIndexOf(46));
                hsn = pn.replace('.', '/') + "/" + name;
            }
            URL u = HelpSet.findHelpSet(cl, hsn);
            if (u == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", hsn);
            }
            return new HelpSet(cl, u);
        }
        catch (HelpSetException e) {
            throw new BadHelpFault(i18n, "interview.badHelp", e);
        }
    }

    public Object createHelpSetObject(String name, File file) throws Interview.Fault {
        try {
            URL[] urls = new URL[]{new URL("file:" + file.getAbsolutePath() + "/")};
            URLClassLoader cl = new URLClassLoader(urls);
            URL url = HelpSet.findHelpSet(cl, name);
            if (url == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
            }
            HelpSet helpset = new HelpSet(cl, url);
            return helpset;
        }
        catch (HelpSetException helpsetexception) {
            throw new BadHelpFault(i18n, "interview.badHelp", helpsetexception);
        }
        catch (MalformedURLException e) {
            throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
        }
    }

    public Object createHelpID(Object hsObject, String target) {
        HelpSet hs;
        Map m;
        if (hsObject != null && (m = (hs = (HelpSet)hsObject).getCombinedMap()).isValidID(target, hs)) {
            return Map.ID.create(target, hs);
        }
        return null;
    }

    public Object updateHelpSetObject(Interview interview, Object object) {
        HelpSet newHelpSet = (HelpSet)object;
        HelpSet oldHelpSet = (HelpSet)interview.getHelpSet();
        if (interview.getParent() == null) {
            if (oldHelpSet == null) {
                for (Interview i : interview.getInterviews()) {
                    HelpSet ihs = (HelpSet)i.getHelpSet();
                    if (ihs == null) continue;
                    newHelpSet.add(ihs);
                }
            } else {
                ArrayList<HelpSet> helpSetsToRemove = new ArrayList<HelpSet>();
                Enumeration e = oldHelpSet.getHelpSets();
                while (e.hasMoreElements()) {
                    HelpSet entry = (HelpSet)e.nextElement();
                    helpSetsToRemove.add(entry);
                    newHelpSet.add(entry);
                }
                for (HelpSet helpToRemove : helpSetsToRemove) {
                    oldHelpSet.remove(helpToRemove);
                }
            }
        } else {
            Interview i = interview;
            while (i.getParent() != null) {
                i = i.getParent();
            }
            HelpSet rootHelpSet = (HelpSet)i.getHelpSet();
            if (rootHelpSet != null) {
                if (oldHelpSet != null) {
                    rootHelpSet.remove(oldHelpSet);
                }
                rootHelpSet.add(newHelpSet);
            }
        }
        return newHelpSet;
    }

    public static class BadHelpFault
    extends Interview.Fault {
        public final HelpSetException exc;

        BadHelpFault(ResourceBundle i18n, String s, HelpSetException e) {
            super(i18n, s, e.getMessage());
            this.exc = e;
        }
    }

    public static class HelpNotFoundFault
    extends Interview.Fault {
        public final String name;

        HelpNotFoundFault(ResourceBundle i18n, String s, String name) {
            super(i18n, s, name);
            this.name = name;
        }
    }
}

