/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.TestSuite;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;

public class Help {
    static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");

    public static HelpSet getHelpSet(Interview i) {
        if (i == null) {
            return null;
        }
        return (HelpSet)i.getHelpSet();
    }

    public static Map.ID getHelpID(Question q) {
        if (q == null) {
            return null;
        }
        Object id = q.getHelpID();
        if (id != null && id instanceof Map.ID) {
            return (Map.ID)id;
        }
        Map.ID helpID = Help.getID(q.getInterview(), q.getKey());
        if (helpID != null) {
            q.setHelpID(helpID);
        }
        return helpID;
    }

    private static Map.ID getID(Interview i, String key) {
        Map m;
        Map.ID id = null;
        if (i.getParent() != null) {
            id = Help.getID(i.getParent(), key);
        }
        if (id != null) {
            return id;
        }
        HelpSet hs = Help.getHelpSet(i);
        if (hs != null && (m = hs.getLocalMap()) != null && m.isValidID(key, hs)) {
            id = Map.ID.create(key, hs);
            return id;
        }
        return null;
    }

    public static HelpSet[] getAdditionalDocs(TestSuite ts) throws Fault {
        HelpSet[] additionalDocs = null;
        String[] names = ts.getAdditionalDocNames();
        if (names == null) {
            additionalDocs = new HelpSet[]{};
        } else {
            HelpSet[] docs = new HelpSet[names.length];
            ClassLoader loader = ts.getClassLoader();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                URL u = HelpSet.findHelpSet(loader, name);
                if (u == null) {
                    throw new Fault(i18n, "ts.cantFindDoc", name);
                }
                try {
                    docs[i] = new HelpSet(loader, u);
                    continue;
                }
                catch (HelpSetException e) {
                    throw new Fault(i18n, "ts.cantOpenDoc", new Object[]{name, e});
                }
            }
            additionalDocs = docs;
        }
        return additionalDocs;
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        public Fault(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

