/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TT_TreeNode;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.StringArray;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TestTreeModel
implements TreeModel,
TestResultTable.TreeObserver {
    private TT_BasicNode root;
    private UIFactory uif;
    private TestResultTable trt;
    private Parameters params;
    private FilterSelectionHandler filterHandler;
    private TestFilter lastFilter;
    private Comparator sortComparator;
    private TreeModelListener[] treeModelListeners = new TreeModelListener[0];
    private boolean statsForwarded;
    private boolean disposed;
    private CacheWorker cacheWorker;
    private FilterWatcher watcher;
    private Set<TT_TreeNode> relevantNodes;
    private Set<TestResult> relevantTests;
    private Logger log;
    protected Hashtable<TestResultTable.TreeNode, TT_NodeCache> cache;
    protected LinkedList<TT_NodeCache> cacheQueue;
    protected LinkedList<TT_NodeCache> suspendedQueue;
    protected final Object htLock = new Object();
    private static final int CACHE_THREAD_PRI = 1;
    private static final int CACHE_NOTI_THR_PRI = 1;
    protected static int debug = Debug.getInt(TestTreeModel.class);

    TestTreeModel() {
    }

    TestTreeModel(Parameters p, FilterSelectionHandler filterHandler, UIFactory uif) {
        this.filterHandler = filterHandler;
        this.uif = uif;
        this.cache = new Hashtable();
        this.cacheQueue = new LinkedList();
        this.suspendedQueue = new LinkedList();
        this.cacheWorker = new CacheWorker();
        this.cacheWorker.setPriority(2);
        this.cacheWorker.start();
        this.setParameters(p);
        this.watcher = new FilterWatcher();
        filterHandler.addObserver(this.watcher);
        this.lastFilter = filterHandler.getActiveFilter();
    }

    synchronized void dispose() {
        this.disposed = true;
        if (this.trt != null) {
            this.trt.removeObserver(this);
            this.trt.dispose();
            this.trt = null;
        }
        this.filterHandler.removeObserver(this.watcher);
        if (this.cacheWorker != null) {
            this.cacheWorker.interrupt();
            this.cacheWorker = null;
        }
        this.params = null;
    }

    TestFilter getTestFilter() {
        return this.filterHandler.getActiveFilter();
    }

    Parameters getParameters() {
        return this.params;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners = (TreeModelListener[])DynamicArray.append(this.treeModelListeners, l);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof TT_BasicNode) {
            return ((TT_BasicNode)parent).getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildCount();
        }
        return -1;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof TT_BasicNode) {
            return ((TT_BasicNode)parent).getIndex((TT_TreeNode)child);
        }
        return -1;
    }

    public Object getRoot() {
        if (this.disposed) {
            if (debug > 0) {
                Debug.println("TTM - getRoot() ignored, model has been disposed.");
            }
            return null;
        }
        if (this.root == null) {
            this.root = new TT_BasicNode(null, (TRT_TreeNode)this.trt.getRoot(), this.trt.getTestFinder().getComparator());
        }
        return this.root;
    }

    public boolean isLeaf(Object node) {
        if (node == null) {
            return true;
        }
        if (node instanceof TT_BasicNode) {
            return false;
        }
        if (node instanceof TT_TestNode) {
            return true;
        }
        throw new IllegalArgumentException(this.uif.getI18NString("tree.badType"));
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners = (TreeModelListener[])DynamicArray.remove((Object[])this.treeModelListeners, l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.err.println(this.getClass().getName() + ": VFPC");
    }

    public void nodeInserted(final TestResultTable.TreeNode[] path, final Object what, final int index) {
        if (!EventQueue.isDispatchThread()) {
            Runnable t = new Runnable(){

                public void run() {
                    TestTreeModel.this.nodeInserted0(path, what, index);
                }
            };
            EventQueue.invokeLater(t);
        } else {
            this.nodeInserted0(path, what, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void nodeInserted0(TestResultTable.TreeNode[] path, Object what, int index) {
        if (this.disposed) {
            return;
        }
        Object[] nodes = new Object[]{what};
        Object[] transPath = this.translatePath(path, true);
        if (transPath == null) {
            return;
        }
        if (what instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)what;
            int[] newPositions = transPath[transPath.length - 1].addNodes(new TestResultTable.TreeNode[]{tn});
            if (debug > 0) {
                Debug.println("TTM - Node " + what + " inserting, path len=" + path.length);
            }
            TreeModelEvent tme = path == null || path.length == 0 ? new TreeModelEvent((Object)this, new TreePath(this.getRoot())) : new TreeModelEvent((Object)this, transPath, newPositions, nodes);
            this.notifyModelListeners(tme, 2);
        } else {
            TestResult tr = (TestResult)what;
            if (transPath != null) {
                if (debug > 0) {
                    Debug.println("TTM - Node " + what + " inserted, path len=" + path.length);
                    Debug.println("   -> inserting " + tr.getTestName());
                    Debug.println("   -> mutable " + tr.isMutable());
                    Debug.println("   -> status " + tr.getStatus().getType());
                    Debug.println("   -> Thread: " + Thread.currentThread());
                }
                this.processInsert((TT_BasicNode[])transPath, tr);
            }
            for (int i = transPath.length - 1; i >= 0; --i) {
                TT_NodeCache ni = null;
                Object object = this.htLock;
                synchronized (object) {
                    ni = this.cache.get(transPath[i].getTableNode());
                }
                if (ni == null) continue;
                boolean result = false;
                TestResultTable.TreeNode treeNode = ni.getNode();
                synchronized (treeNode) {
                    result = ni.add(path, (TestResult)what, index);
                }
                if (!result && !this.relevantNodes.contains(transPath[i])) continue;
                TreeModelEvent tme = ((TT_BasicNode)transPath[i]).isRoot() ? new TreeModelEvent((Object)this, new TreePath(transPath[i])) : this.makeEvent(TestResultTable.getObjectPath(path[i - 1]), path[i], path[i - 1].getIndex(path[i]));
                if (this.cacheWorker == null || this.cacheWorker.isPaused()) continue;
                this.notifyModelListeners(tme, 0);
            }
        }
    }

    public void nodeChanged(final TestResultTable.TreeNode[] path, final Object what, final int index, final Object old) {
        if (!EventQueue.isDispatchThread()) {
            Runnable t = new Runnable(){

                public void run() {
                    TestTreeModel.this.nodeChanged0(path, what, index, old);
                }
            };
            EventQueue.invokeLater(t);
        } else {
            this.nodeChanged0(path, what, index, old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void nodeChanged0(TestResultTable.TreeNode[] path, Object what, int index, Object old) {
        if (this.disposed) {
            return;
        }
        if (what instanceof TestResultTable.TreeNode) {
            if (this.relevantNodes.contains(path[path.length - 1])) {
                this.notifyModelListeners(this.makeEvent(path, what, index), 0);
                this.notifyModelListeners(new TreeModelEvent((Object)this, path, null, null), 1);
            }
        } else {
            TreeModelEvent where;
            TT_BasicNode[] transPath;
            if (this.relevantTests.contains(old) && old != what) {
                this.relevantTests.remove(old);
                this.relevantTests.add((TestResult)what);
            }
            if ((transPath = this.translatePath(path, false)) != null && (where = transPath[transPath.length - 1].replaceTest((TestResult)what, false)) == null && debug > 0) {
                Debug.println("No test insertion pt for " + ((TestResult)what).getTestName());
            }
            for (int i = path.length - 1; i >= 0; --i) {
                TT_NodeCache ni = null;
                Object object = this.htLock;
                synchronized (object) {
                    ni = this.cache.get(path[i]);
                }
                if (ni == null) continue;
                boolean result = ni.replace(path, (TestResult)what, index, (TestResult)old);
            }
        }
    }

    public void nodeRemoved(final TestResultTable.TreeNode[] path, final Object what, final int index) {
        if (!EventQueue.isDispatchThread()) {
            Runnable t = new Runnable(){

                public void run() {
                    TestTreeModel.this.nodeRemoved0(path, what, index);
                }
            };
            EventQueue.invokeLater(t);
        } else {
            this.nodeRemoved0(path, what, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void nodeRemoved0(TestResultTable.TreeNode[] path, Object what, int index) {
        if (this.disposed) {
            return;
        }
        if (what instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode node;
            TT_TreeNode tn;
            Object[] transPath;
            int where;
            if (debug > 0) {
                Debug.println("TTM - Node " + what + " removed, path len=" + path.length);
            }
            if ((where = (transPath = this.translatePath(path, false))[transPath.length - 1].removeNode(tn = transPath[transPath.length - 1].findByName((node = (TestResultTable.TreeNode)what).getName()))) >= 0) {
                TreeModelEvent tme = new TreeModelEvent((Object)this, transPath, new int[]{where}, new Object[]{tn});
                this.notifyModelListeners(tme, 3);
            }
        } else {
            TestResult tr = (TestResult)what;
            TT_BasicNode[] transPath = this.translatePath(path, false);
            this.relevantTests.remove(tr);
            if (debug > 0) {
                Debug.println("TTM - Node " + what + " removed, path len=" + path.length);
                Debug.println("    -> Removing " + tr.getTestName());
                Debug.println("    -> Thread: " + Thread.currentThread());
            }
            this.processRemove(transPath, tr, index);
            for (int i = path.length - 1; i >= 0; --i) {
                TT_NodeCache ni = null;
                Object tme = this.htLock;
                synchronized (tme) {
                    ni = this.cache.get(path[i]);
                }
                if (ni == null) continue;
                boolean result = false;
                TestResultTable.TreeNode treeNode = ni.getNode();
                synchronized (treeNode) {
                    result = ni.remove(path, (TestResult)what, index);
                    continue;
                }
            }
        }
    }

    private void processRemove(final TT_BasicNode[] path, final TestResult tr, final int index) {
        if (!EventQueue.isDispatchThread()) {
            Runnable t = new Runnable(){

                public void run() {
                    TestTreeModel.this.processRemove0(path, tr, index);
                }
            };
            EventQueue.invokeLater(t);
        } else {
            this.processRemove0(path, tr, index);
        }
    }

    private void processRemove0(TT_BasicNode[] path, TestResult tr, int index) {
        TreeModelEvent tme = path[path.length - 1].removeTest(tr);
        if (tme == null) {
            return;
        }
        for (int i = 0; i < this.treeModelListeners.length; ++i) {
            this.treeModelListeners[i].treeNodesRemoved(tme);
        }
    }

    private void processInsert(final TT_BasicNode[] path, final TestResult tr) {
        if (!EventQueue.isDispatchThread()) {
            Runnable t = new Runnable(){

                public void run() {
                    TestTreeModel.this.processInsert0(path, tr);
                }
            };
            EventQueue.invokeLater(t);
        } else {
            this.processInsert0(path, tr);
        }
    }

    private void processInsert0(TT_BasicNode[] path, TestResult tr) {
        TT_TestNode newNode = new TT_TestNode(path[path.length - 1], tr);
        TreeModelEvent tme = path[path.length - 1].addTest(newNode, this.sortComparator);
        if (tme == null) {
            return;
        }
        for (int i = 0; i < this.treeModelListeners.length; ++i) {
            this.treeModelListeners[i].treeNodesInserted(tme);
        }
    }

    TreePath resolveUrl(String path) {
        if (path == null || path.length() == 0 || this.root == null) {
            return null;
        }
        ArrayList<TT_TreeNode> al = new ArrayList<TT_TreeNode>();
        al.add(this.root);
        TT_BasicNode spot = this.root;
        StringBuffer sb = new StringBuffer(path);
        while (sb.length() > 0) {
            int slash = sb.indexOf("/");
            String current = null;
            if (slash < 0) {
                current = sb.toString();
                sb.setLength(0);
            } else {
                current = sb.substring(0, slash);
                sb = sb.delete(0, slash + 1);
            }
            TT_TreeNode node = spot.findByName(current);
            if (node == null) {
                return null;
            }
            if (node instanceof TT_BasicNode) {
                al.add(node);
                spot = (TT_BasicNode)node;
                continue;
            }
            if (!(node instanceof TT_TestNode)) continue;
            al.add(node);
            sb.setLength(0);
        }
        return new TreePath(al.toArray());
    }

    void addRelevantNode(TT_TreeNode node) {
        this.relevantNodes.add(node);
    }

    void removeRelevantNode(TT_TreeNode node) {
        this.relevantNodes.remove(node);
    }

    void addRelevantTest(TestResult tr) {
        this.relevantTests.add(tr);
    }

    void removeRelevantTest(TestResult tr) {
        if (this.relevantTests != null && tr != null) {
            this.relevantTests.remove(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveNode(TT_BasicNode node) {
        TT_NodeCache ni = null;
        Object object = this.htLock;
        synchronized (object) {
            ni = this.cache.get(node.getTableNode());
        }
        if (ni != null) {
            this.cacheWorker.requestActiveNode(ni);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeModelEvent makeEvent(TestResultTable.TreeNode[] path, Object target, int index) {
        if (this.getRoot() == null) {
            return null;
        }
        int[] inds = new int[]{index};
        Object[] transPath = this.translatePath(path, false);
        Object[] transTarget = new TT_TreeNode[1];
        if (target instanceof TestResult && transPath[transPath.length - 1] instanceof TT_BasicNode) {
            TT_TestNode mtn = transPath[transPath.length - 1].findByName((TestResult)target);
            if (mtn == null) return null;
            transTarget[0] = mtn;
        } else {
            TT_TreeNode mtn = transPath[transPath.length - 1].findByName(((TestResultTable.TreeNode)target).getName());
            if (mtn == null) return null;
            transTarget[0] = mtn;
        }
        if (debug <= 1) return new TreeModelEvent((Object)this, transPath, inds, transTarget);
        Debug.println("TTM Broadcasing " + target + " change message...");
        Debug.println("   -> Path len=" + transPath.length);
        Debug.println("   -> Index = " + index);
        Debug.println("   -> target = " + Arrays.toString(transTarget));
        return new TreeModelEvent((Object)this, transPath, inds, transTarget);
    }

    TT_BasicNode[] translatePath(TestResultTable.TreeNode[] path, boolean create) {
        if (path == null) {
            return null;
        }
        TT_BasicNode location = (TT_BasicNode)this.getRoot();
        TT_BasicNode[] transPath = new TT_BasicNode[path.length];
        transPath[0] = location;
        for (int i = 1; i < path.length; ++i) {
            TT_TreeNode mnode = location.findByName(path[i].getName());
            if (create && mnode == null) {
                location.addNodes(new TestResultTable.TreeNode[]{path[i]});
                mnode = location.findByName(path[i].getName());
            } else if (!(mnode instanceof TT_BasicNode)) {
                return null;
            }
            transPath[i] = (TT_BasicNode)mnode;
            location = transPath[i];
        }
        return transPath;
    }

    String[] pathsToStrings(TreePath[] paths) {
        if (paths == null || paths.length == 0 || !(this.getRoot() instanceof TT_BasicNode)) {
            return null;
        }
        String[] result = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            TT_TreeNode tn = (TT_TreeNode)paths[i].getLastPathComponent();
            result[i] = tn.getLongPath();
        }
        return result;
    }

    TreePath[] urlsToPaths(String[] urls) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (int i = 0; i < urls.length; ++i) {
            TreePath thisOne = this.urlToPath(urls[i]);
            if (thisOne == null) continue;
            result.add(thisOne);
        }
        TreePath[] res = new TreePath[result.size()];
        result.toArray(res);
        return res;
    }

    TreePath urlToPath(String url) {
        if (url == null) {
            return null;
        }
        String[] urlPath = StringArray.splitList(url, "/");
        Object[] transPath = new TT_TreeNode[urlPath.length + 1];
        TT_BasicNode location = (TT_BasicNode)this.getRoot();
        transPath[0] = location;
        for (int i = 0; i < urlPath.length; ++i) {
            if (location == null) {
                return null;
            }
            TT_TreeNode mnode = location.findByName(urlPath[i]);
            if (mnode == null) {
                return null;
            }
            transPath[i + 1] = mnode;
            location = transPath[i + 1] instanceof TT_BasicNode ? (TT_BasicNode)transPath[i + 1] : null;
        }
        return new TreePath(transPath);
    }

    void setParameters(Parameters p) {
        if (p != null) {
            this.params = p;
            this.init();
        } else {
            TestResultTable dummy = new TestResultTable();
            this.setTestResultTable(dummy);
            if (debug > 0) {
                Debug.println("TTM - dummy TRT, root = " + dummy.getRoot());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        if (this.params == null) {
            return;
        }
        WorkDirectory wd = this.params.getWorkDirectory();
        TestSuite ts = this.params.getTestSuite();
        if (wd != null) {
            if (debug > 0) {
                Debug.println("TTM - initializing with workdir");
            }
            this.log = this.getLog(wd);
            TestResultTable newTrt = wd.getTestResultTable();
            try {
                newTrt.getLock().lock();
                this.setTestResultTable(newTrt);
                Object var5_4 = null;
                newTrt.getLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                newTrt.getLock().unlock();
                throw throwable;
            }
            this.sortComparator = newTrt.getTestFinder().getComparator();
        } else if (ts != null) {
            if (this.trt != null && this.trt.getTestFinder() == null) {
                try {
                    this.trt.getLock().lock();
                    this.trt.setTestFinder(ts.getTestFinder());
                    this.setTestResultTable(this.trt);
                    Object var7_7 = null;
                    this.trt.getLock().unlock();
                    this.sortComparator = this.trt.getTestFinder().getComparator();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.trt.getLock().unlock();
                    this.sortComparator = this.trt.getTestFinder().getComparator();
                    throw throwable;
                }
                if (debug > 0) {
                    Debug.println("TTM - params set, no WD; setting finder on temp. TRT");
                }
            } else if (debug > 0) {
                Debug.println("TTM - temp. TRT already has finder");
            }
        } else if (debug > 0) {
            Debug.println("TTM - params set, no WD or TS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseWork() {
        this.cacheWorker.setPaused(true);
        while (this.cacheWorker != null && this.cacheWorker.isAlive() && !this.cacheWorker.stopping && !this.cacheWorker.isReallyPaused) {
            try {
                CacheWorker cacheWorker = this.cacheWorker;
                synchronized (cacheWorker) {
                    this.cacheWorker.notifyAll();
                    this.cacheWorker.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpauseWork() {
        if (this.cacheWorker == null) {
            return;
        }
        this.invalidateNodeInfo();
        this.cacheWorker.setPaused(false);
        CacheWorker cacheWorker = this.cacheWorker;
        synchronized (cacheWorker) {
            this.cacheWorker.notifyAll();
        }
    }

    boolean isWorkPaused() {
        return this.cacheWorker.isPaused();
    }

    private void setTestResultTable(TestResultTable newTrt) {
        if (TestTreeModel.isCompatible(this.trt, newTrt)) {
            this.swapTables(newTrt);
        } else {
            if (this.trt != null) {
                this.trt.removeObserver(this);
            }
            this.trt = newTrt;
            this.trt.addObserver(this);
        }
        this.root = new TT_BasicNode(null, (TRT_TreeNode)this.trt.getRoot(), this.trt.getTestFinder() == null ? null : this.trt.getTestFinder().getComparator());
        this.relevantNodes = Collections.synchronizedSet(new HashSet());
        this.relevantTests = Collections.synchronizedSet(new HashSet());
        this.addRelevantNode((TT_TreeNode)this.getRoot());
        TT_BasicNode tn = (TT_BasicNode)this.getRoot();
        for (int i = 0; i < ((TT_BasicNode)this.getRoot()).getChildCount(); ++i) {
            this.addRelevantNode((TT_TreeNode)tn.getChildAt(i));
        }
        this.notifyFullStructure();
        if (debug > 0) {
            Debug.println("TTM - Model watching " + this.trt);
            if (this.trt.getWorkDir() != null) {
                Debug.println("   -> Workdir=" + this.trt.getWorkDir());
                Debug.println("   -> Workdir path=" + this.trt.getWorkDir().getPath());
                Debug.println("   -> root = " + this.trt.getRoot());
            }
        }
    }

    static boolean isCompatible(TestResultTable t1, TestResultTable t2) {
        if (t1 == null || t2 == null || t1.getTestSuiteRoot() == null || t2.getTestSuiteRoot() == null || t1.getTestFinder() == null || t2.getTestFinder() == null) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() false because one or both TRTs are incomplete.");
                if (t1 != null && t2 != null) {
                    Debug.println("t1 root = " + t1.getTestSuiteRoot());
                    Debug.println("t2 root = " + t2.getTestSuiteRoot());
                    Debug.println("t1 finder= " + t1.getTestFinder());
                    Debug.println("t2 finder= " + t2.getTestFinder());
                }
            }
            return false;
        }
        if (!t1.getTestSuiteRoot().getPath().equals(t2.getTestSuiteRoot().getPath())) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() failed because testsuite paths differ.");
            }
            return false;
        }
        if (t1.getTestFinder() != t2.getTestFinder()) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() failed because TestFinders differ.");
            }
            return false;
        }
        return true;
    }

    TestResultTable getTestResultTable() {
        return this.trt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TT_NodeCache getNodeInfo(TestResultTable.TreeNode node, boolean highPriority) {
        TT_NodeCache ni = null;
        boolean wakeWorker = false;
        TestFilter activeFilter = this.filterHandler.getActiveFilter();
        Object object = this.htLock;
        synchronized (object) {
            int index;
            ni = this.cache.get(node);
            if (ni == null) {
                ni = new TT_NodeCache(node, activeFilter, this.log);
                this.cache.put(node, ni);
                if (!highPriority) {
                    this.cacheQueue.addFirst(ni);
                }
                wakeWorker = true;
            } else if (highPriority && (index = this.cacheQueue.indexOf(ni)) >= 0) {
                this.cacheQueue.remove(index);
            }
        }
        if (highPriority) {
            this.cacheWorker.requestActiveNode(ni);
            wakeWorker = true;
        }
        if (!this.statsForwarded && node.isRoot() && ni.isComplete()) {
            WorkDirectory wd;
            int[] stats = ni.getStats();
            int total = 0;
            for (int i = 0; i < stats.length; ++i) {
                total += stats[i];
            }
            total += ni.getRejectCount();
            if (this.params != null && (wd = this.params.getWorkDirectory()) != null) {
                wd.setTestSuiteTestCount(total);
                this.statsForwarded = true;
            }
        }
        if (wakeWorker) {
            object = this.cacheWorker;
            synchronized (object) {
                this.cacheWorker.notify();
            }
        }
        return ni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateNodeInfo(TestResultTable.TreeNode[] path) {
        Object object = this.htLock;
        synchronized (object) {
            for (int i = 0; i < path.length; ++i) {
                TT_NodeCache info = this.cache.get(path[i]);
                if (info == null) continue;
                if (debug > 1) {
                    Debug.println("TTM - halting thread and removed from node cache");
                    Debug.println("   -> " + path[i]);
                    Debug.println("   -> " + info);
                }
                info.halt();
                this.cache.remove(info.getNode());
                boolean wasInQueue = this.cacheQueue.remove(info);
                info = new TT_NodeCache(info.getNode(), this.filterHandler.getActiveFilter(), this.log);
                this.cache.put(info.getNode(), info);
                this.cacheQueue.addFirst(info);
            }
        }
        object = this.cacheWorker;
        synchronized (object) {
            this.cacheWorker.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateNodeInfo() {
        Object object = this.htLock;
        synchronized (object) {
            Enumeration<TestResultTable.TreeNode> e = this.cache.keys();
            while (e.hasMoreElements()) {
                this.cache.get(e.nextElement()).invalidate();
            }
            this.cache = new Hashtable();
            this.cacheQueue = new LinkedList();
            this.suspendedQueue = new LinkedList();
        }
        for (TT_TreeNode tn : this.relevantNodes) {
            if (!(tn instanceof TT_BasicNode)) continue;
            this.getNodeInfo(((TT_BasicNode)tn).getTableNode(), false);
        }
    }

    void invalidateNodeInfo(TestResultTable.TreeNode node) {
        this.invalidateNodeInfo(new TestResultTable.TreeNode[]{node});
    }

    void swapTables(TestResultTable newTrt) {
        if (newTrt == this.trt || newTrt == null) {
            return;
        }
        if (debug > 1) {
            Debug.println("Swapping TRTs under the covers.");
            Debug.println("   -> OLD=" + this.trt);
            Debug.println("   -> NEW=" + newTrt);
        }
        this.trt.removeObserver(this);
        this.trt = newTrt;
        this.trt.addObserver(this);
    }

    private void notifyModelListeners(TreeModelEvent e, int eType) {
        if (this.treeModelListeners != null) {
            Notifier n = new Notifier(eType, this.treeModelListeners, e, this.uif);
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(n);
            } else {
                n.run();
            }
        }
    }

    void notifyFullStructure() {
        if (debug > 0) {
            Debug.println("TTM - sending full structure change event to model listeners.");
        }
        this.invalidateNodeInfo();
        Object[] path = new Object[]{this.getRoot()};
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.notifyModelListeners(e, 1);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.trt != null) {
            this.trt.removeObserver(this);
        }
    }

    private Logger getLog(WorkDirectory wd) {
        Logger log = null;
        String logName = this.uif.getI18NString("tree.log.name");
        try {
            log = wd.getTestSuite().createLog(wd, null, logName);
        }
        catch (TestSuite.DuplicateLogNameFault f) {
            try {
                log = wd.getTestSuite().getLog(wd, logName);
            }
            catch (TestSuite.NoSuchLogFault f2) {
                // empty catch block
            }
        }
        return log;
    }

    private class FilterWatcher
    implements FilterSelectionHandler.Observer {
        private FilterWatcher() {
        }

        public void filterUpdated(TestFilter f) {
            TestTreeModel.this.invalidateNodeInfo();
        }

        public void filterSelected(TestFilter f) {
            if (!TestTreeModel.this.lastFilter.equals(f)) {
                TestTreeModel.this.invalidateNodeInfo();
            }
            TestTreeModel.this.lastFilter = f;
        }

        public void filterAdded(TestFilter f) {
        }

        public void filterRemoved(TestFilter f) {
        }
    }

    private static class Notifier
    implements Runnable {
        TreeModelListener[] l;
        int type;
        TreeModelEvent e;
        UIFactory uif;
        static final int CHANGE = 0;
        static final int STRUCT = 1;
        static final int INS = 2;
        static final int DEL = 3;

        Notifier(int eType, TreeModelListener[] listeners, TreeModelEvent e, UIFactory uif) {
            this.type = eType;
            this.e = e;
            this.uif = uif;
            TreeModelListener[] copy = new TreeModelListener[listeners.length];
            System.arraycopy(listeners, 0, copy, 0, listeners.length);
            this.l = copy;
        }

        public void run() {
            if (this.e == null) {
                return;
            }
            switch (this.type) {
                case 0: {
                    Object[] path = this.e.getPath();
                    if (path != null && path.length > 0 && path[path.length - 1] instanceof TT_BasicNode) {
                        TT_BasicNode bn = (TT_BasicNode)path[path.length - 1];
                        if (this.e.getChildIndices() != null && this.e.getChildIndices().length >= 1 && bn.getChildCount() <= this.e.getChildIndices()[0]) {
                            return;
                        }
                    }
                    for (int i = 0; i < this.l.length; ++i) {
                        this.l[i].treeNodesChanged(this.e);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.l.length; ++i) {
                        this.l[i].treeStructureChanged(this.e);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.l.length; ++i) {
                        this.l[i].treeNodesInserted(this.e);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.l.length; ++i) {
                        this.l[i].treeNodesRemoved(this.e);
                    }
                    break;
                }
                default: {
                    throw new JavaTestError(this.uif.getI18NString("tree.noEType"));
                }
            }
        }
    }

    private class CacheWorker
    extends Thread {
        private volatile boolean paused;
        private volatile boolean stopping;
        private volatile TT_NodeCache priorityUnit;
        private volatile TT_NodeCache currentUnit;
        private volatile boolean isReallyPaused;
        private static final int QUEUE = 0;
        private static final int DEPTH = 1;
        private static final int SCHEDULING_ALGO = 1;

        CacheWorker() {
            super("Test Tree Cache Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                CacheWorker cacheWorker = this;
                synchronized (cacheWorker) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            while (!this.stopping) {
                CacheWorker e;
                if (this.paused) {
                    try {
                        e = this;
                        synchronized (e) {
                            this.isReallyPaused = true;
                            this.notifyAll();
                            this.wait();
                            this.isReallyPaused = false;
                            continue;
                        }
                    }
                    catch (InterruptedException e2) {
                        this.stopping = true;
                        this.isReallyPaused = false;
                        continue;
                    }
                }
                this.currentUnit = this.getNextUnit();
                if (this.currentUnit == null) {
                    try {
                        e = this;
                        synchronized (e) {
                            this.notifyAll();
                            this.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException e3) {
                        this.stopping = true;
                        continue;
                    }
                }
                if (!this.currentUnit.canRun()) continue;
                if (debug > 0) {
                    Debug.println("TTM cache processing " + this.currentUnit.getNode().getName());
                }
                this.currentUnit.run();
                if (this.currentUnit.isPaused() || !this.currentUnit.isValid()) continue;
                this.finishJob(this.currentUnit);
            }
            this.currentUnit = null;
            this.priorityUnit = null;
        }

        public TT_NodeCache getActiveNode() {
            return this.currentUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setPaused(boolean state) {
            CacheWorker cacheWorker = this;
            synchronized (cacheWorker) {
                if (state != this.paused) {
                    this.paused = state;
                    if (this.paused && this.currentUnit != null) {
                        this.currentUnit.pause();
                        TestTreeModel.this.suspendedQueue.addFirst(this.currentUnit);
                    }
                    if (!this.paused) {
                        this.notify();
                    }
                }
            }
        }

        synchronized boolean isPaused() {
            return this.paused;
        }

        synchronized void requestActiveNode(TT_NodeCache what) {
            if (what != null && this.currentUnit != what && what.canRun()) {
                this.priorityUnit = what;
                if (this.currentUnit != null) {
                    this.currentUnit.pause();
                    TestTreeModel.this.suspendedQueue.addFirst(this.currentUnit);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TT_NodeCache getNextUnit() {
            boolean wasPriority = false;
            TT_NodeCache next = null;
            Object object = TestTreeModel.this.htLock;
            synchronized (object) {
                if (this.priorityUnit != null) {
                    wasPriority = true;
                    next = this.priorityUnit;
                    this.priorityUnit = null;
                } else {
                    switch (1) {
                        case 0: {
                            next = this.selectByQueuing();
                            break;
                        }
                        case 1: {
                            next = this.selectByDepth();
                            break;
                        }
                        default: {
                            next = this.selectByQueuing();
                        }
                    }
                }
                if (next != null && !next.canRun()) {
                    return this.getNextUnit();
                }
                return next;
            }
        }

        private TT_NodeCache selectByQueuing() {
            TT_NodeCache selection = null;
            if (TestTreeModel.this.suspendedQueue.size() > 0) {
                selection = TestTreeModel.this.suspendedQueue.removeLast();
            } else if (TestTreeModel.this.cacheQueue.size() > 0) {
                selection = TestTreeModel.this.cacheQueue.removeLast();
            }
            if (selection != null && selection.getNode().isRoot() && (TestTreeModel.this.cacheQueue.size() > 0 || TestTreeModel.this.suspendedQueue.size() > 0)) {
                TestTreeModel.this.cacheQueue.addFirst(selection);
                return this.selectByQueuing();
            }
            return selection;
        }

        private TT_NodeCache selectByDepth() {
            TT_NodeCache selected = null;
            int depth = -1;
            LinkedList<TT_NodeCache> theList = TestTreeModel.this.cacheQueue;
            boolean notDone = true;
            int count = 0;
            if (TestTreeModel.this.cacheQueue.size() == 0) {
                if (TestTreeModel.this.suspendedQueue.size() == 0) {
                    notDone = false;
                } else {
                    theList = TestTreeModel.this.suspendedQueue;
                }
            }
            while (notDone) {
                TT_NodeCache possible = theList.get(count);
                int thisDepth = TestResultTable.getObjectPath(possible.getNode()).length;
                if (thisDepth > depth) {
                    theList.remove(count);
                    if (selected != null) {
                        TestTreeModel.this.cacheQueue.addFirst(selected);
                        if (theList == TestTreeModel.this.cacheQueue) {
                            ++count;
                        }
                    }
                    depth = thisDepth;
                    selected = possible;
                }
                if (++count < theList.size()) continue;
                if (theList == TestTreeModel.this.suspendedQueue) {
                    notDone = false;
                    continue;
                }
                if (TestTreeModel.this.suspendedQueue.size() != 0) {
                    theList = TestTreeModel.this.suspendedQueue;
                    count = 0;
                    continue;
                }
                notDone = false;
            }
            return selected;
        }

        private synchronized void finishJob(TT_NodeCache item) {
            TreeModelEvent e = null;
            TestResultTable.TreeNode node = item.getNode();
            if (node.isRoot()) {
                e = new TreeModelEvent((Object)this, new Object[]{TestTreeModel.this.getRoot()}, (int[])null, (Object[])null);
            } else {
                TreePath path = TestTreeModel.this.resolveUrl(TestResultTable.getRootRelativePath(node));
                if (path != null) {
                    TreePath pp = path.getParentPath();
                    TT_BasicNode bn = (TT_BasicNode)path.getLastPathComponent();
                    int index = ((TT_BasicNode)pp.getLastPathComponent()).getIndex(bn);
                    e = new TreeModelEvent((Object)this, pp, new int[]{index}, new Object[]{bn});
                }
            }
            TestTreeModel.this.notifyModelListeners(e, 0);
            if (debug > 0) {
                Debug.println("NodeCache done for " + item.getNode().getName());
            }
        }
    }
}

