/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.tool.UIFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

class ImagePane
extends JLabel
implements MultiFormatPane.MediaPane {
    private JScrollPane owner;

    public ImagePane(UIFactory uif, String uiKey, JScrollPane owner) {
        super(uif.getI18NString(uiKey + ".lbl"));
        this.owner = owner;
    }

    public void changeURL(URL url) {
    }

    public void setParent(JScrollPane owner) {
        this.owner = owner;
    }

    public int getMode() {
        return 1;
    }

    public void showImage(URL url) {
        if (ImagePane.isImageFormatSupported(url)) {
            ImageIcon img = new ImageIcon(url);
            this.setIcon(img);
            this.owner.setViewportView(this);
            this.owner.revalidate();
            this.owner.repaint();
        }
    }

    public static boolean isImageResource(URL url) {
        String file = url.getFile();
        String ext = file.substring(file.lastIndexOf(46) + 1);
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(ext);
        return iter.hasNext();
    }

    public static boolean isImageFormatSupported(URL url) {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(new File(url.getFile()));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return false;
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }
}

