/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFOS;
import com.sun.javatest.cof.Main;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class COFEnvironment
extends COFItem {
    static String[] propOrder = new String[]{"machine", "os", "jdk", "systemLocale", "userLocale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static String[] propTags = new String[]{"machine", "os", "jdk", "system-locale", "user-locale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static LinkedHashMap xmlAttributes;
    static LinkedHashMap xmlElements;
    static String xmlTagName;
    private static I18NResourceBundle i18n;
    protected Integer bits;
    protected String description;
    protected Integer displaydepth;
    private String domainName;
    protected String encoding;
    private String hostName;
    protected String id = "env:0";
    protected String jdk;
    protected String machine;
    protected COFOS os;
    protected List sw;
    protected String systemLocale;
    protected String timezone;
    protected String userLocale;
    protected COFData data;

    COFEnvironment(COFData data) {
        this.data = data;
        this.initDefaultHostInfo();
        this.initDefaultOSInfo();
        this.hostName = data.get("environment.host", this.hostName);
        this.domainName = data.get("environment.domain", this.domainName);
        this.setMachine(data.get("environment.machine", this.hostName + "." + this.domainName));
        this.os.setName(data.get("environment.os.name", this.os.getName()));
        this.os.setVersion(data.get("environment.os.version", this.os.getVersion()));
        this.os.setArch(data.get("environment.os.arch", this.os.getArch()));
        this.setJdk(data.get("environment.jdk", this.jdk));
        this.setUserLocale(data.get("environment.user-locale", Locale.getDefault().toString()));
        this.setSystemLocale(data.get("environment.system-locale", data.get("LOCALE")));
        this.setEncoding(data.get("environment.encoding", new InputStreamReader(System.in).getEncoding()));
        this.setTimezone(data.get("environment.timezone", TimeZone.getDefault().getID()));
        this.setBits(data.get("environment.bits", null) == null ? null : new Integer(data.get("environment.bits")));
        this.setDisplaydepth(data.get("environment.displaydepth", null) == null ? null : new Integer(data.get("environment.displaydepth")));
        this.setDescription(data.get("environment.description"));
    }

    public COFEnvironment(COFData data, String id) {
        this(data);
        this.id = id;
    }

    public Integer getBits() {
        return this.bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCalderaLinuxVersionInfo() {
        String line;
        String res = "N/A";
        RandomAccessFile raf = null;
        raf = new RandomAccessFile("/etc/issue", "r");
        while ((line = raf.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            if (st.countTokens() < 2 || !st.nextToken().toUpperCase().equals("VERSION")) continue;
            res = st.nextToken();
            break;
        }
        Object var6_6 = null;
        if (raf == null) return res;
        try {
            raf.close();
            return res;
        }
        catch (Exception e) {}
        return res;
        {
            catch (Exception exception) {
                Object var6_7 = null;
                if (raf == null) return res;
                try {
                    raf.close();
                    return res;
                }
                catch (Exception e) {}
                return res;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (raf == null) throw throwable;
            try {
                raf.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDisplaydepth() {
        return this.displaydepth;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getGenericLinuxVersionInfo(String fileName) {
        String res = "N/A";
        RandomAccessFile raf = null;
        raf = new RandomAccessFile(fileName, "r");
        StringTokenizer st = new StringTokenizer(raf.readLine(), " ");
        while (st.hasMoreElements()) {
            String ele = st.nextToken();
            if (!Character.isDigit(ele.charAt(0))) continue;
            res = ele;
            break;
        }
        Object var7_7 = null;
        if (raf == null) return res;
        try {
            raf.close();
            return res;
        }
        catch (Exception e2) {}
        return res;
        {
            catch (Exception e) {
                Object var7_8 = null;
                if (raf == null) return res;
                try {
                    raf.close();
                    return res;
                }
                catch (Exception e2) {}
                return res;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (raf == null) throw throwable;
            try {
                raf.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getId() {
        return this.id;
    }

    LinkedHashMap getItemAttributes() {
        return xmlAttributes;
    }

    LinkedHashMap getItemElements() {
        return xmlElements;
    }

    String getItemTagName() {
        return xmlTagName;
    }

    public String getJdk() {
        return this.jdk;
    }

    public String getMachine() {
        return this.machine;
    }

    public COFOS getOs() {
        return this.os;
    }

    String[] getPropOrder() {
        return propOrder;
    }

    public List getSw() {
        if (this.sw == null) {
            this.sw = new ArrayList();
        }
        return this.sw;
    }

    public String getSystemLocale() {
        return this.systemLocale;
    }

    String getTagName() {
        return this.itemTagName;
    }

    String[] getTags() {
        return propTags;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    private void initDefaultHostInfo() {
        this.domainName = "unknown";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "unknown";
        }
    }

    private void initDefaultOSInfo() {
        this.os = new COFOS();
        this.os.setName(System.getProperty("os.name"));
        this.os.setVersion(System.getProperty("os.version"));
        this.os.setArch(System.getProperty("os.arch"));
    }

    public void setBits(Integer value) {
        this.bits = value;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setDisplaydepth(Integer value) {
        this.displaydepth = value;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void setJdk(String value) {
        this.jdk = value;
    }

    public void setMachine(String value) {
        if (value.endsWith(".unknown")) {
            try {
                this.machine = InetAddress.getLocalHost().getCanonicalHostName();
                if (this.machine.indexOf(".") == -1) {
                    if ("false".equals(this.data.get("showWarnings"))) {
                        System.err.println(i18n.getString("environment.badMachineName", this.machine));
                    } else {
                        String warningMessage = this.data.get("warning", "");
                        this.data.put("warning", warningMessage + i18n.getString("environment.badMachineName") + "\n");
                    }
                }
                return;
            }
            catch (UnknownHostException e) {
                if ("false".equals(this.data.get("showWarnings"))) {
                    System.err.println(i18n.getString("environment.cantGetLocalhostName", e.getMessage()));
                    value = value.substring(0, value.indexOf(".unknown") - 1);
                    System.err.println(i18n.getString("environment.badMachineName", value));
                }
                String warningMessage = this.data.get("warning", "");
                value = value.substring(0, value.indexOf(".unknown") - 1);
                this.data.put("warning", warningMessage + i18n.getString("environment.cantGetLocalhostName", e.getMessage()) + "\n" + i18n.getString("environment.badMachineName", value) + "\n");
            }
        }
        this.machine = value;
    }

    public void setOs(COFOS value) {
        this.os = value;
    }

    public void setSystemLocale(String value) {
        this.systemLocale = value;
    }

    public void setTimezone(String value) {
        this.timezone = value;
    }

    public void setUserLocale(String value) {
        this.userLocale = value;
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
        xmlElements = new LinkedHashMap();
        for (int i = 0; i < propOrder.length; ++i) {
            xmlElements.put(propOrder[i], propTags[i]);
        }
        xmlAttributes = new LinkedHashMap();
        xmlAttributes.put("id", "id");
        xmlTagName = "environment";
    }
}

