/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.javatest.DefaultTestRunner;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestRunner;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.interview.LegacyParameters;
import com.sun.javatest.lib.KeywordScript;
import com.sun.javatest.logging.ObservedFile;
import com.sun.javatest.logging.WorkDirLogHandler;
import com.sun.javatest.services.PropertyServiceReader;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TestSuite {
    public static final int DELETE_NONTEST_RESULTS = 0;
    public static final int REFRESH_ON_RUN = 1;
    public static final int CLEAR_CHANGED_TEST = 2;
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static final String TESTSUITE_JTT = "testsuite.jtt";
    private static final String FIND_LEGACY_CONSTRUCTOR = "com.sun.javatest.ts.findLegacyCtor";
    private File root;
    private Map tsInfo;
    private ClassLoader loader;
    private TestFinder finder;
    private Class scriptClass;
    private String[] scriptArgs;
    private String[] keywords;
    private ServiceReader serviceReader;
    private ServiceManager serviceManager;
    private static HashMap dirMap = new HashMap(2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestSuite.class);
    private static String notificationLogName = i18n.getString("notification.logname");
    static HashMap handlersMap = new HashMap();
    private static Vector<GeneralPurposeLogger> gpls;
    private static HashMap observedFiles;
    private final NotificationLogger notifLogger = new NotificationLogger(null);
    public static final String TM_CONTEXT_NAME = "tmcontext";

    public static boolean isTestSuite(File root) {
        File dir;
        if (root.isDirectory()) {
            dir = root;
        } else if (root.getName().equalsIgnoreCase(TESTSUITE_HTML)) {
            dir = root.getParentFile();
        } else {
            return false;
        }
        File jtt = new File(dir, TESTSUITE_JTT);
        File parentDir = dir.getParentFile();
        File parent_jtt = parentDir == null ? null : new File(parentDir, TESTSUITE_JTT);
        File html = new File(dir, TESTSUITE_HTML);
        return TestSuite.isReadableFile(jtt) || TestSuite.isReadableFile(html) && (parent_jtt == null || !parent_jtt.exists());
    }

    public static TestSuite open(File root) throws FileNotFoundException, Fault, NotTestSuiteFault {
        File parent_jtt;
        File canonRootDir;
        File canonRoot;
        if (!root.exists()) {
            throw new FileNotFoundException(root.getPath());
        }
        try {
            canonRoot = root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new Fault(i18n, "ts.cantCanonicalize", new Object[]{root.getPath(), e.toString()});
        }
        if (canonRoot.isDirectory()) {
            canonRootDir = canonRoot;
        } else if (canonRoot.getName().equalsIgnoreCase(TESTSUITE_HTML)) {
            canonRootDir = canonRoot.getParentFile();
        } else {
            throw new NotTestSuiteFault(i18n, "ts.notTestSuiteFile", canonRoot);
        }
        File f = new File(canonRootDir, TESTSUITE_JTT);
        if (TestSuite.isReadableFile(f)) {
            try {
                Properties p = new Properties();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                p.load(in);
                ((InputStream)in).close();
                return TestSuite.open(canonRoot, p);
            }
            catch (IOException e) {
                throw new Fault(i18n, "ts.cantReadTestSuiteFile", e.toString());
            }
        }
        File ts_html = new File(canonRootDir, TESTSUITE_HTML);
        File parentDir = canonRootDir.getParentFile();
        File file = parent_jtt = parentDir == null ? null : new File(parentDir, TESTSUITE_JTT);
        if (TestSuite.isReadableFile(ts_html) && (parent_jtt == null || !parent_jtt.exists())) {
            return TestSuite.open(canonRoot, new HashMap());
        }
        throw new NotTestSuiteFault(i18n, "ts.notTestSuiteFile", canonRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TestSuite open(File root, Map tsInfo) throws Fault {
        HashMap hashMap = dirMap;
        synchronized (hashMap) {
            TestSuite ts;
            WeakReference ref = (WeakReference)dirMap.get(root);
            if (ref != null && (ts = (TestSuite)ref.get()) != null) {
                return ts;
            }
            ts = TestSuite.open0(root, tsInfo);
            dirMap.put(root, new WeakReference<TestSuite>(ts));
            return ts;
        }
    }

    private static TestSuite open0(File root, Map tsInfo) throws Fault {
        TestSuite testSuite;
        URLClassLoader cl;
        String[] classPath = StringArray.split((String)tsInfo.get("classpath"));
        if (classPath.length == 0) {
            cl = null;
        } else {
            try {
                File rootDir = root.isDirectory() ? root : root.getParentFile();
                URL[] p = new URL[classPath.length];
                for (int i = 0; i < classPath.length; ++i) {
                    String cpi = classPath[i];
                    if (cpi.toLowerCase().startsWith("http:")) {
                        p[i] = new URL(cpi);
                        continue;
                    }
                    File f = new File(cpi);
                    if (!f.isAbsolute()) {
                        f = new File(rootDir, cpi);
                    }
                    p[i] = f.toURI().toURL();
                }
                cl = new URLClassLoader(p, TestSuite.class.getClassLoader());
            }
            catch (MalformedURLException e) {
                throw new Fault(i18n, "ts.badClassPath", new Object[]{root, e.getMessage()});
            }
        }
        String[] tsClassAndArgs = StringArray.split((String)tsInfo.get("testsuite"));
        if (tsClassAndArgs.length == 0) {
            testSuite = new TestSuite(root, tsInfo, cl);
        } else {
            String className = tsClassAndArgs[0];
            try {
                Class c = TestSuite.loadClass(className, cl);
                Class[] tsArgTypes = new Class[]{File.class, Map.class, ClassLoader.class};
                Object[] tsArgs = new Object[]{root, tsInfo, cl};
                testSuite = (TestSuite)TestSuite.newInstance(c, tsArgTypes, tsArgs);
            }
            catch (ClassCastException e) {
                throw new Fault(i18n, "ts.notASubtype", new Object[]{className, "testsuite", TestSuite.class.getName()});
            }
            String[] args = new String[tsClassAndArgs.length - 1];
            System.arraycopy(tsClassAndArgs, 1, args, 0, args.length);
            testSuite.init(args);
        }
        testSuite.setTestFinder(testSuite.createTestFinder());
        return testSuite;
    }

    public TestSuite(File root, Map tsInfo, ClassLoader cl) throws Fault {
        this.root = root;
        this.tsInfo = tsInfo;
        this.loader = cl;
        String kw = tsInfo == null ? null : (String)tsInfo.get("keywords");
        this.keywords = kw == null ? null : StringArray.split(kw);
    }

    public TestSuite(File root) {
        this.root = root;
    }

    protected void init(String[] args) throws Fault {
        if (args.length > 0) {
            throw new Fault(i18n, "ts.badArgs", args[0]);
        }
    }

    public String getPath() {
        return this.root.getPath();
    }

    public File getRoot() {
        return this.root;
    }

    public File getRootDir() {
        return this.root.isDirectory() ? this.root : new File(this.root.getParent());
    }

    public File getTestsDir() {
        String t = this.tsInfo == null ? null : this.tsInfo.get("tests");
        if (t == null || t.length() == 0) {
            File rootDir = this.getRootDir();
            File testsDir = new File(rootDir, "tests");
            if (testsDir.isDirectory()) {
                return testsDir;
            }
            return rootDir;
        }
        File f = new File(t);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getRootDir(), t.replace('/', File.separatorChar));
    }

    public void starting(Harness harness) throws Fault {
        if (this.getServiceManager() != null) {
            this.serviceManager.setHarness(harness);
        }
    }

    public TestFilter createTestFilter(TestEnvironment filterEnv) {
        return null;
    }

    public TestFinder getTestFinder() {
        return this.finder;
    }

    protected void setTestFinder(TestFinder tf) {
        if (tf == null) {
            throw new NullPointerException();
        }
        if (this.finder != null && this.finder != tf) {
            throw new IllegalStateException();
        }
        this.finder = tf;
    }

    protected TestFinder createTestFinder() throws Fault {
        File jtdFile;
        String finderClassName;
        File testsDir = this.getTestsDir();
        String[] finderCmd = StringArray.split((String)this.tsInfo.get("finder"));
        String[] finderArgs = new String[]{};
        if (finderCmd == null || finderCmd.length == 0) {
            finderCmd = null;
            finderClassName = HTMLTestFinder.class.getName();
        } else {
            finderClassName = finderCmd[0];
            if (finderCmd.length > 1) {
                finderArgs = new String[finderCmd.length - 1];
                System.arraycopy(finderCmd, 1, finderArgs, 0, finderArgs.length);
            }
        }
        String jtd = (String)this.tsInfo.get("testsuite.jtd");
        File file = jtdFile = jtd == null ? new File(testsDir, "testsuite.jtd") : new File(this.root, jtd);
        if (jtdFile.exists()) {
            try {
                return this.createBinaryTestFinder(finderCmd == null ? null : finderClassName, finderArgs, testsDir, jtdFile);
            }
            catch (TestFinder.Fault e) {
            }
            catch (Fault f) {
                // empty catch block
            }
        }
        try {
            Class c = this.loadClass(finderClassName);
            TestFinder tf = (TestFinder)TestSuite.newInstance(c);
            tf.init(finderArgs, testsDir, null, null, null);
            return tf;
        }
        catch (ClassCastException e) {
            throw new Fault(i18n, "ts.notASubtype", new Object[]{finderClassName, "finder", TestFinder.class.getName()});
        }
        catch (TestFinder.Fault e) {
            throw new Fault(i18n, "ts.errorInitFinder", new Object[]{finderClassName, e.getMessage()});
        }
    }

    protected TestFinder createBinaryTestFinder(String finderClassName, String[] finderArgs, File testsDir, File jtdFile) throws Fault, TestFinder.Fault {
        try {
            TestFinder tf = null;
            if (finderClassName != null) {
                Class c = this.loadClass(finderClassName);
                tf = (TestFinder)TestSuite.newInstance(c);
            }
            if (tf instanceof BinaryTestFinder) {
                tf.init(finderArgs, testsDir, null, null, null);
                return tf;
            }
            return new BinaryTestFinder(testsDir, jtdFile);
        }
        catch (ClassCastException e) {
            throw new Fault(i18n, "ts.notASubtype", new Object[]{finderClassName, "finder", TestFinder.class.getName()});
        }
        catch (TestFinder.Fault e) {
            throw new Fault(i18n, "ts.errorInitFinder", new Object[]{finderClassName, e.getMessage()});
        }
    }

    public TestRunner createTestRunner() {
        return new DefaultTestRunner();
    }

    public Script createScript(TestDescription td, String[] exclTestCases, TestEnvironment scriptEnv, WorkDirectory workDir, BackupPolicy backupPolicy) throws Fault {
        if (this.scriptClass == null) {
            String[] script = TestSuite.envLookup(scriptEnv, "script");
            if (script.length == 0) {
                script = StringArray.split((String)this.tsInfo.get("script"));
            }
            if (script.length > 0) {
                this.scriptClass = this.loadClass(script[0]);
                if (!Script.class.isAssignableFrom(this.scriptClass)) {
                    throw new Fault(i18n, "ts.notASubtype", new Object[]{script[0], "script", Script.class.getName()});
                }
                this.scriptArgs = new String[script.length - 1];
                System.arraycopy(script, 1, this.scriptArgs, 0, this.scriptArgs.length);
            } else {
                boolean keywordScriptOK = false;
                Iterator i = scriptEnv.keys().iterator();
                while (i.hasNext() && !keywordScriptOK) {
                    String key = (String)i.next();
                    keywordScriptOK = key.startsWith("script.");
                }
                if (keywordScriptOK) {
                    this.scriptClass = KeywordScript.class;
                    this.scriptArgs = new String[0];
                } else {
                    throw new Fault(i18n, "ts.noScript");
                }
            }
        }
        Script s = (Script)TestSuite.newInstance(this.scriptClass);
        s.initArgs(this.scriptArgs);
        s.initTestDescription(td);
        s.initExcludedTestCases(exclTestCases);
        s.initTestEnvironment(scriptEnv);
        s.initWorkDir(workDir);
        s.initBackupPolicy(backupPolicy);
        s.initClassLoader(this.loader);
        return s;
    }

    public InterviewParameters createInterview() throws Fault {
        String[] classNameAndArgs = StringArray.split((String)this.tsInfo.get("interview"));
        if (classNameAndArgs == null || classNameAndArgs.length == 0) {
            try {
                return new LegacyParameters(this);
            }
            catch (Interview.Fault e) {
                throw new Fault(i18n, "ts.errorInitDefaultInterview", e.getMessage());
            }
        }
        String className = classNameAndArgs[0];
        String[] args = new String[classNameAndArgs.length - 1];
        System.arraycopy(classNameAndArgs, 1, args, 0, args.length);
        try {
            Class c = this.loadClass(className);
            InterviewParameters p = (InterviewParameters)TestSuite.newInstance(c);
            p.init(args);
            p.setTestSuite(this);
            return p;
        }
        catch (ClassCastException e) {
            throw new Fault(i18n, "ts.notASubtype", new Object[]{className, "interview", InterviewParameters.class.getName()});
        }
        catch (Interview.Fault e) {
            throw new Fault(i18n, "ts.errorInitInterview", new Object[]{className, e.getMessage()});
        }
    }

    public InterviewParameters loadInterviewFromTemplate(Properties templateInfo, InterviewParameters newInterview) throws Fault {
        newInterview.storeTemplateProperties(templateInfo);
        newInterview.propagateTemplateForAll();
        return newInterview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterviewParameters loadInterviewFromTemplate(File template, InterviewParameters ip) throws Fault, IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(template));
            Properties data = new Properties();
            data.load(in);
            String tm = (String)data.get("IS_TEMPLATE");
            if ("true".equals(tm)) {
                data.put("TEMPLATE_PATH", template.getAbsolutePath());
                ip.setTemplatePath(template.getAbsolutePath());
                InterviewParameters interviewParameters = this.loadInterviewFromTemplate(data, ip);
                return interviewParameters;
            }
            InterviewParameters interviewParameters = null;
            return interviewParameters;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public String getID() {
        return this.tsInfo == null ? null : (String)this.tsInfo.get("id");
    }

    public String getName() {
        return this.tsInfo == null ? null : (String)this.tsInfo.get("name");
    }

    public int getEstimatedTestCount() {
        try {
            String s;
            if (this.tsInfo != null && (s = (String)this.tsInfo.get("testCount")) != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public File getInitialExcludeList() {
        String s;
        String string = s = this.tsInfo == null ? null : (String)this.tsInfo.get("initial.jtx");
        if (s == null) {
            return null;
        }
        File f = new File(s.replace('/', File.separatorChar));
        if (!f.isAbsolute()) {
            f = new File(this.getRootDir(), f.getPath());
        }
        return f;
    }

    public boolean hasInitialExcludeList() {
        File f = this.getInitialExcludeList();
        return f == null ? false : f.exists();
    }

    public URL getLatestExcludeList() {
        try {
            String s = this.tsInfo == null ? null : (String)this.tsInfo.get("latest.jtx");
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean hasLatestExcludeList() {
        URL u = this.getLatestExcludeList();
        return u != null;
    }

    public String[] getAdditionalDocNames() {
        return this.tsInfo == null ? null : StringArray.split((String)this.tsInfo.get("additionalDocs"));
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public URL[] getFilesForTest(TestDescription td) {
        return td.getSourceURLs();
    }

    public URL[] getDocsForFolder(String path) {
        return null;
    }

    public URL[] getDocsForTest(TestDescription td) {
        return null;
    }

    public URL getLogo() {
        try {
            String s = this.tsInfo == null ? null : (String)this.tsInfo.get("logo");
            return s == null ? null : new URL(this.getRootDir().toURL(), s);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String[] envLookup(TestEnvironment env, String name) throws Fault {
        try {
            return env.lookup(name);
        }
        catch (TestEnvironment.Fault e) {
            throw new Fault(i18n, "ts.cantFindNameInEnv", new Object[]{name, e.getMessage()});
        }
    }

    protected static Object newInstance(Class c) throws Fault {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new Fault(i18n, "ts.cantInstantiate", new Object[]{c.getName(), e});
        }
        catch (IllegalAccessException e) {
            throw new Fault(i18n, "ts.illegalAccess", new Object[]{c.getName(), e});
        }
    }

    protected static Object newInstance(Class c, Class[] argTypes, Object[] args) throws Fault {
        try {
            return c.getConstructor(argTypes).newInstance(args);
        }
        catch (IllegalAccessException e) {
            throw new Fault(i18n, "ts.illegalAccess", new Object[]{c.getName(), e});
        }
        catch (InstantiationException e) {
            throw new Fault(i18n, "ts.cantInstantiate", new Object[]{c.getName(), e});
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof Fault) {
                throw (Fault)te;
            }
            throw new Fault(i18n, "ts.cantInit", new Object[]{c.getName(), te});
        }
        catch (NoSuchMethodException e) {
            if (argTypes.length > 1 && Boolean.getBoolean(FIND_LEGACY_CONSTRUCTOR)) {
                return TestSuite.newInstance(c, new Class[]{File.class}, new Object[]{args[0]});
            }
            throw new Fault(i18n, "ts.cantFindConstructor", new Object[]{c.getName(), e});
        }
    }

    public Class loadClass(String className) throws Fault {
        return TestSuite.loadClass(className, this.loader);
    }

    protected static Class loadClass(String className, ClassLoader cl) throws Fault {
        try {
            if (cl == null) {
                return Class.forName(className);
            }
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new Fault(i18n, "ts.classNotFound", new Object[]{className, e});
        }
        catch (IllegalArgumentException e) {
            throw new Fault(i18n, "ts.badClassName", new Object[]{className});
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public ServiceManager getServiceManager() {
        if (!this.needServices()) {
            return null;
        }
        if (this.serviceManager == null) {
            this.serviceManager = new ServiceManager(this);
        }
        return this.serviceManager;
    }

    public boolean needServices() {
        ServiceReader sr = this.getServiceReader();
        if (sr == null) {
            return false;
        }
        boolean isLegacy = false;
        try {
            Method m = sr.getClass().getMethod("getServiceDescriptorFileName", new Class[0]);
            if (Modifier.isAbstract(m.getModifiers())) {
                isLegacy = true;
            }
        }
        catch (NoSuchMethodException e) {
            isLegacy = true;
        }
        File descrFile = isLegacy ? new File(this.getRootDir(), File.separator + "lib" + File.separator + "services.xml") : new File(this.getRootDir(), sr.getServiceDescriptorFileName());
        return descrFile.exists();
    }

    public ServiceReader getServiceReader() {
        block7: {
            if (this.serviceReader != null) {
                return this.serviceReader;
            }
            String servInfo = (String)this.tsInfo.get("serviceReader");
            if (servInfo != null) {
                String[] args = servInfo.split(" ");
                try {
                    Class c = this.loadClass(args[0]);
                    this.serviceReader = (ServiceReader)TestSuite.newInstance(c);
                    if (args.length > 1) {
                        String[] copy = new String[args.length - 1];
                        for (int i = 1; i < args.length; ++i) {
                            copy[i - 1] = args[i];
                        }
                        this.serviceReader.init(this, copy);
                        break block7;
                    }
                    this.serviceReader.init(this, null);
                }
                catch (Fault fault) {}
            } else {
                this.serviceReader = new PropertyServiceReader();
                this.serviceReader.init(this, null);
            }
        }
        return this.serviceReader;
    }

    protected Map getTestSuiteInfo() {
        return this.tsInfo;
    }

    public String getTestSuiteInfo(String name) {
        if (this.tsInfo == null) {
            return null;
        }
        return (String)this.tsInfo.get(name);
    }

    public boolean getTestRefreshBehavior(int event) {
        switch (event) {
            case 0: {
                return Boolean.valueOf(this.getTestSuiteInfo("deleteNonExistTests"));
            }
            case 1: {
                return Boolean.valueOf(this.getTestSuiteInfo("refreshTestsOnRun"));
            }
            case 2: {
                return Boolean.valueOf(this.getTestSuiteInfo("clearChangedTests"));
            }
        }
        return false;
    }

    public Logger getNotificationLog(WorkDirectory wd) {
        return this.notifLogger;
    }

    public ObservedFile getObservedFile(WorkDirectory wd) {
        return this.getObservedFile(wd.getLogFileName());
    }

    public ObservedFile getObservedFile(String path) {
        String cPath = new File(path).getAbsolutePath();
        if (observedFiles.containsKey(cPath)) {
            return (ObservedFile)observedFiles.get(cPath);
        }
        return null;
    }

    void setLogFilePath(WorkDirectory wd) {
        ObservedFile f = new ObservedFile(wd.getLogFileName());
        if (f.length() != 0L) {
            f.backup();
        }
        f = new ObservedFile(wd.getLogFileName());
        if (observedFiles == null) {
            observedFiles = new HashMap();
        }
        if (!observedFiles.containsKey(f.getAbsolutePath())) {
            observedFiles.put(f.getAbsolutePath(), f);
        }
    }

    public Logger createLog(WorkDirectory wd, String b, String key) throws DuplicateLogNameFault {
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("Log name can not be empty");
        }
        String logName = wd.getLogFileName();
        if (gpls == null) {
            gpls = new Vector();
        }
        for (int i = 0; i < gpls.size(); ++i) {
            GeneralPurposeLogger gpl = gpls.get(i);
            if (!gpl.getName().equals(key) || !gpl.getLogFileName().equals(logName)) continue;
            throw new DuplicateLogNameFault(i18n, "ts.logger.duplicatelognamefault", key);
        }
        GeneralPurposeLogger gpl = new GeneralPurposeLogger(key, wd, b, this);
        gpls.add(gpl);
        return gpl;
    }

    public Logger getLog(WorkDirectory wd, String key) throws NoSuchLogFault {
        if (gpls == null) {
            throw new NoSuchLogFault(i18n, "ts.logger.nologscreated", key);
        }
        if (wd == null) {
            throw new NullPointerException(i18n.getString("ts.logger.nullwd"));
        }
        String logFile = wd.getLogFileName();
        for (int i = 0; i < gpls.size(); ++i) {
            GeneralPurposeLogger logger = gpls.get(i);
            if (!logger.getLogFileName().equals(logFile) || !logger.getName().equals(key)) continue;
            return logger;
        }
        throw new NoSuchLogFault(i18n, "ts.logger.nosuchlogfault", key);
    }

    public void eraseLog(WorkDirectory wd) throws IOException {
        if (wd == null) {
            throw new NullPointerException(i18n.getString("ts.logger.nullwd"));
        }
        if (gpls != null) {
            for (int i = 0; i < gpls.size(); ++i) {
                Handler[] h;
                GeneralPurposeLogger gpl = gpls.get(i);
                if (!gpl.getLogFileName().equals(wd.getLogFileName()) || !((h = gpl.getHandlers())[0] instanceof WorkDirLogHandler)) continue;
                ((WorkDirLogHandler)h[0]).eraseLogFile();
                return;
            }
        }
    }

    private static boolean isReadableFile(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    private static class GeneralPurposeLogger
    extends Logger {
        private String logFileName;

        private GeneralPurposeLogger(String name, WorkDirectory wd, String resourceBundleName, TestSuite ts) {
            super(name, resourceBundleName);
            this.logFileName = wd.getLogFileName();
            if (wd != null) {
                if (!handlersMap.containsKey(wd.getLogFileName())) {
                    WorkDirLogHandler wdlh = new WorkDirLogHandler(ts.getObservedFile(wd));
                    handlersMap.put(wd.getLogFileName(), wdlh);
                }
                this.addHandler((WorkDirLogHandler)handlersMap.get(wd.getLogFileName()));
            }
            this.setLevel(Level.ALL);
        }

        public void log(LogRecord record) {
            Handler[] targets = this.getHandlers();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    if (targets[i] instanceof WorkDirLogHandler) {
                        ((WorkDirLogHandler)targets[i]).publish(record, this.getName());
                        continue;
                    }
                    targets[i].publish(record);
                }
            }
        }

        private String getLogFileName() {
            return this.logFileName;
        }
    }

    private static class NotificationLogger
    extends Logger {
        private NotificationLogger(String resourceBundleName) {
            super(notificationLogName, resourceBundleName);
            this.setLevel(Level.CONFIG);
        }

        public synchronized void log(LogRecord record) {
            record.setLoggerName(this.getName());
            if (record.getThrown() != null) {
                record.setLevel(Level.INFO);
            }
            super.log(record);
        }

        public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
            LogRecord lr = new LogRecord(Level.INFO, "THROW");
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.log(lr);
        }
    }

    public static class NoSuchLogFault
    extends Fault {
        public NoSuchLogFault(I18NResourceBundle i18n, String s, String key) {
            super(i18n, s, key);
        }
    }

    public static class DuplicateLogNameFault
    extends Fault {
        public DuplicateLogNameFault(I18NResourceBundle i18n, String s, String key) {
            super(i18n, s, key);
        }
    }

    public static class NotTestSuiteFault
    extends Fault {
        public NotTestSuiteFault(I18NResourceBundle i18n, String s, File f) {
            super(i18n, s, f.getPath());
        }
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        public Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

