/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Vector;

public class TestEnvContext {
    private Map[] propTables;
    private String[] propTableNames;
    private String[] envNames;
    private String[] envMenuNames;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestEnvContext.class);
    private static boolean debug = Boolean.getBoolean("debug." + TestEnvContext.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestEnvContext(File[] files) throws Fault {
        Vector n = new Vector();
        Vector p = new Vector();
        try {
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    this.add(p, n, this.load(f), f.getPath());
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.propTables = new Map[p.size()];
            p.copyInto(this.propTables);
            this.propTableNames = new String[n.size()];
            n.copyInto(this.propTableNames);
            this.updateEnvTable();
            throw throwable;
        }
        this.propTables = new Map[p.size()];
        p.copyInto(this.propTables);
        this.propTableNames = new String[n.size()];
        n.copyInto(this.propTableNames);
        this.updateEnvTable();
    }

    public TestEnvContext(Map[] tables, String[] tableNames) {
        Vector n = new Vector();
        Vector p = new Vector();
        for (int i = 0; i < tables.length; ++i) {
            this.add(p, n, tables[i], tableNames[i]);
        }
        this.propTables = new Map[p.size()];
        p.copyInto(this.propTables);
        this.propTableNames = new String[n.size()];
        n.copyInto(this.propTableNames);
        this.updateEnvTable();
    }

    public TestEnvContext(Map table, String tableName) {
        Vector n = new Vector();
        Vector p = new Vector();
        this.add(p, n, table, tableName);
        this.propTables = new Map[p.size()];
        p.copyInto(this.propTables);
        this.propTableNames = new String[n.size()];
        n.copyInto(this.propTableNames);
        this.updateEnvTable();
    }

    public TestEnvironment getEnv(String name) throws TestEnvironment.Fault {
        if (this.isValidEnv(name)) {
            return new TestEnvironment(name, this.propTables, this.propTableNames);
        }
        return null;
    }

    public boolean isValidEnv(String name) {
        if (name.length() == 0) {
            return true;
        }
        for (int i = 0; i < this.envNames.length; ++i) {
            if (!this.envNames[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getEnvNames() {
        return this.envNames;
    }

    public String[] getEnvMenuNames() {
        return this.envMenuNames;
    }

    private Map load(File f) throws Fault {
        if (f == null) {
            return null;
        }
        try {
            Properties p = new Properties();
            BufferedReader in = new BufferedReader(new FileReader(f));
            p.load(in);
            ((Reader)in).close();
            return p;
        }
        catch (FileNotFoundException e) {
            throw new Fault(i18n, "tec.cantFindFile", f);
        }
        catch (IOException e) {
            throw new Fault(i18n, "tec.ioError", new Object[]{f, e});
        }
    }

    private void add(Vector pv, Vector nv, Map p, String n) {
        if (p != null) {
            pv.addElement(p);
            nv.addElement(n);
        }
    }

    private void updateEnvTable() {
        Object[] tables = this.propTables;
        Object[] tableNames = this.propTableNames;
        Object[] defaultTables = TestEnvironment.defaultPropTables;
        Object[] defaultTableNames = TestEnvironment.defaultPropTableNames;
        if (defaultTables != null && defaultTables.length > 0) {
            tables = (Map[])DynamicArray.join(defaultTables, tables);
            tableNames = (String[])DynamicArray.join(defaultTableNames, tableNames);
        }
        Vector allVec = new Vector();
        Vector menuExcludeVec = new Vector();
        String ENV_DOT = "env.";
        String DOT_DESCRIPTION = ".description";
        String DOT_FINDER = ".finder";
        String DOT_SCRIPT = ".script";
        String DOT_SCRIPT_DOT = ".script.";
        String DOT_INHERITS = ".inherits";
        String DOT_MENU = ".menu";
        String DOT_TESTSUITE = ".testsuite";
        if (debug) {
            System.err.println(this.getClass().getName() + ": trace");
        }
        for (int i = 0; i < tables.length; ++i) {
            if (debug) {
                System.err.println("Checking " + (String)tableNames[i] + " for environments...");
            }
            Object table = tables[i];
            for (String prop : table.keySet()) {
                String name = null;
                if (debug) {
                    System.err.println("Checking property " + prop);
                }
                if (!prop.startsWith("env.")) continue;
                if (prop.endsWith(".inherits")) {
                    name = prop.substring("env.".length(), prop.length() - ".inherits".length());
                } else if (prop.endsWith(".menu")) {
                    name = prop.substring("env.".length(), prop.length() - ".menu".length());
                    String value = (String)table.get(prop);
                    if ("false".equals(value)) {
                        this.sortedInsert(menuExcludeVec, name);
                    }
                } else if (prop.endsWith(".description")) {
                    name = prop.substring("env.".length(), prop.length() - ".description".length());
                } else if (prop.endsWith(".finder")) {
                    name = prop.substring("env.".length(), prop.length() - ".finder".length());
                } else if (prop.endsWith(".script")) {
                    name = prop.substring("env.".length(), prop.length() - ".script".length());
                } else if (prop.endsWith(".testsuite")) {
                    name = prop.substring("env.".length(), prop.length() - ".testsuite".length());
                } else {
                    int lastDot = prop.lastIndexOf(46);
                    int scriptStartIndex = lastDot - ".script.".length() + 1;
                    if (scriptStartIndex <= 0 || !prop.regionMatches(scriptStartIndex, ".script.", 0, ".script.".length())) continue;
                    name = prop.substring("env.".length(), scriptStartIndex);
                }
                if (debug) {
                    System.err.println("found environment name: " + name);
                }
                this.sortedInsert(allVec, name);
            }
        }
        this.envNames = new String[allVec.size()];
        allVec.copyInto(this.envNames);
        Vector menuVec = (Vector)allVec.clone();
        for (int i = 0; i < menuExcludeVec.size(); ++i) {
            menuVec.removeElement(menuExcludeVec.elementAt(i));
        }
        this.envMenuNames = new String[menuVec.size()];
        menuVec.copyInto(this.envMenuNames);
    }

    private void sortedInsert(Vector v, String s) {
        for (int i = 0; i < v.size(); ++i) {
            int c = s.compareTo((String)v.elementAt(i));
            if (c > 0) {
                v.insertElementAt(s, i);
                return;
            }
            if (c != 0) continue;
            return;
        }
        v.addElement(s);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

