/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChoiceArrayQuestionRenderer
implements QuestionRenderer {
    protected String[] displayChoices;
    protected boolean[] values;
    protected ChoiceArrayQuestion q;
    protected ActionListener editedListener;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    protected static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        this.q = (ChoiceArrayQuestion)qq;
        this.displayChoices = this.q.getDisplayChoices();
        this.values = this.q.getValue();
        this.editedListener = listener;
        return this.createChoiceTable();
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected JComponent createChoiceTable() {
        AbstractTableModel tm = this.createTableModel();
        JTable tbl = new JTable(tm);
        tbl.setPreferredScrollableViewportSize(new Dimension(DOTS_PER_INCH, DOTS_PER_INCH));
        tbl.setShowHorizontalLines(false);
        tbl.setShowVerticalLines(false);
        tbl.setTableHeader(null);
        tbl.setAutoResizeMode(3);
        tbl.setRowSelectionAllowed(false);
        tbl.setColumnSelectionAllowed(false);
        tbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        tbl.addKeyListener(this.createKeyListener(tm));
        TableColumn col0 = tbl.getColumnModel().getColumn(0);
        col0.setPreferredWidth(24);
        col0.setMaxWidth(24);
        col0.setResizable(false);
        TableColumn col1 = tbl.getColumnModel().getColumn(1);
        col1.setPreferredWidth(this.getColumnWidth(tbl, 1) + 20);
        JScrollPane sp = new JScrollPane(tbl);
        sp.setName("chcArr.sp");
        sp.getViewport().setBackground(tbl.getBackground());
        JLabel lbl = new JLabel(i18n.getString("chcArr.tbl.lbl"));
        lbl.setName("chcArr.tbl.lbl");
        lbl.setDisplayedMnemonic(i18n.getString("chcArr.tbl.mne").charAt(0));
        lbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        lbl.setLabelFor(sp);
        tbl.setRowHeight(this.getRowHeight());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)lbl, "North");
        result.add((Component)sp, "Center");
        return result;
    }

    protected int getColumnWidth(JTable table, int colIndex) {
        int width = -1;
        TableModel model = table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            TableCellRenderer r = table.getCellRenderer(i, colIndex);
            Component c = r.getTableCellRendererComponent(table, model.getValueAt(i, colIndex), false, false, i, colIndex);
            width = Math.max(width, c.getPreferredSize().width);
        }
        return width;
    }

    protected int getRowHeight() {
        return 22;
    }

    protected AbstractTableModel createTableModel() {
        return new TestTableModel();
    }

    protected KeyListener createKeyListener(AbstractTableModel tm) {
        return new TestKeyListener(tm);
    }

    protected void fireEditedEvent(Object src, ActionListener l) {
        ActionEvent e = new ActionEvent(src, 1001, "edited");
        l.actionPerformed(e);
    }

    protected class TestKeyListener
    extends KeyAdapter {
        protected AbstractTableModel tm;

        public TestKeyListener(AbstractTableModel tm) {
            this.tm = tm;
        }

        public void keyPressed(KeyEvent e) {
            if ((e.getModifiersEx() & 0x80) != 0) {
                if (e.getKeyCode() == 65) {
                    int i;
                    boolean allSelected = true;
                    for (i = 0; i < this.tm.getRowCount(); ++i) {
                        if (!this.tm.getValueAt(i, 0).equals(new Boolean(false))) continue;
                        allSelected = false;
                        break;
                    }
                    for (i = 0; i < this.tm.getRowCount(); ++i) {
                        this.tm.setValueAt(new Boolean(!allSelected), i, 0);
                        TableModelEvent ev = new TableModelEvent(this.tm, i, i, -1, 0);
                        this.tm.fireTableChanged(ev);
                    }
                }
            }
        }
    }

    protected class TestTableModel
    extends AbstractTableModel {
        protected TestTableModel() {
        }

        public Class getColumnClass(int c) {
            return c == 0 ? Boolean.class : String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ChoiceArrayQuestionRenderer.this.displayChoices.length;
        }

        public Object getValueAt(int r, int c) {
            return c == 0 ? new Boolean(ChoiceArrayQuestionRenderer.this.values[r]) : ChoiceArrayQuestionRenderer.this.displayChoices[r];
        }

        public void setValueAt(Object o, int r, int c) {
            if (c == 0) {
                ChoiceArrayQuestionRenderer.this.values[r] = (Boolean)o;
                ChoiceArrayQuestionRenderer.this.q.setValue(ChoiceArrayQuestionRenderer.this.values);
                ChoiceArrayQuestionRenderer.this.fireEditedEvent(this, ChoiceArrayQuestionRenderer.this.editedListener);
            }
        }

        public boolean isCellEditable(int r, int c) {
            return c == 0;
        }
    }
}

