/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InterviewSet
extends Interview {
    private NullQuestion sorter = new NullQuestion(this){

        public boolean isEnabled() {
            return false;
        }

        public Question getNext() {
            if (InterviewSet.this.sortedCalls == null) {
                Interview[] cc = InterviewSet.this.sortChildren();
                Question q = InterviewSet.this.qEnd;
                for (int i = cc.length - 1; i >= 0; --i) {
                    q = InterviewSet.this.callInterview(cc[i], q);
                }
                InterviewSet.this.sortedCalls = q;
            }
            return InterviewSet.this.sortedCalls;
        }
    };
    private FinalQuestion qEnd = new FinalQuestion(this);
    private List children = new ArrayList();
    private Map dependencies = new HashMap();
    private Question sortedCalls;

    protected InterviewSet(Interview parent, String baseTag) {
        super(parent, baseTag);
        this.setFirstQuestion(this.sorter);
    }

    void add(Interview child) {
        super.add(child);
        this.children.add(child);
        this.sortedCalls = null;
    }

    void add(Question q) {
        throw new UnsupportedOperationException();
    }

    protected void addDependency(Interview child, Interview dependency) throws CycleFault {
        if (child == null) {
            throw new NullPointerException();
        }
        if (dependency == null) {
            throw new NullPointerException();
        }
        Set allDeps = this.getAllDependencies(dependency);
        if (allDeps != null && allDeps.contains(child)) {
            throw new CycleFault(child, dependency);
        }
        Set deps = this.getDependencies(child, true);
        deps.add(dependency);
        this.sortedCalls = null;
    }

    protected void removeDependency(Interview child, Interview dependency) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (dependency == null) {
            throw new NullPointerException();
        }
        Set deps = this.getDependencies(child, false);
        if (deps != null) {
            deps.remove(dependency);
        }
        if (deps.size() == 0) {
            this.dependencies.remove(child);
        }
        this.sortedCalls = null;
    }

    private Set getDependencies(Interview child, boolean create) {
        TreeSet deps = (TreeSet)this.dependencies.get(child);
        if (deps == null && create) {
            deps = new TreeSet(new ChildComparator());
            this.dependencies.put(child, deps);
        }
        return deps;
    }

    private Set getAllDependencies(Interview child) {
        HashSet s = new HashSet();
        this.getAllDependencies(child, s);
        return s;
    }

    private void getAllDependencies(Interview child, Set s) {
        if (s.contains(child)) {
            return;
        }
        Set deps = this.getDependencies(child, false);
        if (deps != null) {
            for (Interview i : deps) {
                this.getAllDependencies(i, s);
                s.add(i);
            }
        }
    }

    private Interview[] sortChildren() {
        ArrayList list = new ArrayList();
        HashSet cycleSet = new HashSet();
        for (Interview child : this.children) {
            if (list.contains(child)) continue;
            this.addToList(list, child, cycleSet);
        }
        for (Interview i : list) {
            System.err.println(i.getTag() + " " + i);
        }
        return list.toArray(new Interview[list.size()]);
    }

    private void addToList(List list, Interview child, Set cycleSet) {
        if (cycleSet.contains(child)) {
            throw new IllegalArgumentException();
        }
        cycleSet.add(child);
        Set deps = (Set)this.dependencies.get(child);
        if (deps != null) {
            for (Interview dep : deps) {
                this.addToList(list, dep, cycleSet);
            }
        }
        list.add(child);
        cycleSet.remove(child);
    }

    private class ChildComparator
    implements Comparator {
        private ChildComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!InterviewSet.this.children.contains(o1) || !InterviewSet.this.children.contains(o2)) {
                throw new IllegalArgumentException();
            }
            if (o1 == o2) {
                return 0;
            }
            for (Object o : InterviewSet.this.children) {
                if (o == o1) {
                    return -1;
                }
                if (o != o2) continue;
                return 1;
            }
            throw new IllegalStateException();
        }
    }

    public static class CycleFault
    extends Interview.Fault {
        CycleFault(Interview dependent, Interview dependency) {
            super(Interview.i18n, "iset.cycle", new Object[]{dependent.getTag(), dependency.getTag()});
        }
    }
}

