/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.util;

import com.sun.tdk.jcov.util.RuntimeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class MapHelper {
    public static void mapCounts(String outputFile, String templateFile, long[] counts) throws Exception {
        String template = new File(outputFile).exists() ? outputFile : templateFile;
        MapHelper.map(outputFile, template, counts);
    }

    private static void map(String output, String templ, long[] counts) throws Exception {
        if (output.equals(templ)) {
            if (counts == null) {
                return;
            }
            String out_tmp = output + RuntimeUtils.genSuffix();
            MapHelper.mapXMLFast(out_tmp, templ, counts);
            File f_out = new File(output);
            f_out.delete();
            new File(out_tmp).renameTo(f_out);
        } else {
            MapHelper.mapXMLFast(output, templ, counts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapXMLFast(String result, String templ, long[] counts) throws Exception {
        MapHelper.checkTemplate(templ);
        FileInputStream is = new FileInputStream(templ);
        File outputFile = new File(result);
        if (!outputFile.getAbsoluteFile().getParentFile().exists()) {
            throw new Exception("Specified directory for output file doesn't exist - " + outputFile.getParentFile().getPath());
        }
        if (outputFile.exists() && !outputFile.canWrite()) {
            throw new Exception("Can't write output file");
        }
        if (outputFile.exists() && !outputFile.canRead()) {
            throw new Exception("Can't read output file");
        }
        FileOutputStream os = new FileOutputStream(outputFile, false);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, Charset.defaultCharset()));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, Charset.defaultCharset()));
        try {
            String s = r.readLine();
            while (s != null) {
                int i = s.indexOf("id=");
                if (i != -1 && counts != null) {
                    String res;
                    int id_end;
                    int id = 0;
                    long count = 0L;
                    if (counts[id = Integer.parseInt(s.substring(i += 4, id_end = s.indexOf("\"", i)))] == 0L) {
                        pw.println(s);
                    } else if (s.indexOf("count", i) > 0) {
                        i = id_end + 9;
                        res = s.substring(0, i);
                        int count_end = s.indexOf("\"", i);
                        count = Long.parseLong(s.substring(i, count_end));
                        res = res + (count += counts[id]);
                        res = res + s.substring(count_end);
                        pw.println(res);
                    } else {
                        res = s.substring(0, id_end + 1) + " count=\"" + counts[id] + "\"" + s.substring(id_end + 1);
                        pw.println(res);
                    }
                } else {
                    pw.println(s);
                }
                s = r.readLine();
            }
            pw.flush();
            Object var17_15 = null;
            pw.close();
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            pw.close();
            r.close();
            is.close();
            os.close();
            throw throwable;
        }
        r.close();
        is.close();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkTemplate(String templ) throws Exception {
        FileInputStream is = new FileInputStream(templ);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, Charset.defaultCharset()));
        try {
            String s = r.readLine();
            if (!"<?xml version='1.0' encoding='UTF-8'?>".equalsIgnoreCase(s)) {
                throw new RuntimeException(templ + " doesn't seem to be an XML file");
            }
            s = r.readLine();
            while (s != null && s.trim().length() == 0) {
                s = r.readLine();
            }
            if (s == null) {
                throw new RuntimeException(templ + " an empty XML file");
            }
            if (!s.startsWith("<coverage")) {
                throw new RuntimeException(templ + " not a jcov coverage file");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            r.close();
            is.close();
            throw throwable;
        }
        r.close();
        is.close();
    }
}

