/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

public class JcovStats {
    public static final String sccsVersion = "%I% $LastChangedDate: 2011-08-25 16:47:35 +0400 (Thu, 25 Aug 2011) $";
    public int methods_tot;
    public int methods_cov;
    public float method_cvg;
    public int blocks_tot;
    public int blocks_cov;
    public float block_cvg;
    public int branches_tot;
    public int branches_cov;
    public float branch_cvg;
    public static final int IND_MET_COV = 0;
    public static final int IND_MET_TOT = 1;
    public static final int IND_MET_CVG = 2;
    public static final int IND_BLO_COV = 3;
    public static final int IND_BLO_TOT = 4;
    public static final int IND_BLO_CVG = 5;
    public static final int IND_BRN_COV = 6;
    public static final int IND_BRN_TOT = 7;
    public static final int IND_BRN_CVG = 8;

    public void merge(JcovStats src) {
        this.blocks_tot += src.blocks_tot;
        this.blocks_cov += src.blocks_cov;
        this.branches_tot += src.branches_tot;
        this.branches_cov += src.branches_cov;
        this.methods_tot += src.methods_tot;
        this.methods_cov += src.methods_cov;
    }

    public void calculate() {
        this.block_cvg = this.blocks_tot != 0 ? (float)this.blocks_cov / (float)this.blocks_tot : 1.0f;
        this.branch_cvg = this.branches_tot != 0 ? (float)this.branches_cov / (float)this.branches_tot : 1.0f;
        this.method_cvg = this.methods_tot != 0 ? (float)this.methods_cov / (float)this.methods_tot : 1.0f;
    }

    public Object getNumber(int field_ind) {
        switch (field_ind) {
            case 0: {
                return this.methods_cov;
            }
            case 1: {
                return this.methods_tot;
            }
            case 2: {
                if (this.methods_tot > 0) {
                    return Float.valueOf((float)((int)((double)this.method_cvg * 100000.0)) / 1000.0f);
                }
                return "N/A";
            }
            case 3: {
                return this.blocks_cov;
            }
            case 4: {
                return this.blocks_tot;
            }
            case 5: {
                if (this.blocks_tot > 0) {
                    return Float.valueOf((float)((int)((double)this.block_cvg * 100000.0)) / 1000.0f);
                }
                return "N/A";
            }
            case 6: {
                return this.branches_cov;
            }
            case 7: {
                return this.branches_tot;
            }
            case 8: {
                if (this.branches_tot > 0) {
                    return Float.valueOf((float)((int)((double)this.branch_cvg * 100000.0)) / 1000.0f);
                }
                return "N/A";
            }
        }
        return null;
    }
}

