/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.FileHandler;

public abstract class JCovCMDTool
extends JCovTool {
    public final int run(String[] args) {
        String pluginsDir;
        File file;
        EnvHandler handler = this.defineHandler();
        if (this.readPlugins && (file = new File(pluginsDir = handler.getValue(EnvHandler.PLUGINDIR))).isDirectory() && file.canRead()) {
            File[] list = file.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            URL[] urls = new URL[list.length];
            for (int i = 0; i < list.length; ++i) {
                try {
                    urls[i] = list[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
            URLClassLoader urlCL = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            handler.setClassLoader(urlCL);
        }
        try {
            handler.parseCLIArgs(args);
            if (handler.isSet(EnvHandler.HELP)) {
                handler.usage();
                return 0;
            }
            if (handler.isSet(EnvHandler.HELP_VERBOSE)) {
                handler.usage(true);
                return 0;
            }
        }
        catch (EnvHandler.CLParsingException ex) {
            if (handler.isSet(EnvHandler.HELP)) {
                handler.usage();
                handler.getOut().println("\n Command line error: " + ex.getMessage() + "\n");
                return 1;
            }
            if (handler.isSet(EnvHandler.HELP_VERBOSE)) {
                handler.usage(true);
                handler.getOut().println("\n Command line error: " + ex.getMessage() + "\n");
                return 1;
            }
            handler.getOut().println(" Command line error: " + ex.getMessage() + "\n");
            String name = this.getClass().getName();
            handler.getOut().println("Use \"java -jar jcov.jar " + name.substring(name.lastIndexOf(".") + 1) + " -h\" for command-line help or \"java -jar jcov.jar " + name.substring(name.lastIndexOf(".") + 1) + " -hv\" for wider description");
            return 1;
        }
        if (handler.isSet(EnvHandler.LOGFILE)) {
            try {
                FileHandler fh = new FileHandler(handler.getValue(EnvHandler.LOGFILE));
                Utils.setLoggerHandler(fh);
            }
            catch (Exception ex) {
                handler.getOut().println("\n Error initializing logger: " + ex.getMessage() + "\n");
            }
        }
        if (handler.isSet(EnvHandler.LOGLEVEL)) {
            Utils.setLoggingLevel(handler.getValue(EnvHandler.LOGLEVEL));
        }
        try {
            handler.initializeSPIs();
        }
        catch (Exception ex) {
            handler.getOut().println("Service Provider initialization error: " + ex.getMessage() + "\n");
            if (handler.isSet(EnvHandler.PRINT_ENV)) {
                handler.printEnv();
            } else {
                handler.getOut().println("Use -print-env option to find where this Service Provider is set\n");
            }
            return 1;
        }
        int res = 0;
        try {
            res = this.handleEnv(handler);
        }
        catch (JCovTool.EnvHandlingException ex) {
            handler.getOut().println("Command line error: " + ex.getMessage() + "\n");
            String name = this.getClass().getName();
            handler.getOut().println("Use \"java -jar jcov.jar " + name.substring(name.lastIndexOf(".") + 1) + " -h\" for command-line help or \"java -jar jcov.jar " + name.substring(name.lastIndexOf(".") + 1) + " -hv\" for wider description");
            if (handler.isSet(EnvHandler.PRINT_ENV)) {
                handler.printEnv();
            }
            return 1;
        }
        if (handler.isSet(EnvHandler.PRINT_ENV)) {
            handler.printEnv();
            return 0;
        }
        if (res != 0) {
            handler.usage();
            return res;
        }
        try {
            return this.run();
        }
        catch (Exception e) {
            System.out.println("Execution error: " + e.getMessage());
            if (PropertyFinder.findValue("stacktrace", "false").equals("true")) {
                e.printStackTrace(System.out);
            }
            return 2;
        }
    }

    protected abstract int run() throws Exception;
}

