/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.CollectDetect;
import com.sun.tdk.jcov.runtime.JCovSaver;
import com.sun.tdk.jcov.runtime.JCovXMLFileSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;

public abstract class FileSaver
implements JCovSaver {
    static final int LOCK_REPEAT = 50;
    static final int LOCK_SLEEP = 50000;
    protected String filename;
    protected String template;
    protected InstrumentationOptions.MERGE mergeMode;
    protected boolean insertOnly;
    protected DataRoot root;
    protected boolean scales;
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    protected boolean agentdata = false;

    protected static File createLockFile(String filename) {
        if (isWindows) {
            return null;
        }
        for (int i = 50; i != 0; --i) {
            String lockName = filename + ".lock";
            File fl = new File(lockName);
            try {
                if (fl.createNewFile()) {
                    return fl;
                }
                Thread.sleep(50000L);
                continue;
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    protected static void deleteLock(File lock) {
        if (isWindows) {
            return;
        }
        if (lock != null) {
            lock.delete();
        }
    }

    protected static String genUniqFileName(String filename) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (new File(filename + "." + i).exists()) continue;
            return filename + "." + i;
        }
        throw new Error("It's impossible...");
    }

    protected FileSaver(DataRoot root, InstrumentationOptions.MERGE merge) {
        this.filename = "result.xml";
        this.template = "template.xml";
        this.mergeMode = merge;
        this.root = root;
        this.scales = merge == InstrumentationOptions.MERGE.SCALE;
    }

    protected FileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean scales) {
        this.filename = filename;
        this.template = template;
        this.mergeMode = merge;
        this.root = root;
        this.scales = scales;
    }

    public abstract void saveResults(String var1) throws Exception;

    abstract void mergeResults(String var1, String var2, boolean var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveResults() {
        block14: {
            block13: {
                block12: {
                    if (this.root.getParams().isDynamicCollect() && Collect.enabled) {
                        CollectDetect.enterInstrumentationCode();
                    }
                    try {
                        try {
                            if (this.mergeMode.equals((Object)InstrumentationOptions.MERGE.GEN_SUFF)) {
                                this.try2MergeAndSave(this.filename + RuntimeUtils.genSuffix(), this.template, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
                                Object var7_1 = null;
                                if (!this.root.getParams().isDynamicCollect()) return;
                                if (!Collect.enabled) return;
                                break block12;
                            }
                            if (new File(this.filename).exists() && !this.mergeMode.equals((Object)InstrumentationOptions.MERGE.OVERWRITE)) {
                                File lock = FileSaver.createLockFile(this.filename);
                                try {
                                    this.try2MergeAndSave(this.filename, this.filename, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
                                    Object var3_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var3_10 = null;
                                    FileSaver.deleteLock(lock);
                                    throw throwable;
                                }
                                FileSaver.deleteLock(lock);
                                break block13;
                            }
                            File lock = FileSaver.createLockFile(this.filename);
                            try {
                                this.try2MergeAndSave(this.filename, this.template, this.scales || this.mergeMode == InstrumentationOptions.MERGE.SCALE);
                                Object var5_12 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_13 = null;
                                FileSaver.deleteLock(lock);
                                throw throwable;
                            }
                            FileSaver.deleteLock(lock);
                            break block14;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Object var7_4 = null;
                            if (!this.root.getParams().isDynamicCollect()) return;
                            if (!Collect.enabled) return;
                            CollectDetect.leaveInstrumentationCode();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_5 = null;
                        if (!this.root.getParams().isDynamicCollect()) throw throwable;
                        if (!Collect.enabled) throw throwable;
                        CollectDetect.leaveInstrumentationCode();
                        throw throwable;
                    }
                }
                CollectDetect.leaveInstrumentationCode();
                return;
            }
            Object var7_2 = null;
            if (!this.root.getParams().isDynamicCollect()) return;
            if (!Collect.enabled) return;
            CollectDetect.leaveInstrumentationCode();
            return;
        }
        Object var7_3 = null;
        if (!this.root.getParams().isDynamicCollect()) return;
        if (!Collect.enabled) return;
        CollectDetect.leaveInstrumentationCode();
    }

    private void try2MergeAndSave(String filename, String mergeSrc, boolean scales) throws Exception {
        boolean srcExists;
        boolean bl = srcExists = mergeSrc != null && new File(mergeSrc).exists();
        if (srcExists) {
            this.mergeResults(filename, mergeSrc, scales);
        } else {
            this.saveResults(filename);
        }
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge) {
        return FileSaver.getFileSaver(root, filename, template, merge, false, false);
    }

    public void setAgentData(boolean agentdata) {
        this.agentdata = agentdata;
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean agentData) {
        FileSaver fileSaver = FileSaver.getFileSaver(root, filename, template, merge, false, false);
        fileSaver.agentdata = agentData;
        return fileSaver;
    }

    public static FileSaver getFileSaver(DataRoot root, boolean insertOnly) {
        return FileSaver.getFileSaver(root, "result.xml", "template.xml", InstrumentationOptions.MERGE.MERGE, insertOnly, false);
    }

    public static FileSaver getFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean insertOnly, boolean scales) {
        JCovXMLFileSaver saver = new JCovXMLFileSaver(root, filename, template, merge, scales);
        saver.insertOnly = insertOnly;
        return saver;
    }

    public static void setDisableAutoSave(boolean flag) {
        Collect.saveAtShutdownEnabled = !flag;
    }

    public static void addAutoShutdownSave() {
        PropertyFinder.addAutoShutdownSave();
    }
}

