/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.javap;

import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.io.ClassSignatureFilter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.report.javap.JavapClass;
import com.sun.tdk.jcov.report.javap.JavapCodeLine;
import com.sun.tdk.jcov.report.javap.JavapLine;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavapRepGen {
    private String[] include;
    private String[] exclude;

    public JavapRepGen(String[] include, String[] exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = ".*";
        } else {
            stringArray2 = this.include = include;
        }
        if (exclude == null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "";
        } else {
            stringArray = exclude;
        }
        this.exclude = stringArray;
    }

    private void finder(File root, List<File> result) {
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(".class")) continue;
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.finder(file, result);
            }
        }
    }

    public void run(String templatePath, String classesPath, String outPath) {
        JavapClass javapClass;
        DataRoot file_image = null;
        ClassSignatureFilter acceptor = new ClassSignatureFilter(null, null, null);
        try {
            file_image = Reader.readXML(templatePath, false, (MemberFilter)acceptor);
        }
        catch (FileFormatException ex) {
            Logger.getLogger(JavapRepGen.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (classesPath == null) {
            System.out.println("no input classes specified");
            return;
        }
        ArrayList<File> classFiles = new ArrayList<File>();
        ArrayList<String> classFilesInJar = new ArrayList<String>();
        File rootFile = new File(classesPath);
        HashMap<String, JavapClass> classes = new HashMap<String, JavapClass>();
        if (rootFile.isDirectory()) {
            this.finder(rootFile, classFiles);
        } else if (rootFile.isFile()) {
            String extension = "";
            int i = rootFile.getName().lastIndexOf(46);
            if (i > 0) {
                extension = rootFile.getName().substring(i + 1);
            }
            if ("class".equals(extension)) {
                classFiles.add(rootFile);
            } else {
                try {
                    JarFile jarFile = new JarFile(rootFile);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        classFilesInJar.add(entry.getName().replaceAll("/", ".").replace("\\", ".").substring(0, entry.getName().lastIndexOf(".class")));
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if (classFiles.isEmpty() && classFilesInJar.isEmpty()) {
            System.out.println("no .class files found at the specified path: " + classesPath);
            return;
        }
        this.filterClasses(classFiles, classesPath);
        this.filterClassesInJar(classFilesInJar);
        for (File classFile : classFiles) {
            javapClass = new JavapClass();
            javapClass.parseJavapFile(classFile.getAbsolutePath(), null);
            classes.put(javapClass.getClassName(), javapClass);
        }
        for (String classFileInJar : classFilesInJar) {
            javapClass = new JavapClass();
            javapClass.parseJavapFile(classFileInJar, rootFile.getAbsolutePath());
            classes.put(javapClass.getClassName(), javapClass);
        }
        for (DataClass dataClass : file_image.getClasses()) {
            for (DataMethod dataMethod : dataClass.getMethods()) {
                ArrayList<Integer> visitedBlocksNumbers = new ArrayList<Integer>();
                for (DataBlock dataBlock : dataMethod.getBlocks()) {
                    if (dataBlock.getCount() <= 0L) continue;
                    for (int index = dataBlock.startBCI(); index <= dataBlock.endBCI(); ++index) {
                        visitedBlocksNumbers.add(index);
                    }
                }
                for (DataBranch dataBranch : dataMethod.getBranches()) {
                    for (DataBlockTarget dataBranchTarget : dataBranch.getBranchTargets()) {
                        if (dataBranchTarget.getCount() <= 0L) continue;
                        for (int index = dataBranchTarget.startBCI(); index <= dataBranchTarget.endBCI(); ++index) {
                            visitedBlocksNumbers.add(index);
                        }
                    }
                }
                List<JavapLine> methodLines = null;
                JavapClass javapClass2 = (JavapClass)classes.get(dataClass.getName());
                if (javapClass2 != null) {
                    methodLines = javapClass2.getMethod(dataMethod.getName() + dataMethod.getVmSignature());
                }
                if (methodLines == null) continue;
                for (JavapLine javapLine : methodLines) {
                    if (!(javapLine instanceof JavapCodeLine) || !visitedBlocksNumbers.contains(((JavapCodeLine)javapLine).getCodeNumber())) continue;
                    ((JavapCodeLine)javapLine).setVisited(true);
                }
            }
        }
        RepGen rg = new RepGen();
        rg.configure(null, null, null, null, false, false, false, false, false, false, false, false);
        try {
            Result res = new Result(templatePath);
            rg.generateReport(rg.getDefaultReportGenerator(), outPath, res, null, new ArrayList<JavapClass>(classes.values()));
        }
        catch (Exception e) {
            System.err.println("error in report generation: " + e);
        }
    }

    private void filterClasses(ArrayList<File> files, String classesPath) {
        ArrayList<File> newFiles = new ArrayList<File>();
        if (files.size() > 1) {
            for (File classFile : files) {
                String className = classFile.getAbsolutePath();
                if (classFile.getAbsolutePath().startsWith(classesPath + File.separator)) {
                    className = className.substring(classesPath.length() + 1);
                }
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.lastIndexOf(".class"));
                }
                if (!Utils.accept(Utils.concatFilters(this.include, this.exclude), null, "/" + className, null)) continue;
                newFiles.add(classFile);
            }
            files.clear();
            files.addAll(newFiles);
        }
    }

    private void filterClassesInJar(ArrayList<String> filesInJar) {
        ArrayList<String> newFilesInJar = new ArrayList<String>();
        for (String classFile : filesInJar) {
            if (!Utils.accept(Utils.concatFilters(this.include, this.exclude), null, "/" + classFile.replaceAll("\\.", "/"), null)) continue;
            newFilesInJar.add(classFile);
        }
        filesInJar.clear();
        filesInJar.addAll(newFilesInJar);
    }
}

