/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.report.ProductCoverage;
import com.sun.tdk.jcov.report.SmartTestService;
import com.sun.tdk.jcov.report.javap.JavapClass;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface ReportGenerator {
    public void init(String var1) throws IOException;

    public void generateReport(ProductCoverage var1, Options var2) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Options {
        private String srcRootPath;
        private String[] srcRootPaths;
        private SmartTestService testListService;
        private List<JavapClass> classes;
        private boolean withTestsInfo;
        private boolean mergeRepGenMode;
        private InstrumentationOptions.InstrumentationMode mode;
        private boolean anonym = false;

        public Options() {
            this.srcRootPath = null;
            this.srcRootPaths = null;
            this.testListService = null;
        }

        public Options(String srcRootPath, SmartTestService testListService, List<JavapClass> classes, boolean withTestInfo, boolean mergeRepGenMode) {
            this.withTestsInfo = withTestInfo;
            this.mergeRepGenMode = mergeRepGenMode;
            this.classes = classes;
            this.srcRootPath = srcRootPath;
            this.testListService = testListService;
            this.srcRootPaths = srcRootPath != null ? Utils.getSourcePaths(srcRootPath) : null;
        }

        public List<JavapClass> getJavapClasses() {
            return this.classes;
        }

        public String getSrcRootPath() {
            return this.srcRootPath;
        }

        public String[] getSrcRootPaths() {
            return this.srcRootPaths;
        }

        public void setSrcRootPaths(String[] srcRootPaths) {
            this.srcRootPaths = srcRootPaths;
            this.srcRootPath = "";
            if (srcRootPaths.length > 0) {
                for (int i = 0; i < srcRootPaths.length - 1; ++i) {
                    this.srcRootPath = this.srcRootPath + srcRootPaths[i] + File.pathSeparatorChar;
                }
                this.srcRootPath = this.srcRootPath + srcRootPaths[srcRootPaths.length - 1];
            }
        }

        public SmartTestService getTestListService() {
            return this.testListService;
        }

        public void setSrcRootPath(String srcRootPath) {
            this.srcRootPath = srcRootPath;
            if (srcRootPath != null) {
                this.srcRootPaths = Utils.getSourcePaths(srcRootPath);
            }
        }

        public void setTestListService(SmartTestService testListService) {
            this.testListService = testListService;
        }

        public boolean isWithTestsInfo() {
            return this.withTestsInfo;
        }

        public boolean isMergeRepGenMode() {
            return this.mergeRepGenMode;
        }

        public void setInstrMode(InstrumentationOptions.InstrumentationMode mode) {
            this.mode = mode;
        }

        public InstrumentationOptions.InstrumentationMode getInstrMode() {
            return this.mode;
        }

        public void setAnonymOn(boolean anonym) {
            this.anonym = anonym;
        }

        public boolean isAnonymOn() {
            return this.anonym;
        }
    }
}

