/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.PackageCoverage;
import com.sun.tdk.jcov.report.javap.JavapClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCoverage
extends AbstractCoverage
implements Iterable<PackageCoverage> {
    private ArrayList<PackageCoverage> packages;
    private DataType[] supportedColumns = new DataType[]{DataType.CLASS, DataType.METHOD, DataType.FIELD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};
    private ArrayList<ClassCoverage> classes;
    private String productName;

    public ProductCoverage(String filename) throws FileFormatException {
        this(ProductCoverage.readFileImage(filename, true), null, null, null, true);
    }

    public ProductCoverage(String filename, String[] srcPaths) throws FileFormatException {
        this(ProductCoverage.readFileImage(filename, true), srcPaths, null, null, true);
    }

    public ProductCoverage(String filename, boolean readScales, String[] srcPaths) throws FileFormatException {
        this(ProductCoverage.readFileImage(filename, readScales), srcPaths, null, null, true);
    }

    public ProductCoverage(String filename, boolean readScales) throws FileFormatException {
        this(ProductCoverage.readFileImage(filename, readScales), null, null, null, true);
    }

    public ProductCoverage(String filename, boolean readScales, String[] srcPaths, CoverageFilter filter) throws FileFormatException {
        this(Reader.readXML(filename, readScales, (MemberFilter)filter), srcPaths, null, filter, true);
    }

    public ProductCoverage(String filename, boolean readScales, String[] srcPaths, boolean isPublicAPI, boolean noAbstract) throws FileFormatException {
        this(ProductCoverage.readFileImage(filename, readScales), srcPaths, null, new DefaultFilter(isPublicAPI, noAbstract), true);
    }

    public ProductCoverage(DataRoot fileImage) {
        this(fileImage, null, null, null, false);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcPaths) {
        this(fileImage, srcPaths, null, null, false);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcRootPaths, List<JavapClass> javapClasses, boolean isPublicAPI, boolean noAbstract) {
        this(fileImage, srcRootPaths, javapClasses, new DefaultFilter(noAbstract, isPublicAPI), false, false);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcRootPaths, List<JavapClass> javapClasses, boolean isPublicAPI, boolean noAbstract, boolean anonym) {
        this(fileImage, srcRootPaths, javapClasses, new DefaultFilter(noAbstract, isPublicAPI), false, anonym);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcRootPaths, CoverageFilter filter) {
        this(fileImage, srcRootPaths, null, filter, false);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcRootPaths, List<JavapClass> javapClasses, CoverageFilter filter, boolean releaseAfter) {
        this(fileImage, srcRootPaths, null, filter, false, false);
    }

    public ProductCoverage(DataRoot fileImage, String[] srcRootPaths, List<JavapClass> javapClasses, CoverageFilter filter, boolean releaseAfter, boolean anonym) {
        this.packages = new ArrayList();
        this.classes = new ArrayList();
        if (filter == null) {
            filter = new DefaultFilter(false, false);
        }
        List<DataPackage> packs = fileImage.getPackages();
        ArrayList<String> packageNames = new ArrayList<String>(packs.size());
        for (DataPackage p : packs) {
            packageNames.add(p.getName());
        }
        Collections.sort(packageNames);
        for (String pkg : packageNames) {
            PackageCoverage pc = new PackageCoverage(fileImage, pkg, srcRootPaths, javapClasses, filter, anonym);
            List<ClassCoverage> pkgClasses = pc.getClasses();
            this.classes.addAll(pkgClasses);
            if (!filter.accept(pc)) continue;
            this.packages.add(pc);
        }
        if (releaseAfter) {
            fileImage.destroy();
        }
    }

    private static DataRoot readFileImage(String filename, boolean useScales) throws FileFormatException {
        return Reader.readXML(filename, useScales, null);
    }

    @Override
    public DataType getDataType() {
        return DataType.PRODUCT;
    }

    public List<PackageCoverage> getPackages() {
        return this.packages;
    }

    @Override
    public Iterator<PackageCoverage> iterator() {
        return this.packages.iterator();
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        CoverageData covered = new CoverageData(0, 0);
        switch (column) {
            case PACKAGE: {
                for (PackageCoverage pCoverage : this.packages) {
                    covered.add(pCoverage.getData(column));
                }
                return covered;
            }
            case CLASS: 
            case METHOD: 
            case FIELD: 
            case BLOCK: 
            case BRANCH: 
            case LINE: {
                for (ClassCoverage classCoverage : this.classes) {
                    if (testNumber < 0 || classCoverage.isCoveredByTest(testNumber)) {
                        covered.add(classCoverage.getData(column));
                        continue;
                    }
                    covered.add(new CoverageData(0, classCoverage.getData(column).getTotal()));
                }
                return covered;
            }
        }
        return new CoverageData();
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    public void setName(String name) {
        this.productName = name;
    }

    @Override
    public String getName() {
        return this.productName == null ? "" : this.productName;
    }

    @Override
    public boolean isCovered() {
        for (ClassCoverage c : this.classes) {
            if (!c.isCovered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCoveredByTest(int testnum) {
        for (ClassCoverage c : this.classes) {
            if (!c.isCoveredByTest(testnum)) continue;
            return true;
        }
        return false;
    }

    public static abstract class CoverageFilter
    implements MemberFilter {
        public abstract boolean accept(ClassCoverage var1);

        public abstract boolean accept(PackageCoverage var1);
    }

    public static class DefaultFilter
    extends CoverageFilter {
        private boolean noAbstract;
        private boolean isPublicAPI;

        public DefaultFilter(boolean noAbstract, boolean isPublicAPI) {
            this.noAbstract = noAbstract;
            this.isPublicAPI = isPublicAPI;
        }

        public boolean accept(DataClass clz) {
            return true;
        }

        public boolean accept(DataClass clz, DataMethod m) {
            return !(this.noAbstract && m.isAbstract() || this.isPublicAPI && !m.isPublicAPI());
        }

        public boolean accept(DataClass clz, DataField f) {
            return !this.isPublicAPI || f.isPublicAPI();
        }

        public boolean accept(ClassCoverage cc) {
            return !(!cc.isPublicAPI() && this.isPublicAPI || cc.isEmpty() && this.noAbstract);
        }

        public boolean accept(PackageCoverage cc) {
            return !cc.isEmpty();
        }
    }
}

