/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.CoverageData;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineCoverage
extends CoverageData {
    final HashMap<Long, Boolean> lines_hits = new HashMap();

    public boolean isLineCovered(long lineNum) {
        Boolean isHit = this.lines_hits.get(lineNum);
        return isHit != null && isHit != false;
    }

    public boolean isCode(long lineNum) {
        return this.lines_hits.get(lineNum) != null;
    }

    void processLineTable(List<DataMethod.LineEntry> lineTable) {
        if (lineTable == null) {
            return;
        }
        for (DataMethod.LineEntry le : lineTable) {
            ++this.total;
            this.lines_hits.put(Long.valueOf(le.line), false);
        }
    }

    public void hitLine(long line) {
        boolean was;
        Boolean wasHit = this.lines_hits.get(line);
        if (wasHit != null && !(was = this.lines_hits.put(line, true).booleanValue())) {
            ++this.covered;
        }
    }

    private void hitLine(long line, boolean isHit) {
        Boolean wasHit = this.lines_hits.get(line);
        if (wasHit != null) {
            if (!wasHit.booleanValue() && isHit) {
                ++this.covered;
            } else if (wasHit.booleanValue() && !isHit) {
                --this.covered;
            }
            this.lines_hits.put(line, isHit || wasHit != false);
        } else {
            if (isHit) {
                ++this.covered;
            }
            ++this.total;
            this.lines_hits.put(line, isHit);
        }
    }

    void processLineCoverage(LineCoverage lineCov) {
        for (long line : lineCov.lines_hits.keySet()) {
            this.hitLine(line, lineCov.lines_hits.get(line));
        }
    }

    public long firstLine() {
        long firstLine = -1L;
        for (long lineNum : this.lines_hits.keySet()) {
            if (firstLine >= 0L && lineNum >= firstLine) continue;
            firstLine = lineNum;
        }
        return firstLine < 0L ? 1L : firstLine;
    }

    public long lastLine() {
        long lastLine = -1L;
        for (long lineNum : this.lines_hits.keySet()) {
            if (lastLine >= 0L && lineNum <= lastLine) continue;
            lastLine = lineNum;
        }
        return lastLine < 0L ? 1L : lastLine;
    }
}

