/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;

public abstract class ItemCoverage
extends AbstractCoverage {
    protected final int startLine;
    protected final int endLine;
    protected long count;
    private int srcLine = -1;
    protected Scale scale;

    public static ItemCoverage createBlockCoverageItem(DataBlock b) {
        return ItemCoverage.createBlockCoverageItem(b.startBCI(), b.endBCI(), b.getCount(), b.getScale());
    }

    public static ItemCoverage createBlockCoverageItem(int startBCI, int endBCI, long cnt) {
        return new BlockCoverage(startBCI, endBCI, cnt, null);
    }

    public static ItemCoverage createBlockCoverageItem(int startBCI, int endBCI, long cnt, Scale scale) {
        return new BlockCoverage(startBCI, endBCI, cnt, scale);
    }

    public static ItemCoverage createBranchCoverageItem(DataBlock b) {
        return ItemCoverage.createBranchCoverageItem(b.startBCI(), b.endBCI(), b.getCount(), b.getScale());
    }

    public static ItemCoverage createBranchCoverageItem(int startBCI, int endBCI, long cnt) {
        return new BranchCoverage(startBCI, endBCI, cnt, null);
    }

    public static ItemCoverage createBranchCoverageItem(int startBCI, int endBCI, long cnt, Scale scale) {
        return new BranchCoverage(startBCI, endBCI, cnt, scale);
    }

    protected ItemCoverage(int startLine, int endLine, long count, Scale scale) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.count = count;
        this.scale = scale;
    }

    protected void setSrcLine(int srcLine) {
        this.srcLine = srcLine;
    }

    public int getSourceLine() {
        return this.srcLine;
    }

    public long getCount() {
        return this.count;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public abstract boolean isBlock();

    public boolean isCovered() {
        return this.count > 0L;
    }

    public boolean isCoveredByTest(int testnum) {
        return this.scale != null && this.scale.isBitSet(testnum);
    }

    public String toString() {
        String b = this.isBlock() ? "BLOCK  " : "BRANCH ";
        return b + this.startLine + ":" + this.endLine + "   " + this.count;
    }

    public static DataType[] getAllPossibleTypes() {
        return new DataType[]{DataType.BLOCK, DataType.BRANCH};
    }

    private static class BranchCoverage
    extends ItemCoverage {
        private BranchCoverage(int startBCI, int endBCI, long cnt, Scale scale) {
            super(startBCI, endBCI, cnt, scale);
        }

        public DataType getDataType() {
            return DataType.BRANCH;
        }

        protected DataType[] getDataTypes() {
            return new DataType[]{DataType.BRANCH};
        }

        public CoverageData getData(DataType column) {
            return this.getData(column, -1);
        }

        public CoverageData getData(DataType column, int testNumber) {
            switch (column) {
                case BRANCH: {
                    return new CoverageData(this.count == 0L ? 0 : 1, 1);
                }
            }
            return new CoverageData();
        }

        public String getName() {
            return "branch";
        }

        public boolean isBlock() {
            return false;
        }
    }

    private static class BlockCoverage
    extends ItemCoverage {
        private BlockCoverage(DataBlock dataBlock) {
            this(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale());
        }

        private BlockCoverage(int startBCI, int endBCI, long cnt, Scale scale) {
            super(startBCI, endBCI, cnt, scale);
        }

        public DataType getDataType() {
            return DataType.BLOCK;
        }

        protected DataType[] getDataTypes() {
            return new DataType[]{DataType.BLOCK};
        }

        public CoverageData getData(DataType column) {
            return this.getData(column, -1);
        }

        public CoverageData getData(DataType column, int testNumber) {
            switch (column) {
                case BLOCK: {
                    return new CoverageData(this.count == 0L ? 0 : 1, 1);
                }
            }
            return new CoverageData();
        }

        public String getName() {
            return "block";
        }

        public boolean isBlock() {
            return true;
        }
    }
}

