/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.ant.AntableSPI;
import com.sun.tdk.jcov.report.ReportGenerator;
import com.sun.tdk.jcov.report.ReportGeneratorSPI;
import com.sun.tdk.jcov.report.html.CoverageReport;
import com.sun.tdk.jcov.report.text.TextReportGenerator;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.EnvServiceProvider;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;

public class DefaultReportGeneratorSPI
implements ReportGeneratorSPI,
AntableSPI,
EnvServiceProvider {
    protected CoverageReport html = null;
    protected TextReportGenerator txt = null;
    protected boolean showMethods = true;
    protected boolean showBlocks = true;
    protected boolean showBranches = true;
    protected boolean showLines = true;
    protected boolean generateShortFormat;
    protected boolean showFields;
    protected static final OptionDescr DSC_SHORT = new OptionDescr("short", "Additional filtering", "Generate short summary text report.");
    protected static final OptionDescr DSC_NO_METHOD = new OptionDescr("nomethod", "Additional filtering", "Hide method coverage from report");
    protected static final OptionDescr DSC_NO_FIELD = new OptionDescr("nofields", "Additional filtering", "Hide field coverage from report");
    protected static final OptionDescr DSC_NO_BRANCH = new OptionDescr("nobranch", "Additional filtering", "Hide branch coverage from report");
    protected static final OptionDescr DSC_NO_BLOCK = new OptionDescr("noblock", "Additional filtering", "Hide block coverage from report");
    protected static final OptionDescr DSC_NO_LINE = new OptionDescr("noline", "Additional filtering", "Hide line coverage from report");

    public ReportGenerator getReportGenerator(String name) {
        if ("txt".equalsIgnoreCase(name) || "text".equalsIgnoreCase(name)) {
            if (this.txt == null) {
                this.txt = new TextReportGenerator();
            }
            this.txt.setGenerateShortFormat(this.generateShortFormat);
            this.txt.setShowMethods(this.showMethods);
            this.txt.setShowBlocks(this.showBlocks);
            this.txt.setShowBranches(this.showBranches);
            this.txt.setShowFields(this.showFields);
            this.txt.setShowLines(this.showLines);
            return this.txt;
        }
        if ("html".equalsIgnoreCase(name)) {
            if (this.html == null) {
                this.html = new CoverageReport();
            }
            this.html.setShowMethods(this.showMethods);
            this.html.setShowBlocks(this.showBlocks);
            this.html.setShowBranches(this.showBranches);
            this.html.setShowLines(this.showLines);
            return this.html;
        }
        return null;
    }

    public void extendEnvHandler(EnvHandler handler) {
        handler.addOptions(new OptionDescr[]{DSC_NO_BLOCK, DSC_NO_BRANCH, DSC_NO_LINE, DSC_NO_METHOD, DSC_NO_FIELD, DSC_SHORT});
    }

    public int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        this.showMethods = !opts.isSet(DSC_NO_METHOD);
        this.showFields = !opts.isSet(DSC_NO_FIELD);
        this.showBlocks = !opts.isSet(DSC_NO_BLOCK);
        this.showBranches = !opts.isSet(DSC_NO_BRANCH);
        this.showLines = !opts.isSet(DSC_NO_LINE);
        this.generateShortFormat = opts.isSet(DSC_SHORT);
        return 0;
    }

    public boolean handleAttribute(String attrName, String attrValue) {
        if ("hideMethods".equalsIgnoreCase(attrName)) {
            this.showMethods = !Boolean.parseBoolean(attrValue);
            return true;
        }
        if ("hideBlocks".equalsIgnoreCase(attrName)) {
            this.showBlocks = !Boolean.parseBoolean(attrValue);
            return true;
        }
        if ("hideBranches".equalsIgnoreCase(attrName)) {
            this.showBranches = !Boolean.parseBoolean(attrValue);
            return true;
        }
        if ("hideLines".equalsIgnoreCase(attrName)) {
            this.showLines = !Boolean.parseBoolean(attrValue);
            return true;
        }
        if ("short".equalsIgnoreCase(attrName)) {
            this.generateShortFormat = Boolean.parseBoolean(attrValue);
            return true;
        }
        if ("hideFields".equalsIgnoreCase(attrName)) {
            this.showFields = !Boolean.parseBoolean(attrValue);
            return true;
        }
        return false;
    }
}

