/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.processing;

import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataMethodEntryOnly;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.processing.DataProcessor;
import com.sun.tdk.jcov.processing.ProcessingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinerDataProcessor
implements DataProcessor {
    @Override
    public DataRoot process(DataRoot root) throws ProcessingException {
        HashMap<String, ArrayList<DataClass>> classesMap = new HashMap<String, ArrayList<DataClass>>();
        DataRoot result = new DataRoot(root.getParams());
        result.setScaleOpts(root.getScaleOpts());
        List<DataPackage> allPkg = root.getPackages();
        for (DataPackage pkg : allPkg) {
            for (DataClass cls : pkg.getClasses()) {
                String srcName = cls.getSource();
                if (srcName != null) {
                    String key = pkg.getName() + '/' + srcName;
                    ArrayList<DataClass> srcClasses = (ArrayList<DataClass>)classesMap.get(key);
                    if (srcClasses == null) {
                        srcClasses = new ArrayList<DataClass>();
                        classesMap.put(key, srcClasses);
                    }
                    srcClasses.add(cls);
                    continue;
                }
                result.addClass(cls);
            }
        }
        for (String key : classesMap.keySet()) {
            ArrayList toMerge = (ArrayList)classesMap.get(key);
            if (toMerge.size() == 1) {
                result.addClass((DataClass)toMerge.get(0));
                continue;
            }
            int k = key.indexOf(".");
            String mainClassName = k > 0 ? key.substring(0, k) : key;
            DataClass cls = this.findMainClazz(toMerge, mainClassName);
            DataClass newClass = cls.clone(result.rootId());
            k = mainClassName.lastIndexOf("/");
            if (k > 0) {
                mainClassName = mainClassName.substring(k + 1);
            }
            for (DataClass c : toMerge) {
                int newAccess;
                if (c == cls) continue;
                boolean isPublic = this.isPublic(c, toMerge);
                String clzName = c.getName();
                int j = clzName.lastIndexOf("/");
                if (j >= 0) {
                    clzName = clzName.substring(j + 1);
                }
                String prefix = this.createPrefix(clzName, mainClassName);
                for (DataMethod m : c.getMethods()) {
                    DataMethod nm = m.clone(newClass, newAccess = isPublic ? m.getAccess() : this.makePrivate(m.getAccess()), prefix + m.getName());
                    if (!(nm instanceof DataMethodEntryOnly)) continue;
                    nm.setCount(m.getCount());
                }
                for (DataField f : c.getFields()) {
                    newAccess = isPublic ? f.getAccess() : this.makePrivate(f.getAccess());
                    f.clone(newClass, newAccess, prefix + f.getName());
                }
            }
            result.addClass(newClass);
        }
        return result;
    }

    protected DataClass findMainClazz(ArrayList<DataClass> toMerge, String mainClassName) {
        for (DataClass c : toMerge) {
            if (!mainClassName.equals(c.getFullname())) continue;
            return c;
        }
        return toMerge.get(0);
    }

    protected String createPrefix(String className, String mainClassName) {
        if (className.equals(mainClassName)) {
            return "";
        }
        if (className.startsWith(mainClassName + "$")) {
            return className.substring(className.indexOf("$")) + ".";
        }
        return "~" + className + ".";
    }

    private boolean isPublic(DataClass cls, ArrayList<DataClass> peers) {
        ArrayList<DataClass> outers = this.findOuters(cls, peers);
        DataClass outClass = outers.get(outers.size() - 1);
        for (DataClass c : outers) {
            if (this.isPublic(c, outClass)) continue;
            return false;
        }
        return true;
    }

    private boolean isPublic(DataClass c, DataClass outClass) {
        if (this.isAnonymous(c.getName())) {
            return this.isPublicAnonymous(c, outClass);
        }
        return (c.getAccess() & 1) != 0;
    }

    private boolean isPublicAnonymous(DataClass c, DataClass outClass) {
        TreeSet<DataMethod> sortedMethods = new TreeSet<DataMethod>(new Comparator<DataMethod>(){

            @Override
            public int compare(DataMethod dm1, DataMethod dm2) {
                return dm1.getLineTable().get((int)(dm1.getLineTable().size() - 1)).line - dm2.getLineTable().get((int)(dm2.getLineTable().size() - 1)).line;
            }
        });
        for (DataMethod dm : outClass.getMethods()) {
            if (dm.getLineTable() == null) continue;
            sortedMethods.add(dm);
        }
        DataMethod initMethod = c.findMethod("<init>");
        if (sortedMethods != null && initMethod != null) {
            for (DataMethod dataMethod : sortedMethods) {
                if (initMethod.getLineTable().get((int)0).line > dataMethod.getLineTable().get((int)(dataMethod.getLineTable().size() - 1)).line) continue;
                if (dataMethod.getName().equals("<init>") || dataMethod.getName().equals("<clinit>")) {
                    return false;
                }
                return dataMethod.isPublicAPI();
            }
        }
        return false;
    }

    private ArrayList<DataClass> findOuters(DataClass cls, ArrayList<DataClass> peers) {
        ArrayList<DataClass> result = new ArrayList<DataClass>();
        result.add(cls);
        String name = cls.getName();
        for (DataClass c : peers) {
            if (!name.startsWith(c.getName() + "$")) continue;
            result.add(c);
        }
        return result;
    }

    private int makePrivate(int modifiers) {
        return modifiers & 0xFFFFFFFE & 0xFFFFFFFB;
    }

    private boolean isAnonymous(String name) {
        if (name == null) {
            return false;
        }
        int index = name.lastIndexOf("$");
        if (index < 0) {
            return false;
        }
        return Character.isDigit(name.charAt(index + 1));
    }
}

