/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import com.sun.tdk.jcov.instrument.reader.RootReader;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataRootStAX
implements RootReader {
    XMLStreamReader parser;
    DataRoot root;

    public void readData(Object dest) throws FileFormatException {
        this.root = (DataRoot)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            if ("ParseError at [row,col]:[1,1]\nMessage: Premature end of file.".equals(ex.getMessage())) {
                throw new FileFormatException("File is empty");
            }
            if (ex.getMessage() != null) {
                int i = ex.getMessage().indexOf("Message: ");
                if (i < 0) {
                    throw new FileFormatException("Malformed xml file {0} - " + ex.getMessage());
                }
                throw new FileFormatException("Malformed xml file {0} - " + ex.getMessage().substring(i + 9));
            }
            throw new FileFormatException(ex);
        }
    }

    private void readData() throws XMLStreamException, FileFormatException {
        int event = -1;
        while (event != 2) {
            event = this.parser.nextTag();
            switch (event) {
                case 1: {
                    String tagName = this.parser.getLocalName();
                    if (tagName.equals("coverage")) break;
                    if (tagName.equals("head")) {
                        this.readHeader0();
                        break;
                    }
                    if (!tagName.equals("package")) break;
                    this.readPackage();
                    break;
                }
            }
        }
    }

    private void readPackage() throws XMLStreamException, FileFormatException {
        String packName = this.parser.getAttributeValue(null, "name");
        int event = this.parser.getEventType();
        while (true) {
            event = this.parser.nextTag();
            switch (event) {
                case 1: {
                    this.readClass(packName);
                    break;
                }
                case 2: {
                    if (!this.parser.getLocalName().equals("package")) break;
                    return;
                }
            }
        }
    }

    private void readClass(String packName) throws FileFormatException {
        String clName = this.parser.getAttributeValue(null, "name");
        String fullName = packName.isEmpty() ? clName : packName.replaceAll("\\.", "/") + "/" + clName;
        String checksum = this.parser.getAttributeValue(null, "checksum");
        DataClass clazz = new DataClass(this.root.rootId(), fullName, checksum == null ? -1L : Long.parseLong(checksum), this.root.isDifferentiateElements());
        clazz.setInfo(this.parser.getAttributeValue(null, "flags"), this.parser.getAttributeValue(null, "signature"), this.parser.getAttributeValue(null, "supername"), this.parser.getAttributeValue(null, "superInterfaces"));
        String inner = this.parser.getAttributeValue(null, "inner");
        if (inner != null) {
            if ("inner".equals(inner)) {
                clazz.setInner(true);
            } else if ("anon".equals(inner)) {
                clazz.setInner(true);
                clazz.setAnonym(true);
            }
        }
        clazz.readDataFrom();
        this.root.addClass(clazz);
    }

    public void readHeader(Object dest) throws FileFormatException {
        this.root = (DataRoot)dest;
        try {
            this.readHeader();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    private void readHeader() throws XMLStreamException {
        int event = -1;
        boolean readHeader = false;
        while (!readHeader) {
            event = this.parser.nextTag();
            switch (event) {
                case 1: {
                    String tagName = this.parser.getLocalName();
                    if (tagName.equals("coverage")) break;
                    if (tagName.equals("head")) {
                        this.readHeader0();
                        readHeader = true;
                        break;
                    }
                    if (!tagName.equals("package")) break;
                    break;
                }
            }
        }
    }

    private void readHeader0() throws XMLStreamException {
        TreeMap<String, String> props = new TreeMap<String, String>();
        this.parser.nextTag();
        InstrumentationOptions.InstrumentationMode mode = InstrumentationOptions.InstrumentationMode.BRANCH;
        boolean detectInternal = true;
        boolean dynamicCollect = false;
        String[] includes = null;
        String[] excludes = null;
        String[] callerIncludes = null;
        String[] callerExcludes = null;
        while (this.parser.getEventType() != 2) {
            String name = this.parser.getAttributeValue(null, "name");
            String value = this.parser.getAttributeValue(null, "val");
            if (name.equals("coverage.generator.args")) {
                this.root.setArgs(value);
            } else if (name.equals("id.count")) {
                this.root.setCount(Integer.parseInt(value));
            } else if (name.equals("coverage.generator.mode")) {
                mode = InstrumentationOptions.InstrumentationMode.fromString(value);
            } else if (name.equals("coverage.generator.internal")) {
                detectInternal = "detect".equals(value);
            } else if (name.equals("coverage.generator.include")) {
                includes = value.split("\\|");
            } else if (name.equals("coverage.generator.exclude")) {
                excludes = value.split("\\|");
            } else if (name.equals("coverage.generator.caller_include")) {
                callerIncludes = value.split("\\|");
            } else if (name.equals("coverage.generator.caller_exclude")) {
                callerExcludes = value.split("\\|");
            } else if (name.equals("dynamic.collected")) {
                dynamicCollect = Boolean.parseBoolean(value);
            } else if (name.equals("scale.size")) {
                if (this.root.getScaleOpts().needReadScales()) {
                    this.root.getScaleOpts().setScaleSize(Integer.parseInt(value));
                }
            } else if (name.equals("scales.compressed")) {
                this.root.getScaleOpts().setScalesCompressed(Boolean.parseBoolean(value));
            } else {
                props.put(name, value);
            }
            this.parser.nextTag();
            this.parser.nextTag();
        }
        InstrumentationOptions.ABSTRACTMODE abstractmode = null;
        boolean instrumentNative = false;
        boolean instrumentFields = false;
        this.root.setParams(new InstrumentationParams(dynamicCollect, instrumentNative, instrumentFields, detectInternal, abstractmode, includes, excludes, callerIncludes, callerExcludes, mode));
        this.root.setXMLHeadProperties(props);
    }

    public void setReaderFactory(ReaderFactory r) {
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

