/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.DataAbstract;
import com.sun.tdk.jcov.instrument.DataMethodWithBlocks;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.LocationRef;
import com.sun.tdk.jcov.instrument.SimpleBasicBlock;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataMethodWithBlocksStAX
implements Reader {
    private DataMethodWithBlocks meth;
    private XMLStreamReader parser;
    private ReaderFactory rf;

    public void readData(Object dest) throws FileFormatException {
        this.meth = (DataMethodWithBlocks)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    void readData() throws XMLStreamException, FileFormatException {
        LinkedList<BasicBlock> blocks = new LinkedList<BasicBlock>();
        HashMap refs = new HashMap();
        this.rf.setProcessingData(refs);
        while (this.parser.getEventType() != 2 || !"meth".equals(this.parser.getLocalName())) {
            String elem = this.parser.getLocalName();
            if ("bl".equals(elem)) {
                BasicBlock bb;
                InstrumentationOptions.InstrumentationMode mode = DataRoot.getInstance(this.meth.rootId()).getParams().getMode();
                if (mode.equals((Object)InstrumentationOptions.InstrumentationMode.BLOCK)) {
                    int start = Integer.parseInt(this.parser.getAttributeValue(null, "s"));
                    int end = Integer.parseInt(this.parser.getAttributeValue(null, "e"));
                    bb = new SimpleBasicBlock(this.meth.rootId(), start, end, false);
                } else {
                    bb = new BasicBlock(this.meth.rootId());
                }
                bb.readDataFrom();
                blocks.add(bb);
            } else if ("methenter".equals(elem)) {
                int start = 0;
                String s = this.parser.getAttributeValue(null, "s");
                if (s != null) {
                    start = Integer.parseInt(s);
                }
                int end = 0;
                s = this.parser.getAttributeValue(null, "e");
                if (s != null) {
                    end = Integer.parseInt(s);
                }
                SimpleBasicBlock bb = new SimpleBasicBlock(this.meth.rootId(), start, end, false);
                bb.readDataFrom();
                blocks.add(bb);
            } else if ("crt".equals(elem)) {
                this.meth.setCharacterRangeTable(new CharacterRangeTableAttribute(this.meth.rootId()));
                this.meth.getCharacterRangeTable().readDataFrom();
            } else {
                Reader r = this.rf.getSuperReaderFor(DataMethodWithBlocks.class);
                r.readData(this.meth);
            }
            this.parser.nextTag();
        }
        block1: for (DataAbstract.LocationCoords c : refs.keySet()) {
            for (BasicBlock b : blocks) {
                if (b.startBCI() != c.start || b.endBCI() != c.end) continue;
                for (LocationRef ref : (List)refs.get(c)) {
                    ref.setConcreteLocation(b);
                }
                continue block1;
            }
        }
        this.meth.setBasicBlocks(blocks.toArray(new BasicBlock[blocks.size()]));
    }

    public void setReaderFactory(ReaderFactory r) {
        this.rf = r;
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

