/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;

public class InstrumentationOptions {
    public static final OptionDescr DSC_TYPE = new OptionDescr("type", "Type of template.", new String[][]{{"all", "full information"}, {"branch", "only branches"}, {"block", "only block"}, {"method", "only methods"}}, "Create statistics only for the specified type", "all");
    public static final String XML_DEFAULT_TEMPLATE = "template.xml";
    public static final OptionDescr DSC_TEMPLATE = new OptionDescr("template", new String[]{"t"}, "Pre-instrumented template specification.", 1, "Specifies file with xml based template of pre-instrumented classes. Each classfile presented\n in this template should be statically instrumented. The instrumentation parameters should be\ncompatible for static and dynamic instrumentation.", "template.xml");
    public static final OptionDescr DSC_INCLUDE = new OptionDescr("include", new String[]{"i"}, "Filtering conditions.", 2, "Specify included classes by regular expression.");
    public static final OptionDescr DSC_EXCLUDE = new OptionDescr("exclude", new String[]{"e"}, "", 2, "Specify excluded classes by regular expression.");
    public static final OptionDescr DSC_INCLUDE_LIST = new OptionDescr("include_list", "", 1, "Specify the path to the file containing include list. The effect will be the same as\nusing multiple -include options. File should contain one class name mask per line.");
    public static final OptionDescr DSC_EXCLUDE_LIST = new OptionDescr("exclude_list", "", 1, "Specify the path to the file containing exclude list. The effect will be the same as\nusing multiple -exclude options. File should contain one class name mask per line.");
    public static final OptionDescr DSC_FM = new OptionDescr("fm", "", 2, "Class must have <modifier> to be included in report");
    public static final OptionDescr DSC_FM_LIST = new OptionDescr("fm_list", "", 1, "Specify the path to the file containing modifiers list. The \neffect will be the same as using multiple -fm options.\nFile should contain one class name mask per line.");
    public static final OptionDescr DSC_CALLER_INCLUDE = new OptionDescr("caller_include", new String[]{"ci"}, "", 2, "Specify caller filter classes by regular expression.", ".*");
    public static final OptionDescr DSC_CALLER_EXCLUDE = new OptionDescr("caller_exclude", new String[]{"ce"}, "", 2, "Specify caller filter classes by regular expression.", "");
    public static final OptionDescr DSC_ABSTRACT = new OptionDescr("abstract", "Specify which items should be additionally included in template.", new String[][]{{"on", "abstract methods are counted by their direct invocation"}, {"off", "abstract methods are not counted and not included int report"}}, "Specify should be abstract method included in template.", "off");
    public static final OptionDescr DSC_NATIVE = new OptionDescr("native", "", new String[][]{{"on", "native methods are counted and included in report"}, {"off", "native methods are not counted and not included int report"}}, "Specify should be native method included in template.", "on");
    public static final OptionDescr DSC_FIELD = new OptionDescr("field", "", new String[][]{{"on", "field reading is counted"}, {"off", "field coverage is not counted, fields are not included in report"}}, "Specify should be fields included in template.", "off");
    public static final OptionDescr DSC_SYNTHETIC = new OptionDescr("synthetic", "", new String[][]{{"on", "synthetic methods are counted"}, {"off", "synthetic methods are not counted and are not included in report"}}, "Specify should be synthetic methods included in template.", "on");
    public static final OptionDescr DSC_ANONYM = new OptionDescr("anonym", "", new String[][]{{"on", "anonymous classes are counted"}, {"off", "anonymous classes are not counted and are not included in report"}}, "Allows to filter anonymous classes", "on");
    public static final OptionDescr DSC_CLASSESRELOAD = new OptionDescr("classesreload", "", new String[][]{{"on", "classes could be reloaded. Hash is needed in dynamic mode"}, {"off", "classes will not be reloaded"}}, "Allows to keep instrumented classes for reusing", "off");
    public static final OptionDescr DSC_MERGE = new OptionDescr("merge", "", new String[][]{{"merge", "standard merge (summary coverage)"}, {"overwrite", "overwrite existing file"}, {"gensuff", "generate suffix as current time in milliseconds"}, {"scale", "scaled merge (coverage information for individual tests is available)"}}, "Specify behaviour if output file already exists. Doesn't affects network-based\nsaving. The merge and scale methods could cause errors if existing file could not be read.", "merge");
    public static final OptionDescr DSC_SAVE_BEGIN = new OptionDescr("savebegin", "Save points.", 2, "Initiate saving Jcov data at the beginning of each method  specified by this regexp ,\nbefore the first instruction of the method is executed. The signature of method doen't used.");
    public static final OptionDescr DSC_SAVE_AT_END = new OptionDescr("saveatend", "", 2, "Work similar savebegin, however save before last instruction in the method is executed (throw or return).\nThis method doesn't work if exception was thrown not directly in this method.");
    public static final OptionDescr DSC_INNERINVOCATION = new OptionDescr("innerinvocation", "", new String[][]{{"on", "count inner invocations in the product"}, {"off", "count only invocations outside the instrumented product"}}, "Allows to filter inner invocations in the instrumented product", "on");
    public static final String nativePrefix = "$$generated$$_";

    public static String concatRegexps(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        String result = "";
        for (String arg : args) {
            result = result + "|" + arg;
        }
        return result.substring(1);
    }

    public static boolean isSkipped(String className, String methodName, int modifier) {
        return className.equals("java/lang/Thread") && (methodName.equals("currentThread") || methodName.equals("getId"));
    }

    public static String[] handleInclude(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String[] s;
        TreeSet<String> includeSet = new TreeSet<String>();
        if (opts.isSet(DSC_INCLUDE) && (s = opts.getValues(DSC_INCLUDE)) != null) {
            includeSet.addAll(Arrays.asList(s));
        }
        if (opts.isSet(DSC_INCLUDE_LIST)) {
            try {
                s = Utils.readLines(opts.getValue(DSC_INCLUDE_LIST));
                if (s != null) {
                    includeSet.addAll(Arrays.asList(s));
                }
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Error while reading include list " + opts.getValue(DSC_INCLUDE_LIST), ex);
            }
        }
        return includeSet.toArray(new String[includeSet.size()]);
    }

    public static String[] handleExclude(EnvHandler opts) throws JCovTool.EnvHandlingException {
        TreeSet<String> excludeSet = new TreeSet<String>();
        String[] s = opts.getValues(DSC_EXCLUDE);
        if (s != null) {
            excludeSet.addAll(Arrays.asList(s));
        }
        if (opts.isSet(DSC_EXCLUDE_LIST)) {
            try {
                s = Utils.readLines(opts.getValue(DSC_EXCLUDE_LIST));
                if (s != null) {
                    excludeSet.addAll(Arrays.asList(s));
                }
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Error while reading exclude list " + opts.getValue(DSC_EXCLUDE_LIST), ex);
            }
        }
        return excludeSet.toArray(new String[excludeSet.size()]);
    }

    public static String[] handleFM(EnvHandler opts) throws JCovTool.EnvHandlingException {
        String[] s;
        TreeSet<String> fmSet = new TreeSet<String>();
        if (opts.isSet(DSC_FM) && (s = opts.getValues(DSC_FM)) != null) {
            fmSet.addAll(Arrays.asList(s));
        }
        if (opts.isSet(DSC_FM_LIST)) {
            try {
                s = Utils.readLines(opts.getValue(DSC_FM_LIST));
                if (s != null) {
                    fmSet.addAll(Arrays.asList(s));
                }
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Error while reading exclude list " + opts.getValue(DSC_EXCLUDE_LIST), ex);
            }
        }
        return fmSet.toArray(new String[fmSet.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MERGE {
        OVERWRITE,
        MERGE,
        SCALE,
        GEN_SUFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstrumentationMode {
        METHOD,
        BLOCK,
        BRANCH;


        public static InstrumentationMode fromString(String mode) {
            if (mode.equalsIgnoreCase("method")) {
                return METHOD;
            }
            if (mode.equalsIgnoreCase("block")) {
                return BLOCK;
            }
            if (mode.equalsIgnoreCase("branch")) {
                return BRANCH;
            }
            if (mode.equalsIgnoreCase("all")) {
                return BRANCH;
            }
            throw new Error("Unknown instrumentation type.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ABSTRACTMODE {
        NONE,
        IMPLEMENTATION,
        DIRECT;

    }
}

