/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.BasicBlock;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.SimpleBasicBlock;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.tools.DelegateIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMethodWithBlocks
extends DataMethod {
    private int bytecodeLength;
    private CharacterRangeTableAttribute characterRangeTable = null;
    private BasicBlock[] basicBlocks;

    public DataMethodWithBlocks(DataClass k, int access, String name, String desc, String signature, String[] exceptions) {
        super(k, access, name, desc, signature, exceptions, false);
    }

    @Override
    public DataMethod clone(DataClass newClass, int newAccess, String newName) {
        DataMethodWithBlocks dm = new DataMethodWithBlocks(newClass, newAccess, newName, this.getVmSignature(), this.getSignature(), this.getExceptions());
        dm.setBasicBlocks(this.getBasicBlocks());
        dm.setCharacterRangeTable(this.getCharacterRangeTable());
        dm.setBytecodeLength(this.getBytecodeLength());
        dm.lineTable = this.getLineTable();
        return dm;
    }

    public void setBasicBlocks(BasicBlock[] basicBlocks) {
        this.basicBlocks = basicBlocks;
    }

    public BasicBlock[] getBasicBlocks() {
        return this.basicBlocks;
    }

    public int getBytecodeLength() {
        return this.bytecodeLength;
    }

    public void setBytecodeLength(int bytecodeLength) {
        this.bytecodeLength = bytecodeLength;
    }

    public void setCharacterRangeTable(CharacterRangeTableAttribute crt) {
        this.characterRangeTable = crt;
    }

    public CharacterRangeTableAttribute getCharacterRangeTable() {
        return this.characterRangeTable;
    }

    @Override
    public boolean hasCRT() {
        return this.getCharacterRangeTable() != null;
    }

    @Override
    public boolean wasHit() {
        return this.getBasicBlocks() == null ? false : this.getBasicBlocks()[0].wasHit();
    }

    @Override
    public long getCount() {
        return this.getBasicBlocks() == null ? 0L : (this.getBasicBlocks()[0].blocks().isEmpty() ? -1L : this.getBasicBlocks()[0].blocks().iterator().next().getCount());
    }

    @Override
    public void setCount(long count) {
        if (this.getBasicBlocks() != null && !this.getBasicBlocks()[0].blocks().isEmpty()) {
            this.getBasicBlocks()[0].blocks().iterator().next().setCount(count);
        }
    }

    @Override
    public Scale getScale() {
        return this.getBasicBlocks() == null ? null : (this.getBasicBlocks()[0].blocks().isEmpty() ? null : this.getBasicBlocks()[0].blocks().iterator().next().scale);
    }

    @Override
    public int getSlot() {
        return this.getBasicBlocks() == null ? -1 : (this.getBasicBlocks()[0].blocks().isEmpty() ? -1 : this.getBasicBlocks()[0].blocks().iterator().next().slot);
    }

    @Override
    void xmlAttrs(XmlContext ctx) {
        super.xmlAttrs(ctx);
        ctx.attr("length", this.getBytecodeLength());
    }

    @Override
    void xmlBody(XmlContext ctx) {
        if (this.getBasicBlocks() != null) {
            for (BasicBlock bb : this.getBasicBlocks()) {
                bb.xmlGen(ctx);
            }
        }
        if (ctx.showLineTable && this.getLineTable() != null) {
            this.xmlLineTable(ctx);
        }
        if (ctx.showRangeTable && this.getCharacterRangeTable() != null) {
            this.getCharacterRangeTable().xmlGen(ctx);
        }
    }

    @Override
    public void checkCompatibility(DataMethod other, String trace) throws MergeException {
        if (!(other instanceof DataMethodWithBlocks)) {
            throw new MergeException("Method has other type than it's merging copy, expected DataMethodWithBlocks; found " + other.getClass().getSimpleName(), trace, 0);
        }
        DataMethodWithBlocks m = (DataMethodWithBlocks)other;
        if (this.getBasicBlocks().length != m.getBasicBlocks().length) {
            throw new MergeException("Method has other number of basic blocks than it's merging copy, the number is " + this.getBasicBlocks().length, trace, 0);
        }
        block2: for (BasicBlock bb : this.getBasicBlocks()) {
            for (BasicBlock bbo : m.getBasicBlocks()) {
                if (bb.startBCI() != bbo.startBCI() && bb.endBCI() != bbo.endBCI()) continue;
                if (bb.startBCI() == bbo.startBCI() && bb.endBCI() == bbo.endBCI()) {
                    try {
                        bb.checkCompatibility(bbo);
                        continue block2;
                    }
                    catch (MergeException e) {
                        e.location = trace + ", block " + bb.startBCI() + "-" + bb.endBCI() + e.location;
                        throw e;
                    }
                }
                System.err.println("* WARNING *: block ranges are invalid in " + trace + ": [" + bbo.startBCI() + "; " + bbo.endBCI() + "] (expected [" + bb.startBCI() + "; " + bb.endBCI() + "]). This can mean that you are merging results from different product versions.");
            }
        }
    }

    @Override
    public void merge(DataMethod other) {
        DataMethodWithBlocks m = (DataMethodWithBlocks)other;
        block0: for (BasicBlock bb : this.getBasicBlocks()) {
            for (BasicBlock bbo : m.getBasicBlocks()) {
                if (bb.startBCI() != bbo.startBCI() || bb.endBCI() != bbo.endBCI()) continue;
                bb.merge(bbo);
                continue block0;
            }
        }
    }

    void printDebug(PrintStream out, String indent) {
        out.print(indent);
        out.println("Method: " + this.getName());
        String newIndent = indent + "    ";
        for (BasicBlock bb : this.getBasicBlocks()) {
            bb.printDebug(out, newIndent);
        }
    }

    @Override
    public Iterator<DataBlock> iterator() {
        return new DelegateIterator<DataBlock>(){
            private int i;

            @Override
            protected Iterator<DataBlock> nextIterator() {
                if (this.i < DataMethodWithBlocks.this.getBasicBlocks().length) {
                    return DataMethodWithBlocks.this.getBasicBlocks()[this.i++].getIterator();
                }
                return null;
            }
        };
    }

    @Override
    public List<DataBlock> getBlocks() {
        LinkedList<DataBlock> blocks = new LinkedList<DataBlock>();
        for (BasicBlock bb : this.basicBlocks) {
            for (DataBlock db : bb.blocks()) {
                blocks.add(db);
            }
        }
        return blocks;
    }

    @Override
    public List<DataBranch> getBranches() {
        LinkedList<DataBranch> branches = new LinkedList<DataBranch>();
        for (BasicBlock bb : this.basicBlocks) {
            if (!(bb.exit instanceof DataBranch)) continue;
            branches.add((DataBranch)bb.exit);
        }
        return branches;
    }

    @Override
    public List<DataBlockTarget> getBranchTargets() {
        LinkedList<DataBlockTarget> targets = new LinkedList<DataBlockTarget>();
        for (BasicBlock bb : this.basicBlocks) {
            if (!(bb.exit instanceof DataBranch)) continue;
            DataBranch br = (DataBranch)bb.exit;
            for (DataBlockTarget db : br.branchTargets) {
                targets.add(db);
            }
        }
        return targets;
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeShort(this.bytecodeLength);
        out.writeShort(this.basicBlocks.length);
        for (int i = 0; i < this.basicBlocks.length; ++i) {
            if (this.basicBlocks[i] instanceof SimpleBasicBlock) {
                out.write(1);
            } else {
                out.write(2);
            }
            this.basicBlocks[i].writeObject(out);
        }
    }

    DataMethodWithBlocks(DataClass parent, DataInput in) throws IOException {
        super(parent, in);
        this.bytecodeLength = in.readShort();
        int bblen = in.readShort();
        this.basicBlocks = new BasicBlock[bblen];
        block4: for (int i = 0; i < bblen; ++i) {
            byte code = in.readByte();
            switch (code) {
                case 1: {
                    this.basicBlocks[i] = new SimpleBasicBlock(this.rootId, in);
                    continue block4;
                }
                case 2: {
                    this.basicBlocks[i] = new BasicBlock(this.rootId, in);
                    continue block4;
                }
                default: {
                    throw new IOException("BasicBlock with unknown code in DataMethodWithBlocks " + code);
                }
            }
        }
    }
}

